/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.tabelas;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.DataUtil;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.repositorio.RepositorioException;

public class TabelaDatasIRPF {
    private static Map<String, String> datas = new HashMap<String, String>();
    private static CadastroTabelasIRPF.RepositorioTabelasBasicasIRPF repositorioTabelasBasicas = new CadastroTabelasIRPF.RepositorioTabelasBasicasIRPF();
    public static final String NOME_ARQUIVO_DATAS_IRPF = "resources/datasIrpf.xml";

    public static int getQuantidadeMaxQuotas() {
        try {
            String quantidadeQuotas = TabelaDatasIRPF.getDatas().get("quantidadeQuotas");
            return Integer.valueOf(quantidadeQuotas);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static Map<String, String> getDatas() {
        if (datas.isEmpty()) {
            TabelaDatasIRPF.carregarDatas();
        }
        return datas;
    }

    public static String[] obterVencimentosQuotas(boolean calamidade) {
        Object keyDataVencimentoQuota = "dataVencimentoQuota";
        if (calamidade) {
            keyDataVencimentoQuota = (String)keyDataVencimentoQuota + "Calamidade";
        }
        String[] quotas = TabelaDatasIRPF.getDatas().get(keyDataVencimentoQuota).split("\\;");
        String[] vencimentoQuotas = new String[quotas.length];
        for (int i = 0; i < quotas.length; ++i) {
            vencimentoQuotas[i] = DataUtil.formatarDataSemBarras(TabelaDatasIRPF.stringToDate(quotas[i]));
        }
        return vencimentoQuotas;
    }

    public static String[] obterVencimentosQuotasComBarra(boolean calamidade) {
        Object keyDataVencimentoQuota = "dataVencimentoQuota";
        if (calamidade) {
            keyDataVencimentoQuota = (String)keyDataVencimentoQuota + "Calamidade";
        }
        String[] quotas = TabelaDatasIRPF.getDatas().get(keyDataVencimentoQuota).split("\\;");
        String[] vencimentoQuotas = new String[quotas.length];
        for (int i = 0; i < quotas.length; ++i) {
            vencimentoQuotas[i] = DataUtil.formatarData(TabelaDatasIRPF.stringToDate(quotas[i]));
        }
        return vencimentoQuotas;
    }

    public static void carregarDatas() {
        ArrayList<ElementoTabela> colecaoDatas = new ArrayList<ElementoTabela>();
        try {
            repositorioTabelasBasicas.recuperarObjetosTabela(NOME_ARQUIVO_DATAS_IRPF, colecaoDatas, true);
            datas.clear();
            for (ElementoTabela et : colecaoDatas) {
                datas.put(et.getConteudo(0), et.getConteudo(1));
            }
        }
        catch (RepositorioException e) {
            FabricaTratamentoErro.getTrataErroSistemico().trataErroSistemico((Throwable)e);
        }
    }

    public static String obterPrimeiroDiaAposDataLimiteDebitoAutomatico(boolean calamidade) {
        String dataLimiteDebito = ConstantesDatas.dataLimiteDebitoAutomatico.getDataFormatada();
        if (calamidade) {
            dataLimiteDebito = ConstantesDatas.dataLimiteDebitoAutomaticoCalamidade.getDataFormatada();
        }
        String data = DataUtil.obterPrimeiroDiaAposDataInformada(dataLimiteDebito);
        return data;
    }

    public static String obterDataReaberturaEntregaFormatada(boolean calamidade) {
        String dataReaberturaEntrega = ConstantesDatas.dataReaberturaEntrega.getDataFormatada();
        if (calamidade) {
            dataReaberturaEntrega = ConstantesDatas.dataReaberturaEntregaCalamidade.getDataFormatada();
        }
        return dataReaberturaEntrega;
    }

    public static String obterDataReaberturaEntregaNaoFormatada(boolean calamidade) {
        String dataReaberturaEntrega = ConstantesDatas.dataReaberturaEntrega.getDataNaoFormatada();
        if (calamidade) {
            dataReaberturaEntrega = ConstantesDatas.dataReaberturaEntregaCalamidade.getDataNaoFormatada();
        }
        return dataReaberturaEntrega;
    }

    public static Date stringToDate(String data) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date date = null;
        try {
            date = formatter.parse(data);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getHash() {
        return repositorioTabelasBasicas.getCRC(NOME_ARQUIVO_DATAS_IRPF);
    }

    public static String getVersao() {
        return repositorioTabelasBasicas.getVigencia(NOME_ARQUIVO_DATAS_IRPF);
    }

    public static enum ConstantesDatas {
        dataFimRecepcao,
        dataFimRecepcaoCalamidade,
        dataLimiteDebitoAutomatico,
        dataLimiteDebitoAutomaticoCalamidade,
        dataReaberturaEntrega,
        dataReaberturaEntregaCalamidade;


        public String getDataFormatada() {
            StringBuilder conteudo = new StringBuilder(TabelaDatasIRPF.getDatas().get(this.name()));
            return DataUtil.formatarData(TabelaDatasIRPF.stringToDate(conteudo.toString()));
        }

        public String getDataNaoFormatada() {
            StringBuilder conteudo = new StringBuilder(TabelaDatasIRPF.getDatas().get(this.name()));
            return DataUtil.formatarDataSemBarras(TabelaDatasIRPF.stringToDate(conteudo.toString()));
        }
    }
}

