/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util;

import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.RetornoValidacao;

public class ValidadorIRPF {
    public static RetornoValidacao validarDataNascimento(Informacao data, int anoLimite) {
        int inAno;
        int inMes;
        int inDia;
        if (data.formatado() == null || data.formatado().equals("  /  /    ")) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        int maxDia = 31;
        StringTokenizer tokenizer = new StringTokenizer(data.formatado(), "/");
        if (tokenizer.countTokens() != 3) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        String token = tokenizer.nextToken();
        try {
            inDia = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_dia_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        token = tokenizer.nextToken();
        try {
            inMes = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_mes_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        token = tokenizer.nextToken();
        try {
            inAno = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inMes < 1 || inMes > 12) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_mes_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        maxDia = ValidadorIRPF.calculaDiasMes(inMes, inAno);
        if (inAno < 1851) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inDia > maxDia && (inDia != 29 || inMes != 2)) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_dia_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inAno > 1851 && !new GregorianCalendar().isLeapYear(inAno) && inMes == 2 && inDia == 29) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_dia_bissexto", new String[]{data.getNomeCampo()}), 2);
        }
        if (inAno >= 1851 || inAno <= 1900) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_1900", new String[]{data.getNomeCampo()}), 2);
        }
        if (inAno <= 0 || inAno >= anoLimite || inAno < 1851 && inAno != 0) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inDia <= 0 || inDia > maxDia) {
            if (maxDia == 28 && inDia == 29) {
                return new RetornoValidacao(MensagemUtil.getMensagem("data_dia_bissexto", new String[]{data.getNomeCampo()}), 2);
            }
            return new RetornoValidacao(MensagemUtil.getMensagem("data_dia_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inAno <= 0 || inAno >= anoLimite || inAno < 1851 && inAno != 0) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inAno < 1901 && inAno > 1850) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_1900", new String[]{data.getNomeCampo()}), 2);
        }
        return null;
    }

    public static RetornoValidacao validarData(Informacao data, int anoLimite) {
        int inAno;
        int inMes;
        int inDia;
        if (data.formatado() == null || data.formatado().equals("  /  /    ")) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        int maxDia = 31;
        StringTokenizer tokenizer = new StringTokenizer(data.formatado(), "/");
        if (tokenizer.countTokens() != 3) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        String token = tokenizer.nextToken();
        try {
            inDia = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        token = tokenizer.nextToken();
        try {
            inMes = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        token = tokenizer.nextToken();
        try {
            inAno = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        if (inMes <= 0 || inMes >= 13) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        if (inAno <= 0 || inAno >= anoLimite) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_posterior_ano_calendario", new String[]{data.getNomeCampo()}), 3);
        }
        if (inAno < 1851 && inAno != 0) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_anterior_a_limite", new String[]{data.getNomeCampo(), "1851"}), 3);
        }
        maxDia = ValidadorIRPF.calculaDiasMes(inMes, inAno);
        if (inDia <= 0 || inDia > maxDia) {
            if (maxDia == 28 && inDia == 29) {
                return new RetornoValidacao(MensagemUtil.getMensagem("data_dia_bissexto", new String[]{data.getNomeCampo()}), 2);
            }
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        if (inAno <= 0 || inAno >= anoLimite || inAno < 1851 && inAno != 0) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inAno < 1901 && inAno > 1850) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_1900", new String[]{data.getNomeCampo()}), 2);
        }
        return null;
    }

    public static RetornoValidacao validarData(Informacao data) {
        int inAno;
        int inMes;
        int inDia;
        if (data.formatado() == null || data.formatado().equals("  /  /    ")) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        int maxDia = 31;
        StringTokenizer tokenizer = new StringTokenizer(data.formatado(), "/");
        if (tokenizer.countTokens() != 3) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_invalida", new String[]{data.getNomeCampo()}), 3);
        }
        String token = tokenizer.nextToken();
        try {
            inDia = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_dia_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        token = tokenizer.nextToken();
        try {
            inMes = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_mes_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        token = tokenizer.nextToken();
        try {
            inAno = Integer.parseInt(token);
        }
        catch (Exception e) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inMes <= 0 || inMes >= 13) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_mes_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        int exercicioWord = Integer.parseInt(ConstantesGlobais.EXERCICIO);
        if (inAno <= 0 || inAno >= exercicioWord || inAno < 1850 && inAno != 0) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inAno < 1901 && inAno > 1850) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_1900", new String[]{data.getNomeCampo()}), 2);
        }
        maxDia = ValidadorIRPF.calculaDiasMes(inMes, inAno);
        if (inDia <= 0 || inDia > maxDia) {
            if (maxDia == 28 && inDia == 29) {
                return new RetornoValidacao(MensagemUtil.getMensagem("data_dia_invalido", new String[]{data.getNomeCampo()}), 2);
            }
            return new RetornoValidacao(MensagemUtil.getMensagem("data_dia_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        if (inAno > Integer.parseInt(ConstantesGlobais.ANO_BASE)) {
            return new RetornoValidacao(MensagemUtil.getMensagem("data_ano_invalido", new String[]{data.getNomeCampo()}), 3);
        }
        return null;
    }

    private static int calculaDiasMes(int mes, int ano) {
        int retorno = 31;
        switch (mes) {
            case 1: {
                retorno = 31;
                break;
            }
            case 2: {
                GregorianCalendar calendar = new GregorianCalendar();
                if (calendar.isLeapYear(ano)) {
                    retorno = 29;
                    break;
                }
                retorno = 28;
                break;
            }
            case 3: {
                retorno = 31;
                break;
            }
            case 4: {
                retorno = 30;
                break;
            }
            case 5: {
                retorno = 31;
                break;
            }
            case 6: {
                retorno = 30;
                break;
            }
            case 7: {
                retorno = 31;
                break;
            }
            case 8: {
                retorno = 31;
                break;
            }
            case 9: {
                retorno = 30;
                break;
            }
            case 10: {
                retorno = 31;
                break;
            }
            case 11: {
                retorno = 30;
                break;
            }
            case 12: {
                retorno = 31;
            }
        }
        return retorno;
    }
}

