/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.calculos;

import java.lang.reflect.Field;
import java.util.List;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.util.calculos.CampoInformacao;
import serpro.ppgd.irpf.util.calculos.FichaInformacao;
import serpro.ppgd.irpf.util.calculos.ListaFichaInformacao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

@FichaInformacao
public class DeclaracaoMultiExercicio
extends ObjetoNegocio {
    private RendPJ rendPJ = new RendPJ();

    public RendPJ getRendPJ() {
        return this.rendPJ;
    }

    public static void calculaMaiorFontePagadora(DetalheRendPJ[] ficha, String nomeCampo, NI[] niMaiorFontePagadora, Valor[] rendRecebidoPJ, Integer qtdItens) {
        System.out.println("\n--- calculaMaiorFontePagadora() --------------------------------");
        System.out.println("\tQuantidade Itens:" + qtdItens);
        Valor valorMaior = new Valor();
        String niMaiorFonte = "";
        for (int i = 0; i < niMaiorFontePagadora.length && i < rendRecebidoPJ.length; ++i) {
            System.out.println("\tni = " + niMaiorFontePagadora[i].formatado() + " | Valor = " + rendRecebidoPJ[i].formatado());
            if (!valorMaior.comparacao("<", rendRecebidoPJ[i])) continue;
            valorMaior.setConteudo(rendRecebidoPJ[i]);
            niMaiorFonte = niMaiorFontePagadora[i].formatado();
        }
        System.out.println("-- Maior Fonte: " + niMaiorFonte + " | Valor = " + valorMaior.formatado());
        for (DetalheRendPJ detalheRendPJ : ficha) {
            System.out.println("\n-- " + nomeCampo + " = " + niMaiorFonte + " | valor = " + detalheRendPJ.getRendRecebidoPJ().formatado());
        }
    }

    public static void atualizarNomeFonte(DeclaracaoMultiExercicio dec, String idCampo, Integer idDetalheRendPJ) {
        System.out.println("\n--- atualizarNomeFonte(" + idCampo + ") --------------------------------");
        System.out.println("\t idDetalheRendPJ = " + idDetalheRendPJ);
        System.out.println("-- " + idCampo);
    }

    public static void calcularTotalRendRecebidoPJ(RendPJ ficha, String nomeCampo, Valor totaisRendRecebidoPJTitular, Valor totaisRendRecebidoPJDependente) {
        System.out.println("\n--- calcularTotalRendRecebPessoaJuridica() --------------------------------");
        System.out.println("\t totaisRendRecebidoPJTitular = " + totaisRendRecebidoPJTitular);
        System.out.println("\t totaisRendRecebidoPJDependente = " + totaisRendRecebidoPJDependente);
        Valor total = new Valor();
        total.append('+', totaisRendRecebidoPJTitular);
        total.append('+', totaisRendRecebidoPJDependente);
        System.out.println("-- " + nomeCampo + " = " + total);
        ficha.getTotalRendRecebPessoaJuridica().setConteudo(total);
    }

    public static void calcularTotalRendRecebidoPJ(DeclaracaoMultiExercicio dec, String idCampo) {
        System.out.println("\n--- calcularTotalRendRecebPessoaJuridica(" + idCampo + ") ---");
        System.out.println("\t totaisRendRecebidoPJTitular = " + dec.getRendPJ().getColecaoRendPJTitular().getTotaisRendRecebidoPJ());
        System.out.println("\t totaisRendRecebidoPJDependente = " + dec.getRendPJ().getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        Valor total = new Valor();
        total.append('+', dec.getRendPJ().getColecaoRendPJTitular().getTotaisRendRecebidoPJ());
        total.append('+', dec.getRendPJ().getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        System.out.println("-- " + idCampo + " = " + total);
        dec.getRendPJ().getTotalRendRecebPessoaJuridica().setConteudo(total);
    }

    public static void calcularTotalRendRecebidoPJParcial(DeclaracaoMultiExercicio dec, String idCampo) {
        System.out.println("\n--- calcularTotalRendRecebidoPJParcial(" + idCampo + ") ---");
        Valor total = new Valor();
        List itens = null;
        Valor resultado = null;
        if ("dec.rendPJ.colecaoRendPJTitular.totaisRendRecebidoPJ".equals(idCampo)) {
            itens = dec.getRendPJ().getColecaoRendPJTitular().itens();
            resultado = dec.getRendPJ().getColecaoRendPJTitular().getTotaisRendRecebidoPJ();
        } else if ("dec.rendPJ.colecaoRendPJDependente.totaisRendRecebidoPJ".equals(idCampo)) {
            itens = dec.getRendPJ().getColecaoRendPJDependente().itens();
            resultado = dec.getRendPJ().getColecaoRendPJDependente().getTotaisRendRecebidoPJ();
        }
        for (DetalheRendPJ item : itens) {
            System.out.println("\t Valor (" + item.getRendRecebidoPJ().getNomeCampo().replaceAll("\\s", "_") + ") = " + item.getRendRecebidoPJ().formatado());
            total.append('+', (Valor)item.getRendRecebidoPJ());
        }
        System.out.println("-- " + idCampo + " = " + total);
        resultado.setConteudo(total);
    }

    public static void calcularTotalRendRecebidoPJParcial(ColecaoRendPJ ficha, String nomeCampo, Valor[] valores, Integer qtdItens) {
        DeclaracaoMultiExercicio.calcularSomatorio((Object)ficha, nomeCampo, valores, qtdItens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calcularSomatorio(Object ficha, String nomeCampo, Valor[] valores, Integer qtdItens) {
        System.out.println("\n--- calcularSomatorio() --------------------------------");
        System.out.println("Quantidade de elementos: " + qtdItens);
        Valor total = new Valor();
        for (Valor valor : valores) {
            System.out.println("\t Valor (" + valor.getNomeCampo().replaceAll("\\s", "_") + ") = " + valor);
            total.append('+', valor);
        }
        System.out.println("-- " + nomeCampo + " = " + total);
        Field field = DeclaracaoMultiExercicio.getField(ficha.getClass(), nomeCampo);
        if (field != null) {
            try {
                boolean acces = field.isAccessible();
                field.setAccessible(true);
                try {
                    Object obj = field.get(ficha);
                    if (Valor.class.isAssignableFrom(obj.getClass())) {
                        Valor valor;
                        valor = (Valor)obj;
                        valor.setConteudo(total);
                    }
                }
                finally {
                    field.setAccessible(acces);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public static Field getField(Class<?> c, String name) {
        try {
            return c.getDeclaredField(name);
        }
        catch (Exception e) {
            if (c.getSuperclass() != null) {
                return DeclaracaoMultiExercicio.getField(c.getSuperclass(), name);
            }
            return null;
        }
    }

    @FichaInformacao
    public class DetalheRendPJ
    extends ObjetoNegocio {
        @CampoInformacao(dependencias={".NIFontePagadora"}, classeAtualizacao=DeclaracaoMultiExercicio.class, metodoAtualizacao="atualizarNomeFonte")
        protected Alfa nomeFontePagadora = new Alfa((ObjetoNegocio)this, "Nome da Fonte Pagadora");
        @CampoInformacao
        protected NI NIFontePagadora = new NI((ObjetoNegocio)this, "CPF/CNPJ da Fonte Pagadora");
        @CampoInformacao
        protected ValorPositivo rendRecebidoPJ = new ValorPositivo(this, "Rendimentos Recebidos de Pessoa Jur\u00eddica");
        @CampoInformacao
        protected ValorPositivo contribuicaoPrevOficial = new ValorPositivo(this, "Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial");
        @CampoInformacao
        protected ValorPositivo impostoRetidoFonte = new ValorPositivo(this, "Imposto Retido na Fonte");
        @CampoInformacao
        protected ValorPositivo decimoTerceiro = new ValorPositivo(this, "13\u00ba Sal\u00e1rio");
        @CampoInformacao
        protected Data dataComunicacaoSaida = new Data((ObjetoNegocio)this, "Data de Comunica\u00e7\u00e3o da Condi\u00e7\u00e3o de N\u00e3o Residente \u00e0 Fonte Pagadora");
        @CampoInformacao
        protected ValorPositivo IRRFDecimoTerceiro = new ValorPositivo(this, "IRRF sobre o 13\u00ba Sal\u00e1rio");

        public Alfa getNomeFontePagadora() {
            return this.nomeFontePagadora;
        }

        public NI getNIFontePagadora() {
            return this.NIFontePagadora;
        }

        public ValorPositivo getRendRecebidoPJ() {
            return this.rendRecebidoPJ;
        }

        public ValorPositivo getContribuicaoPrevOficial() {
            return this.contribuicaoPrevOficial;
        }

        public ValorPositivo getImpostoRetidoFonte() {
            return this.impostoRetidoFonte;
        }

        public ValorPositivo getDecimoTerceiro() {
            return this.decimoTerceiro;
        }

        public Data getDataComunicacaoSaida() {
            return this.dataComunicacaoSaida;
        }

        public ValorPositivo getIRRFDecimoTerceiro() {
            return this.IRRFDecimoTerceiro;
        }
    }

    public class ColecaoRendPJDependente
    extends ColecaoRendPJ {
    }

    public class ColecaoRendPJTitular
    extends ColecaoRendPJ {
    }

    @FichaInformacao
    @ListaFichaInformacao(classeFicha=DetalheRendPJ.class, lista="itens")
    public class ColecaoRendPJ
    extends Colecao<DetalheRendPJ> {
        @CampoInformacao
        protected NI niMaiorFontePagadora = new NI((ObjetoNegocio)this, "NI da maior Fonte Pagadora");
        @CampoInformacao(dependencias={"._itens[].rendRecebidoPJ", "._quantidadeItensLista"}, classeAtualizacao=DeclaracaoMultiExercicio.class, metodoAtualizacao="calcularTotalRendRecebidoPJParcial")
        protected Valor totaisRendRecebidoPJ = new Valor((ObjetoNegocio)this, "Total Rend. Recebid");
        @CampoInformacao
        protected Valor totaisContribuicaoPrevOficial = new Valor((ObjetoNegocio)this, "Total Contr. Prev. Oficial");
        @CampoInformacao
        protected Valor totaisImpostoRetidoFonte = new Valor((ObjetoNegocio)this, "Total IR Retido na Fonte");
        @CampoInformacao
        protected Valor totaisDecimoTerceiro = new Valor((ObjetoNegocio)this, "Total 13\u00ba Sal\u00e1rio");
        @CampoInformacao
        protected Valor totaisIRRFDecimoTerceiro = new Valor((ObjetoNegocio)this, "Total IRRF sobre o 13\u00ba Sal\u00e1rio");

        public NI getNiMaiorFontePagadora() {
            return this.niMaiorFontePagadora;
        }

        public Valor getTotaisRendRecebidoPJ() {
            return this.totaisRendRecebidoPJ;
        }

        public Valor getTotaisContribuicaoPrevOficial() {
            return this.totaisContribuicaoPrevOficial;
        }

        public Valor getTotaisImpostoRetidoFonte() {
            return this.totaisImpostoRetidoFonte;
        }

        public Valor getTotaisDecimoTerceiro() {
            return this.totaisDecimoTerceiro;
        }

        public Valor getTotaisIRRFDecimoTerceiro() {
            return this.totaisIRRFDecimoTerceiro;
        }
    }

    @FichaInformacao
    public class RendPJ
    extends ObjetoNegocio {
        protected ColecaoRendPJTitular colecaoRendPJTitular;
        protected ColecaoRendPJDependente colecaoRendPJDependente;
        @CampoInformacao(dependencias={".colecaoRendPJTitular.totaisRendRecebidoPJ", ".colecaoRendPJDependente.totaisRendRecebidoPJ"}, classeAtualizacao=DeclaracaoMultiExercicio.class, metodoAtualizacao="calcularTotalRendRecebidoPJ")
        protected Valor totalRendRecebPessoaJuridica;

        public RendPJ() {
            this.colecaoRendPJTitular = new ColecaoRendPJTitular();
            this.colecaoRendPJDependente = new ColecaoRendPJDependente();
            this.totalRendRecebPessoaJuridica = new Valor((ObjetoNegocio)this, "Total Rend. Receb. PJ Tit + Dep");
        }

        public ColecaoRendPJTitular getColecaoRendPJTitular() {
            return this.colecaoRendPJTitular;
        }

        public ColecaoRendPJDependente getColecaoRendPJDependente() {
            return this.colecaoRendPJDependente;
        }

        public Valor getTotalRendRecebPessoaJuridica() {
            return this.totalRendRecebPessoaJuridica;
        }
    }
}

