/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.calculos;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import serpro.ppgd.irpf.util.calculos.CampoInformacao;
import serpro.ppgd.irpf.util.calculos.DeclaracaoMultiExercicio;
import serpro.ppgd.irpf.util.calculos.FichaInformacao;
import serpro.ppgd.irpf.util.calculos.ListaFichaInformacao;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class MapeamentoReferenciaDependencias {
    final Map<String, ArrayList<String>> dependenciasMap = new HashMap<String, ArrayList<String>>();
    final Map<String, ArrayList<String>> dependentesMap = new HashMap<String, ArrayList<String>>();
    final Map<Object, FichaInfo> fichas = new WeakHashMap<Object, FichaInfo>();
    protected ArrayList<IdentificadorInformacao> dependenciasAlteradas = new ArrayList();

    public List<?> obterFichaPorReferencia(Object ficha, String referencia) throws MapeamentoDependenciasException {
        int i;
        ArrayList<Object> fichas = new ArrayList<Object>();
        Object fichaAtual = ficha;
        for (i = 0; fichaAtual != null && i < referencia.length() && referencia.startsWith("..", i); ++i) {
            FichaInfo fichaInfo = this.fichas.get(fichaAtual);
            if (fichaInfo == null) {
                throw new MapeamentoDependenciasException("Ficha n\u00e3o mapeada: " + fichaAtual.getClass().getName());
            }
            fichaAtual = fichaInfo.getPai();
        }
        fichas.add(fichaAtual);
        for (String nomeFicha : referencia.substring(i).split("\\.")) {
            if (nomeFicha.isEmpty()) continue;
            ArrayList lista = new ArrayList();
            for (Object e : fichas) {
                FichaInfo fichaInfo = this.fichas.get(e);
                if (fichaInfo == null) {
                    throw new MapeamentoDependenciasException("Ficha n\u00e3o mapeada: " + e.getClass().getName());
                }
                List<?> filha = fichaInfo.getFilha(nomeFicha);
                if (filha == null) {
                    throw new MapeamentoDependenciasException("Propriedade \"" + nomeFicha + "\" n\u00e3o mapeada para a Ficha " + fichaInfo.getIdFicha());
                }
                lista.addAll(filha);
            }
            fichas = lista;
        }
        return fichas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> obterInformacaoPorReferencia(Object fichaInicial, String referencia) throws MapeamentoDependenciasException {
        int lastIndex = referencia.lastIndexOf(".") + 1;
        String refFicha = referencia.substring(0, lastIndex);
        ArrayList<Object> listaInfo = new ArrayList<Object>();
        List<?> listaInstanciasFicha = this.obterFichaPorReferencia(fichaInicial, refFicha);
        String campo = referencia.substring(lastIndex);
        for (Object ficha : listaInstanciasFicha) {
            Field field = this.getField(ficha.getClass(), campo);
            if (field == null) continue;
            try {
                boolean access = field.isAccessible();
                field.setAccessible(true);
                try {
                    listaInfo.add(field.get(ficha));
                }
                finally {
                    field.setAccessible(access);
                }
            }
            catch (Exception e) {
                throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Informacao", e);
            }
        }
        return listaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mapearInstanciasFichas(Object ficha, Object fichaPai, String prefixo) throws MapeamentoDependenciasException {
        Class<?> classFicha = ficha.getClass();
        boolean ehFicha = classFicha.isAnnotationPresent(FichaInformacao.class);
        if (ehFicha) {
            Field[] fields;
            HashMap filhas = new HashMap();
            String idFicha = prefixo.replaceAll("\\[N?\\]", "");
            for (Field field : fields = this.getFields(classFicha)) {
                if (field.getName().startsWith("this$")) continue;
                String nomeCampo = prefixo + "." + field.getName();
                if (field.isAnnotationPresent(CampoInformacao.class)) {
                    String idInformacao = idFicha + "." + field.getName();
                    if (!this.dependenciasMap.containsKey(idInformacao) || this.dependentesMap.containsKey(idInformacao)) continue;
                    ObservadorDependenciaInformacao obs = new ObservadorDependenciaInformacao(ficha, field.getName());
                    try {
                        boolean accessible = field.isAccessible();
                        field.setAccessible(true);
                        try {
                            Object info = field.get(ficha);
                            ((Informacao)info).addObservador((Observador)obs);
                            continue;
                        }
                        finally {
                            field.setAccessible(accessible);
                        }
                    }
                    catch (Exception e) {
                        throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Informacao (" + nomeCampo + ")", e);
                    }
                }
                if (!field.getType().isAnnotationPresent(FichaInformacao.class)) continue;
                try {
                    Object filha;
                    boolean accessible = field.isAccessible();
                    field.setAccessible(true);
                    try {
                        filha = field.get(ficha);
                    }
                    finally {
                        field.setAccessible(accessible);
                    }
                    if (!this.mapearInstanciasFichas(filha, ficha, nomeCampo)) continue;
                    ArrayList<Object> listInstanciasFilha = new ArrayList<Object>();
                    listInstanciasFilha.add(filha);
                    filhas.put(field.getName(), listInstanciasFilha);
                }
                catch (Exception e) {
                    throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Ficha (" + nomeCampo + ")", e);
                }
            }
            ListaFichaInformacao listaFichaInfo = classFicha.getAnnotation(ListaFichaInformacao.class);
            if (listaFichaInfo != null && listaFichaInfo.classeFicha().isAnnotationPresent(FichaInformacao.class)) {
                String nomeCampo = prefixo + "._itens";
                ObservadorLista obs = new ObservadorLista(ficha, nomeCampo);
                ((Colecao)ficha).addObservador((Observador)obs);
                String nomeLista = listaFichaInfo.lista();
                List<?> listInstanciasFilha = this.obterListaFichas(ficha, nomeLista);
                for (Object filha : listInstanciasFilha) {
                    this.mapearInstanciasFichas(filha, ficha, nomeCampo);
                }
                filhas.put("_itens", listInstanciasFilha);
            }
            FichaInfo fichaInfo = new FichaInfo(idFicha, ficha, fichaPai, filhas);
            this.fichas.put(ficha, fichaInfo);
            if (idFicha.endsWith("_itens") && (fichaInfo = this.fichas.get(fichaPai)) != null) {
                fichaInfo.adicionarFilha("_itens", ficha);
            }
        }
        return ehFicha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> obterListaFichas(Object ficha, String nomeLista) throws MapeamentoDependenciasException {
        List listaItens;
        block7: {
            Class<?> classFicha = ficha.getClass();
            try {
                if (!nomeLista.isEmpty()) {
                    Field field = this.getField(classFicha, nomeLista);
                    if (field != null) {
                        boolean accessible = field.isAccessible();
                        field.setAccessible(true);
                        try {
                            listaItens = (List)field.get(ficha);
                            break block7;
                        }
                        finally {
                            field.setAccessible(accessible);
                        }
                    }
                    Method m = classFicha.getMethod(nomeLista, new Class[0]);
                    listaItens = (List)m.invoke(ficha, new Object[0]);
                    break block7;
                }
                listaItens = (List)ficha;
            }
            catch (Exception e) {
                throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar lista de Fichas (" + classFicha.getName() + "." + nomeLista + ")", e);
            }
        }
        return listaItens;
    }

    public Field[] getFields(Class<?> c) {
        Field[] thisFields = c.getDeclaredFields();
        if (c.getSuperclass() != null) {
            Field[] superClassFields = this.getFields(c.getSuperclass());
            Field[] allFields = new Field[superClassFields.length + thisFields.length];
            System.arraycopy(superClassFields, 0, allFields, 0, superClassFields.length);
            System.arraycopy(thisFields, 0, allFields, superClassFields.length, thisFields.length);
            return allFields;
        }
        return thisFields;
    }

    public Field getField(Class<?> c, String name) {
        try {
            return c.getDeclaredField(name);
        }
        catch (Exception e) {
            if (c.getSuperclass() != null) {
                return this.getField(c.getSuperclass(), name);
            }
            return null;
        }
    }

    public String nomeInfoPelaReferencia(String nomeCampo, String referencia) throws MapeamentoDependenciasException {
        Object nomeInfo = "";
        int lastIndex = nomeCampo.length();
        for (int i = 0; i < referencia.length() && referencia.startsWith(".", i); ++i) {
            if ((lastIndex = nomeCampo.lastIndexOf(".", lastIndex)) >= 0) {
                nomeInfo = nomeCampo.substring(0, lastIndex) + referencia.substring(i);
                --lastIndex;
                continue;
            }
            throw new MapeamentoDependenciasException("Identificacao de campo Informacao inconsistente: \"" + referencia + "\"");
        }
        return nomeInfo;
    }

    public String referenciaPeloNomeInfo(String nomeCampo, String nomeInfo) throws MapeamentoDependenciasException {
        String prefix;
        StringBuilder sbDependente = new StringBuilder();
        int lastIndex = nomeInfo.length();
        while ((lastIndex = nomeInfo.lastIndexOf(".", lastIndex)) >= 0 && !nomeCampo.startsWith(prefix = nomeInfo.substring(0, lastIndex))) {
            sbDependente.append(".");
            --lastIndex;
        }
        sbDependente.append(nomeCampo.substring(lastIndex));
        return sbDependente.toString();
    }

    public void mapearInformacoes(Class<?> classFicha, String prefixo) throws MapeamentoDependenciasException {
        String nomeCampo = null;
        FichaInformacao fichaInfo = classFicha.getAnnotation(FichaInformacao.class);
        if (fichaInfo != null) {
            Field[] fields;
            for (Field field : fields = this.getFields(classFicha)) {
                if (field.getName().startsWith("this$")) continue;
                nomeCampo = prefixo + "." + field.getName();
                CampoInformacao campoInfo = field.getAnnotation(CampoInformacao.class);
                if (campoInfo != null) {
                    String[] dependencias = campoInfo.dependencias();
                    if (dependencias.length <= 0) continue;
                    System.out.println("\nCampo Dependente: " + (String)nomeCampo);
                    for (String dependencia : dependencias) {
                        String nomeDependencia = this.nomeInfoPelaReferencia(nomeCampo, dependencia);
                        System.out.println("\t" + nomeDependencia);
                        String idDependente = nomeCampo.replaceAll("\\[N?\\]", "");
                        ArrayList<String> listDependencias = this.dependentesMap.get(idDependente);
                        if (listDependencias == null) {
                            listDependencias = new ArrayList();
                            this.dependentesMap.put(idDependente, listDependencias);
                        }
                        listDependencias.add(dependencia.replaceAll("\\[N?\\]", ""));
                        String idDependencia = nomeDependencia.replaceAll("\\[N?\\]", "");
                        ArrayList<String> listDependentes = this.dependenciasMap.get(idDependencia);
                        if (listDependentes == null) {
                            listDependentes = new ArrayList();
                            this.dependenciasMap.put(idDependencia, listDependentes);
                        }
                        String dependente = this.referenciaPeloNomeInfo(nomeCampo, nomeDependencia);
                        dependente = dependente.replaceAll("\\[N?\\]", "");
                        listDependentes.add(dependente);
                    }
                    continue;
                }
                this.mapearInformacoes(field.getType(), nomeCampo);
            }
            ListaFichaInformacao listaFicha = classFicha.getAnnotation(ListaFichaInformacao.class);
            if (listaFicha != null) {
                nomeCampo = prefixo + "._itens[N]";
                this.mapearInformacoes(listaFicha.classeFicha(), nomeCampo);
            }
        }
    }

    public List<IdentificadorInformacao> obterDependentes(List<IdentificadorInformacao> dependencias) throws MapeamentoDependenciasException {
        ArrayList<IdentificadorInformacao> listaDependentes = new ArrayList<IdentificadorInformacao>();
        LinkedHashMap<String, IdentificadorInformacao> mapaDependentes = new LinkedHashMap<String, IdentificadorInformacao>();
        ArrayList<IdentificadorInformacao> listaDependencias = new ArrayList<IdentificadorInformacao>();
        listaDependencias.addAll(dependencias);
        for (int i = 0; !listaDependencias.isEmpty() && i < 20; ++i) {
            for (IdentificadorInformacao dependencia : listaDependencias) {
                String idDependencia = dependencia.getIdInformacao();
                ArrayList<String> refDependentes = this.dependenciasMap.get(idDependencia);
                if (refDependentes == null) continue;
                for (String refDependente : refDependentes) {
                    String refFichaDependente = refDependente.replaceAll("(.*)(\\.)([^\\.]+$)", "$1$2");
                    List<?> fichasDependente = this.obterFichaPorReferencia(dependencia.getFicha(), refFichaDependente);
                    for (Object ficha : fichasDependente) {
                        String nomeCampoDependente = refDependente.replaceAll("(.*)(\\.)([^\\.]+$)", "$3");
                        IdentificadorInformacao idInfo = new IdentificadorInformacao(nomeCampoDependente, ficha);
                        mapaDependentes.remove(idInfo.getHashCodeInformacao());
                        mapaDependentes.put(idInfo.getHashCodeInformacao(), idInfo);
                        listaDependentes.add(idInfo);
                    }
                }
            }
            listaDependencias.clear();
            listaDependencias.addAll(listaDependentes);
            listaDependentes.clear();
        }
        if (!listaDependencias.isEmpty()) {
            throw new MapeamentoDependenciasException("Foi detectado uma referencia circular.");
        }
        listaDependentes.addAll(mapaDependentes.values());
        return listaDependentes;
    }

    public void atualizarDependente(IdentificadorInformacao dependente) throws MapeamentoDependenciasException {
        ArrayList<List<Object>> listaParametros = new ArrayList<List<Object>>();
        String[] refDependencias = dependente.getReferenciasDependencias();
        if (refDependencias != null) {
            for (String refDependencia : refDependencias) {
                ArrayList<Object> dependencias = new ArrayList<Object>();
                String refFichaDependencia = refDependencia.replaceAll("(.*)(\\.)([^\\.]+$)", "$1$2");
                List<?> fichasDependencia = this.obterFichaPorReferencia(dependente.getFicha(), refFichaDependencia);
                for (Object ficha : fichasDependencia) {
                    String nomeCampoDependencia = refDependencia.replaceAll("(.*)(\\.)([^\\.]+$)", "$3");
                    if ("_quantidadeItensLista".equals(nomeCampoDependencia)) {
                        ListaFichaInformacao listaFichaInfo = ficha.getClass().getAnnotation(ListaFichaInformacao.class);
                        if (listaFichaInfo == null) continue;
                        List<?> lista = this.obterListaFichas(ficha, listaFichaInfo.lista());
                        dependencias.add(new Integer(lista.size()));
                        continue;
                    }
                    dependencias.add(new IdentificadorInformacao(nomeCampoDependencia, ficha).getInformacao());
                }
                listaParametros.add(dependencias);
            }
            dependente.executarMetodoAtualizacao(listaParametros);
        }
    }

    protected void executarAtualizacoes(List<IdentificadorInformacao> dependencias) throws MapeamentoDependenciasException {
        List<IdentificadorInformacao> dependentes = this.obterDependentes(dependencias);
        for (IdentificadorInformacao dependente : dependentes) {
            this.atualizarDependente(dependente);
        }
    }

    public void informarAlteracao(Object ficha, String nomeCampoInformacao) {
        this.dependenciasAlteradas.add(new IdentificadorInformacao(nomeCampoInformacao, ficha));
    }

    public void executarAtualizacoes() throws MapeamentoDependenciasException {
        if (this.dependenciasAlteradas.isEmpty()) {
            // empty if block
        }
        this.executarAtualizacoes(this.dependenciasAlteradas);
        this.dependenciasAlteradas.clear();
    }

    public void executarAtualizacoes(Object ficha, String nomeCampoInformacao) throws MapeamentoDependenciasException {
        ArrayList<IdentificadorInformacao> dependencias = new ArrayList<IdentificadorInformacao>();
        dependencias.add(new IdentificadorInformacao(nomeCampoInformacao, ficha));
        this.executarAtualizacoes(dependencias);
    }

    public <T> List<T> teste(T[] a) {
        ArrayList<T> lista = new ArrayList<T>();
        for (T t : a) {
            lista.add(t);
        }
        return lista;
    }

    public static void calculaCampoA(ListaRendPJ ficha, String nomeCampo, String[] campoC) {
        System.out.println("\n--- calculaCampoA() --------------------------------------------------");
        System.out.println("Calculando campo \"" + nomeCampo + "\"");
        for (String conteudo : campoC) {
            System.out.println("\t" + conteudo);
        }
    }

    public static void main_teste_1(String[] args) {
        MapeamentoReferenciaDependencias mapeamento = new MapeamentoReferenciaDependencias();
        try {
            mapeamento.mapearInformacoes(FichaDeclaracao.class, "dec");
            System.out.println("\n////////////////////////////////////////////////////");
            System.out.println("dependenciasMap: " + mapeamento.dependenciasMap);
            System.out.println("dependentesMap: " + mapeamento.dependentesMap);
            System.out.println("////////////////////////////////////////////////////\n");
            FichaDeclaracao fichaDec = mapeamento.new FichaDeclaracao();
            mapeamento.mapearInstanciasFichas(fichaDec, null, "dec");
            for (FichaInfo f : mapeamento.fichas.values()) {
                System.out.println("Ficha: " + f.idFicha);
            }
            System.out.println("\n\n--- Teste - obterInformacaoPorReferencia() ----------------------------------------");
            Object ficha = fichaDec.listaRendPJ.get(0);
            List<?> listInfo = mapeamento.obterInformacaoPorReferencia(ficha, ".campoC");
            for (Object info : listInfo) {
                System.out.println("Informacao: " + info);
            }
            System.out.println("\n\n--- Teste - obterDependentes()  -----------------------------------------");
            ficha = fichaDec.listaRendPJ.get(0);
            MapeamentoReferenciaDependencias mapeamentoReferenciaDependencias = mapeamento;
            Objects.requireNonNull(mapeamentoReferenciaDependencias);
            IdentificadorInformacao dependencia = mapeamentoReferenciaDependencias.new IdentificadorInformacao("campoA", ficha);
            ArrayList<IdentificadorInformacao> dependencias = new ArrayList<IdentificadorInformacao>();
            dependencias.add(dependencia);
            List<IdentificadorInformacao> dependentes = mapeamento.obterDependentes(dependencias);
            System.out.println("Dependencia => " + dependencia.getIdInformacao());
            for (IdentificadorInformacao identificadorInformacao : dependentes) {
                System.out.println("\t" + identificadorInformacao.getIdInformacao());
            }
            System.out.println("\n\n--- Teste - atualizarDependente() ------------------------------------------");
            ListaRendPJ listaRendPJ = fichaDec.listaRendPJ;
            MapeamentoReferenciaDependencias mapeamentoReferenciaDependencias2 = mapeamento;
            Objects.requireNonNull(mapeamentoReferenciaDependencias2);
            IdentificadorInformacao dependente = mapeamentoReferenciaDependencias2.new IdentificadorInformacao("campoA", listaRendPJ);
            System.out.println("Atualizar dependente: " + dependente.getIdInformacao());
            mapeamento.atualizarDependente(dependente);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main_teste_2(String[] args) {
        MapeamentoReferenciaDependencias mapeamento = new MapeamentoReferenciaDependencias();
        try {
            void var5_23;
            System.out.println("\n--- Teste - mapearInformacoes() -----------------------------------------------");
            mapeamento.mapearInformacoes(DeclaracaoMultiExercicio.class, "dec");
            System.out.println("\ndependentesMap:");
            for (String string : mapeamento.dependentesMap.keySet()) {
                System.out.println("\tdependente : " + string);
                for (String string2 : mapeamento.dependentesMap.get(string)) {
                    System.out.println("\t\tdependencia : " + string2);
                }
            }
            System.out.println("\ndependenciasMap:");
            for (String string : mapeamento.dependenciasMap.keySet()) {
                System.out.println("\tdependencia : " + string);
                for (String string3 : mapeamento.dependenciasMap.get(string)) {
                    System.out.println("\t\tdependente : " + string3);
                }
            }
            DeclaracaoMultiExercicio dec = new DeclaracaoMultiExercicio();
            System.out.println("\n--- Teste - mapearInstanciasFichas() -----------------------------------------------");
            dec.getRendPJ().getColecaoRendPJTitular().itens().add(dec.new DeclaracaoMultiExercicio.DetalheRendPJ());
            mapeamento.mapearInstanciasFichas((Object)dec, null, "dec");
            System.out.println("Fichas mapeadas:");
            for (FichaInfo ficha : mapeamento.fichas.values()) {
                System.out.println("\t" + ficha.idFicha);
            }
            System.out.println("\n--- Teste - mapearInstanciasFichas() -----------------------------------------------");
            DeclaracaoMultiExercicio.DetalheRendPJ detalheRendPJ = dec.new DeclaracaoMultiExercicio.DetalheRendPJ();
            dec.getRendPJ().getColecaoRendPJTitular().itens().add(detalheRendPJ);
            Object var3_9 = null;
            DeclaracaoMultiExercicio.DetalheRendPJ rendPJDependente = dec.new DeclaracaoMultiExercicio.DetalheRendPJ();
            dec.getRendPJ().getColecaoRendPJDependente().itens().add(rendPJDependente);
            rendPJDependente = null;
            System.out.println("Fichas mapeadas:");
            for (FichaInfo ficha : mapeamento.fichas.values()) {
                System.out.println("\t" + ficha.idFicha);
            }
            System.out.println("\n\n--- Teste - obterDependentes()  -----------------------------------------");
            ArrayList<IdentificadorInformacao> arrayList = new ArrayList<IdentificadorInformacao>();
            MapeamentoReferenciaDependencias mapeamentoReferenciaDependencias = mapeamento;
            Objects.requireNonNull(mapeamentoReferenciaDependencias);
            arrayList.add(mapeamentoReferenciaDependencias.new IdentificadorInformacao("rendRecebidoPJ", dec.getRendPJ().getColecaoRendPJTitular().itens().get(0)));
            MapeamentoReferenciaDependencias mapeamentoReferenciaDependencias2 = mapeamento;
            Objects.requireNonNull(mapeamentoReferenciaDependencias2);
            arrayList.add(mapeamentoReferenciaDependencias2.new IdentificadorInformacao("rendRecebidoPJ", dec.getRendPJ().getColecaoRendPJDependente().itens().get(0)));
            System.out.println("Dependencias => ");
            for (int i = 0; i < arrayList.size(); ++i) {
                System.out.println("\t" + arrayList.get(i).getIdInformacao());
            }
            List<IdentificadorInformacao> dependentes = mapeamento.obterDependentes(arrayList);
            Object var3_11 = null;
            System.out.println("Dependentes => ");
            boolean bl = false;
            while (var5_23 < dependentes.size()) {
                System.out.println("\t" + dependentes.get((int)var5_23).getIdInformacao());
                ++var5_23;
            }
            dependentes = null;
            System.out.println("\n\n--- Teste - executarAtualizacoes()  -----------------------------------------");
            ((DeclaracaoMultiExercicio.DetalheRendPJ)((Object)dec.getRendPJ().getColecaoRendPJTitular().itens().get(0))).getRendRecebidoPJ().setConteudo("120000,00");
            ((DeclaracaoMultiExercicio.DetalheRendPJ)((Object)dec.getRendPJ().getColecaoRendPJDependente().itens().get(0))).getRendRecebidoPJ().setConteudo("70000,00");
            System.out.println("\n\n--- Teste - excluir item de lista  -----------------------------------------");
            System.out.println("Fichas mapeadas:");
            for (FichaInfo ficha : mapeamento.fichas.values()) {
                System.out.println("\t" + ficha.idFicha);
            }
            System.out.println("Numero de fichas mapeadas: " + mapeamento.fichas.values().size());
            System.out.println("Apagando um item em ColecaoRendPJDependente...");
            WeakReference weakReference = new WeakReference(dec.getRendPJ().getColecaoRendPJDependente().itens().get(0));
            dec.getRendPJ().getColecaoRendPJDependente().itens().remove(0);
            while (weakReference.get() != null) {
                System.gc();
                System.out.println("Esperando GC..");
            }
            System.out.println("Fichas mapeadas:");
            for (FichaInfo fichaInfo : mapeamento.fichas.values()) {
                System.out.println("\t" + fichaInfo.idFicha);
            }
            System.out.println("Numero de fichas mapeadas: " + mapeamento.fichas.values().size());
            System.out.println("Excluindo Declaracao...");
            WeakReference<DeclaracaoMultiExercicio> weakReference2 = new WeakReference<DeclaracaoMultiExercicio>(dec);
            dec = null;
            while (weakReference2.get() != null) {
                System.gc();
                System.out.println("Esperando GC...");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MapeamentoReferenciaDependencias mapeamento = new MapeamentoReferenciaDependencias();
        try {
            System.out.println("\n--- Teste - mapearInformacoes() -----------------------------------------------");
            mapeamento.mapearInformacoes(DeclaracaoMultiExercicio.class, "dec");
            System.out.println("\ndependentesMap:");
            for (String dependente : mapeamento.dependentesMap.keySet()) {
                System.out.println("\tdependente : " + dependente);
                for (String dependencia : mapeamento.dependentesMap.get(dependente)) {
                    System.out.println("\t\tdependencia : " + dependencia);
                }
            }
            System.out.println("\ndependenciasMap:");
            for (String dependencia : mapeamento.dependenciasMap.keySet()) {
                System.out.println("\tdependencia : " + dependencia);
                for (String dependente : mapeamento.dependenciasMap.get(dependencia)) {
                    System.out.println("\t\tdependente : " + dependente);
                }
            }
            DeclaracaoMultiExercicio dec = new DeclaracaoMultiExercicio();
            System.out.println("\n--- Teste - mapearInstanciasFichas() -----------------------------------------------");
            mapeamento.mapearInstanciasFichas((Object)dec, null, "dec");
            System.out.println("Fichas mapeadas:");
            for (FichaInfo ficha : mapeamento.fichas.values()) {
                System.out.println("\t" + ficha.idFicha);
            }
            System.out.println("\n--- Teste - Inserir Dados -----------------------------------------------");
            dec.getRendPJ().getColecaoRendPJTitular().itens().add(dec.new DeclaracaoMultiExercicio.DetalheRendPJ());
            dec.getRendPJ().getColecaoRendPJDependente().itens().add(dec.new DeclaracaoMultiExercicio.DetalheRendPJ());
            System.out.println("Fichas mapeadas:");
            for (FichaInfo ficha : mapeamento.fichas.values()) {
                System.out.println("\t" + ficha.idFicha);
            }
            System.out.println("\n\n--- Teste - executarAtualizacoes()  -----------------------------------------");
            ((DeclaracaoMultiExercicio.DetalheRendPJ)((Object)dec.getRendPJ().getColecaoRendPJTitular().itens().get(0))).getRendRecebidoPJ().setConteudo("120000,00");
            ((DeclaracaoMultiExercicio.DetalheRendPJ)((Object)dec.getRendPJ().getColecaoRendPJDependente().itens().get(0))).getRendRecebidoPJ().setConteudo("70000,00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class ObservadorDependenciaInformacao
    extends Observador {
        Object ficha;
        String nomeCampoInformacao;

        public ObservadorDependenciaInformacao(Object ficha, String nomeCampoInformacao) {
            this.ficha = ficha;
            this.nomeCampoInformacao = nomeCampoInformacao;
        }

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            MapeamentoReferenciaDependencias.this.informarAlteracao(this.ficha, this.nomeCampoInformacao);
            try {
                MapeamentoReferenciaDependencias.this.executarAtualizacoes();
            }
            catch (MapeamentoDependenciasException e) {
                e.printStackTrace();
            }
        }
    }

    public class IdentificadorInformacao {
        private String hashCodeInformacao;
        private String nomeCampoInformacao;
        private Object ficha;

        public IdentificadorInformacao(String nomeCampoInformacao, Object ficha) {
            this.nomeCampoInformacao = Objects.requireNonNull(nomeCampoInformacao);
            this.ficha = Objects.requireNonNull(ficha);
            this.hashCodeInformacao = ficha.hashCode() + "." + nomeCampoInformacao;
        }

        public String getHashCodeInformacao() {
            return this.hashCodeInformacao;
        }

        public String getNomeCampoInformacao() {
            return this.nomeCampoInformacao;
        }

        public Object getFicha() {
            return this.ficha;
        }

        public String getIdInformacao() throws MapeamentoDependenciasException {
            FichaInfo fichaInfo = MapeamentoReferenciaDependencias.this.fichas.get(this.getFicha());
            if (fichaInfo == null) {
                throw new MapeamentoDependenciasException("Ficha n\u00e3o mapeada:" + this.getFicha().getClass().getName());
            }
            return fichaInfo.getIdFicha() + "." + this.getNomeCampoInformacao();
        }

        private Field getField() {
            return MapeamentoReferenciaDependencias.this.getField(this.getFicha().getClass(), this.getNomeCampoInformacao());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getInformacao() throws MapeamentoDependenciasException {
            Field field = this.getField();
            boolean acces = field.isAccessible();
            field.setAccessible(true);
            try {
                Object object = field.get(this.getFicha());
                field.setAccessible(acces);
                return object;
            }
            catch (Throwable throwable) {
                try {
                    field.setAccessible(acces);
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MapeamentoDependenciasException("Erro ao acessar Informacao: \"" + this.getIdInformacao() + "\".", e);
                }
            }
        }

        public void executarMetodoAtualizacao(List<List<Object>> listaDependencias) throws MapeamentoDependenciasException {
            Method[] methods;
            String nomeMetodo = this.getCampoInformacao().metodoAtualizacao();
            Class<?> classeAtualizacao = this.getCampoInformacao().classeAtualizacao();
            for (Method method : methods = classeAtualizacao.getMethods()) {
                if (!method.getName().equals(nomeMetodo)) continue;
                Class<?>[] tiposParametros = method.getParameterTypes();
                if (listaDependencias.size() + 2 != tiposParametros.length) {
                    throw new MapeamentoDependenciasException("Erro ao executar metodo de atualizacao \"" + method.getName() + "\": Parametros incompativeis.");
                }
                Object[] parametros = new Object[tiposParametros.length];
                parametros[0] = this.getFicha();
                parametros[1] = this.getNomeCampoInformacao();
                int i = 0;
                for (int j = 2; i < listaDependencias.size() && j < parametros.length; ++i, ++j) {
                    List<Object> lista = listaDependencias.get(i);
                    if (tiposParametros[j].isArray()) {
                        parametros[j] = lista.toArray((Object[])Array.newInstance(tiposParametros[j].getComponentType(), 0));
                        continue;
                    }
                    if (lista.isEmpty()) continue;
                    parametros[j] = lista.get(0);
                }
                try {
                    method.invoke(null, parametros);
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new MapeamentoDependenciasException("Erro ao executar metodo de atualizacao \"" + method.getName() + "\"", e);
                }
            }
        }

        private CampoInformacao getCampoInformacao() {
            return this.getField().getAnnotation(CampoInformacao.class);
        }

        public String[] getReferenciasDependencias() throws MapeamentoDependenciasException {
            return MapeamentoReferenciaDependencias.this.dependentesMap.get(this.getIdInformacao()).toArray(new String[0]);
        }
    }

    public class MapeamentoDependenciasException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MapeamentoDependenciasException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public MapeamentoDependenciasException(String arg0) {
            super(arg0);
        }
    }

    @FichaInformacao
    public class FichaClaculo {
        @CampoInformacao
        private String campoA = "FichaClaculo:campoA";
        @CampoInformacao
        private String campoB = "FichaClaculo:campoB";
        @CampoInformacao
        private String campoC = "FichaClaculo:campoC";
        @CampoInformacao(dependencias={".campoA", ".campoB"})
        private String campoD = "FichaClaculo:campoD";
        @CampoInformacao(dependencias={".campoB", ".campoC"})
        private String campoE = "FichaClaculo:campoE";
        @CampoInformacao(dependencias={".campoD", ".campoE"})
        private String campoF = "FichaClaculo:campoF";
        @CampoInformacao(dependencias={"..campoA"})
        private String campoG = "FichaClaculo:campoG";
    }

    @FichaInformacao
    @ListaFichaInformacao(classeFicha=FichaDetalheRendPJ.class)
    public class ListaRendPJ
    extends ArrayList<FichaDetalheRendPJ> {
        private static final long serialVersionUID = 1L;
        @CampoInformacao(dependencias={"._itens[].campoC"}, classeAtualizacao=MapeamentoReferenciaDependencias.class, metodoAtualizacao="calculaCampoA")
        private String campoA = "ListaRendPJ:campoA";
    }

    @FichaInformacao
    public class FichaDetalheRendPJ {
        @CampoInformacao
        private String campoA = "FichaDetalheRendPJ:campoA";
        @CampoInformacao
        private String campoB = "FichaDetalheRendPJ:campoB";
        @CampoInformacao(dependencias={".campoA", ".campoB"})
        private String campoC = "FichaDetalheRendPJ:campoC";
        private String campoD = "FichaDetalheRendPJ:campoD";
        @CampoInformacao(dependencias={"..campoA"})
        private String campoE = "FichaDetalheRendPJ:campoE";
        private ListaRend listaRend = new ListaRend();

        public FichaDetalheRendPJ() {
            this.listaRend.add(new FichaDetalheRend());
            this.listaRend.add(new FichaDetalheRend());
            this.listaRend.add(new FichaDetalheRend());
            this.listaRend.add(new FichaDetalheRend());
        }
    }

    @FichaInformacao
    @ListaFichaInformacao(classeFicha=FichaDetalheRend.class)
    public class ListaRend
    extends ArrayList<FichaDetalheRend> {
        private static final long serialVersionUID = 1L;
        @CampoInformacao(dependencias={"._itens[].campoC"})
        private String campoA = "ListaRend:campoA";
    }

    @FichaInformacao
    public class FichaDetalheRend {
        @CampoInformacao
        private String campoA = "FichaDetalheRend:campoA";
        @CampoInformacao
        private String campoB = "FichaDetalheRend:campoB";
        @CampoInformacao(dependencias={".campoA", ".campoB"})
        private String campoC = "FichaDetalheRend:campoC";
        @CampoInformacao(dependencias={".....fichaCalculo.campoA"})
        private String campoD = "FichaDetalheRend:campoD";
        @CampoInformacao(dependencias={".._itens[].campoA"})
        private String campoE = "FichaDetalheRend:campoE";
    }

    @FichaInformacao
    public class FichaDeclaracao {
        ListaRendPJ listaRendPJ;
        FichaClaculo fichaCalculo;
        @CampoInformacao
        private String campoA;

        public FichaDeclaracao() {
            this.listaRendPJ = new ListaRendPJ();
            this.fichaCalculo = new FichaClaculo();
            this.campoA = "FichaDeclaracao::campoA";
            this.listaRendPJ.add(new FichaDetalheRendPJ());
            this.listaRendPJ.add(new FichaDetalheRendPJ());
            this.listaRendPJ.add(new FichaDetalheRendPJ());
        }
    }

    public class ObservadorLista
    extends Observador {
        Object ficha;
        String prefixo;

        public ObservadorLista(Object ficha, String prefixo) {
            this.ficha = ficha;
            this.prefixo = prefixo;
        }

        public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
            try {
                if ("ObjetoInserido".equals(nomePropriedade)) {
                    MapeamentoReferenciaDependencias.this.mapearInstanciasFichas(valorNovo, this.ficha, this.prefixo);
                    MapeamentoReferenciaDependencias.this.informarAlteracao(this.ficha, "_quantidadeItensLista");
                    MapeamentoReferenciaDependencias.this.executarAtualizacoes();
                } else if ("ObjetoRemovido".equals(nomePropriedade)) {
                    MapeamentoReferenciaDependencias.this.fichas.get(observado).removerFilha("_itens", valorNovo);
                    MapeamentoReferenciaDependencias.this.informarAlteracao(this.ficha, "_quantidadeItensLista");
                    MapeamentoReferenciaDependencias.this.executarAtualizacoes();
                }
            }
            catch (MapeamentoDependenciasException e) {
                e.printStackTrace();
            }
        }
    }

    public class FichaInfo {
        private final String idFicha;
        private final WeakReference<Object> ficha;
        private final WeakReference<Object> pai;
        private final Map<String, List<WeakReference<?>>> filhas;

        public FichaInfo(String idFicha, Object ficha, Object pai, Map<String, List<?>> filhas) {
            Objects.requireNonNull(filhas);
            HashMap mapFilhas = new HashMap(filhas.size());
            for (String filha : filhas.keySet()) {
                ArrayList novaLista = new ArrayList();
                for (Object objFilha : filhas.get(filha)) {
                    WeakReference w = new WeakReference(objFilha);
                    novaLista.add(w);
                }
                mapFilhas.put(filha, novaLista);
            }
            this.idFicha = Objects.requireNonNull(idFicha);
            this.ficha = new WeakReference<Object>(Objects.requireNonNull(ficha));
            this.pai = new WeakReference<Object>(pai);
            this.filhas = mapFilhas;
        }

        public String getIdFicha() {
            return this.idFicha;
        }

        public Object getFicha() {
            return this.ficha.get();
        }

        public Object getPai() {
            return this.pai.get();
        }

        public void adicionarFilha(String nomeFilha, Object filha) {
            List<WeakReference<?>> l = this.filhas.get(nomeFilha);
            if (l == null) {
                l = new ArrayList();
                this.filhas.put(nomeFilha, l);
            }
            l.add(new WeakReference<Object>(filha));
        }

        public void removerFilha(String nomeFicha, Object item) {
            List<WeakReference<?>> lista = this.filhas.get(nomeFicha);
            for (int i = 0; i < lista.size(); ++i) {
                Object obj = lista.get(i).get();
                if (obj == null || obj != item) continue;
                lista.remove(i);
                break;
            }
        }

        public List<?> getFilha(String nomeFicha) {
            ArrayList list = new ArrayList();
            ArrayList listRemove = new ArrayList();
            for (WeakReference<?> wFilha : this.filhas.get(nomeFicha)) {
                if (wFilha.get() != null) {
                    list.add(wFilha.get());
                    continue;
                }
                listRemove.add(wFilha);
            }
            this.filhas.get(nomeFicha).removeAll(listRemove);
            return list;
        }

        public Map<String, List<?>> getFilhas() {
            HashMap map = new HashMap();
            for (String filha : this.filhas.keySet()) {
                ArrayList list = new ArrayList();
                ArrayList listRemove = new ArrayList();
                for (WeakReference<?> wFilha : this.filhas.get(filha)) {
                    if (wFilha.get() != null) {
                        list.add(wFilha.get());
                        continue;
                    }
                    listRemove.add(wFilha);
                }
                this.filhas.get(filha).removeAll(listRemove);
                map.put(filha, list);
            }
            return map;
        }
    }
}

