/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;

public class EventListenerProxy
implements InvocationHandler {
    private static boolean working;
    private EventListener listener;

    protected EventListenerProxy(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException("EventListener cannot be null");
        }
        this.listener = listener;
    }

    public static EventListener create(Class listenerInterface, EventListener listener) {
        if (!listenerInterface.isInstance(listener)) {
            throw new IllegalArgumentException("EventListener " + listener + " must implement " + listenerInterface.getName());
        }
        return (EventListener)Proxy.newProxyInstance(listenerInterface.getClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)new EventListenerProxy(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (working) {
            return null;
        }
        try {
            working = true;
            Object object = method.invoke((Object)this.listener, args);
            return object;
        }
        finally {
            working = false;
        }
    }
}

