/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio.util;

import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.repositorio.CadastroId;
import serpro.ppgd.repositorio.RepositorioObjetoNegocioIf;
import serpro.ppgd.repositorio.RepositorioTabelasBasicasIf;
import serpro.ppgd.repositorio.repositorioXML.RepositorioIdDeclaracaoXML;
import serpro.ppgd.repositorio.repositorioXML.RepositorioIdXML;
import serpro.ppgd.repositorio.repositorioXML.RepositorioObjetoNegocioXML;
import serpro.ppgd.repositorio.repositorioXML.RepositorioTabelasBasicasXML;

public abstract class FabricaRepositorio {
    private static CadastroId cadastroIdXML = null;
    private static CadastroId cadastroIdDB = null;
    private static RepositorioTabelasBasicasIf repositorioTabelasBasicasXML = new RepositorioTabelasBasicasXML();

    public static String getPathArquivoXMLMapeamento() {
        String retorno = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.mapeamentoXML");
        if (retorno == null || retorno.trim().length() == 0) {
            retorno = "/mapeamentoObjetos.xml";
        }
        return retorno;
    }

    private static CadastroId getCadastroIdXML() {
        if (cadastroIdXML == null) {
            RepositorioIdXML repositorioId = new RepositorioIdXML(FabricaUtilitarios.nomeClasseId);
            RepositorioObjetoNegocioIf repObjNegocio = null;
            String classeRepObj = FabricaUtilitarios.getProperties().getProperty("repositoriodeclaracao");
            if (classeRepObj != null && !classeRepObj.trim().equals("")) {
                try {
                    repObjNegocio = (RepositorioObjetoNegocioIf)Class.forName(classeRepObj).newInstance();
                }
                catch (Exception e) {
                    LogPPGD.erro((String)("Nao foimpossivel instanciar o repositorio: " + classeRepObj));
                }
            } else {
                repObjNegocio = new RepositorioObjetoNegocioXML(FabricaUtilitarios.nomeClasseDeclaracao);
            }
            cadastroIdXML = new CadastroId(repositorioId, new RepositorioIdDeclaracaoXML(FabricaUtilitarios.nomeClasseIdDeclaracao, repositorioId), repObjNegocio);
        }
        return cadastroIdXML;
    }

    public static CadastroId getCadastroId() {
        String tipoCadastro = FabricaUtilitarios.getProperties().getProperty("aplicacao.persistencia.tipo", "");
        if (tipoCadastro.trim().length() != 0 && tipoCadastro.equalsIgnoreCase("XML")) {
            if (cadastroIdXML == null) {
                cadastroIdXML = FabricaRepositorio.getCadastroIdXML();
            }
            return cadastroIdXML;
        }
        if (cadastroIdXML == null) {
            cadastroIdXML = FabricaRepositorio.getCadastroIdXML();
        }
        return cadastroIdXML;
    }

    public static RepositorioTabelasBasicasIf getRepositorioTabelasBasicasXML() {
        return repositorioTabelasBasicasXML;
    }
}

