/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf.nuvem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.xbeans.GroupPanelEvent;
import serpro.ppgd.gui.xbeans.GroupPanelListener;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditAlfa;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.rendpf.nuvem.ImportacaoModel;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.RetornosValidacoes;

public class PainelImportacaoCarneLeao
extends JPanel {
    private ImportacaoModel importacaoModel = new ImportacaoModel();
    public static final int OPT_OK = 0;
    public static final int OPT_CANCELAR = 1;
    private int opcaoSelecionada = 1;
    private JButton btnCancelar;
    private JButton btnOK;
    private JAutoCompleteEditAlfa cmbDependente;
    private JPanel jPanelPrincipal;
    private IRPFLabelInfo lblAvisoDependenteVazio;
    private JLabel lblDependente;
    private JLabel lblOu;
    private JLabel lblPerguntaDeclaracao;
    private PPGDRadioItem rdbDependente;
    private PPGDRadioItem rdbTitular;
    private JButtonGroupPanel tipoGroup;

    public PainelImportacaoCarneLeao() {
        this.initComponents();
        this.atualizaGui();
    }

    public PainelImportacaoCarneLeao(String cpfSolicitante, String codigoAcesso, char[] senha) {
        this.importacaoModel.getCpfSolicitante().setConteudo(cpfSolicitante);
        this.importacaoModel.getCodigoAcesso().setConteudo(codigoAcesso);
        this.importacaoModel.setSenha(senha);
        this.initComponents();
        this.atualizaGui();
    }

    private void atualizaDadosComboDepentende() {
        List dependentes = CadastroTabelasIRPF.recuperarNomesDependentes();
        this.cmbDependente.setDados(dependentes);
    }

    private void atualizaGui() {
        this.atualizaDadosComboDepentende();
        this.cmbDependente.getAccessibleContext().setAccessibleName("Nome do dependente");
        this.cmbDependente.setInformacao((Informacao)this.importacaoModel.getDependente());
        this.cmbDependente.getComponenteEditor().setEnabled(false);
        this.lblAvisoDependenteVazio.setMensagem(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Dependentes"}));
        this.importacaoModel.getTipo().setConteudo("V");
        ((JComboBox)this.cmbDependente.getComponenteEditor()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String cpf = ((ElementoTabela)e.getItem()).getConteudo(2);
                    PainelImportacaoCarneLeao.this.importacaoModel.getCpfDependente().setConteudo(cpf);
                }
            }
        });
    }

    private void initComponents() {
        this.jPanelPrincipal = new JPanel();
        this.cmbDependente = new JAutoCompleteEditAlfa();
        this.lblDependente = new JLabel();
        this.lblPerguntaDeclaracao = new JLabel();
        this.btnOK = new JButton();
        this.lblAvisoDependenteVazio = new IRPFLabelInfo();
        this.tipoGroup = new JButtonGroupPanel();
        this.rdbTitular = new PPGDRadioItem();
        this.rdbDependente = new PPGDRadioItem();
        this.lblOu = new JLabel();
        this.btnCancelar = new JButton();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanelPrincipal.setBackground(new Color(255, 255, 255));
        this.jPanelPrincipal.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblDependente.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDependente.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDependente.setText("Nome do dependente");
        this.lblDependente.setVerticalAlignment(3);
        this.lblPerguntaDeclaracao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblPerguntaDeclaracao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblPerguntaDeclaracao.setText("Os dados que deseja importar pertencem ao:");
        this.btnOK.setMnemonic('O');
        this.btnOK.setText("<html><u>O</u>K</html>");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImportacaoCarneLeao.this.btnOKActionPerformed(evt);
            }
        });
        this.tipoGroup.setBorder(null);
        this.tipoGroup.addGroupPanelListener(new GroupPanelListener(){

            public void atualizaPainel(GroupPanelEvent evt) {
                PainelImportacaoCarneLeao.this.tipoGroupAtualizaPainel(evt);
            }
        });
        this.rdbTitular.setBackground(new Color(255, 255, 255));
        this.rdbTitular.setText("Titular");
        this.rdbTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbTitular.setValorSelecionadoTrue("T");
        this.rdbTitular.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PainelImportacaoCarneLeao.this.rdbTitularKeyPressed(evt);
            }
        });
        this.rdbDependente.setBackground(new Color(255, 255, 255));
        this.rdbDependente.setText("Dependente");
        this.rdbDependente.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbDependente.setValorSelecionadoTrue("D");
        this.rdbDependente.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PainelImportacaoCarneLeao.this.rdbDependenteKeyPressed(evt);
            }
        });
        this.lblOu.setFont(FontesUtil.FONTE_NORMAL);
        this.lblOu.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblOu.setText("Ou");
        GroupLayout tipoGroupLayout = new GroupLayout((Container)this.tipoGroup);
        this.tipoGroup.setLayout((LayoutManager)tipoGroupLayout);
        tipoGroupLayout.setHorizontalGroup(tipoGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tipoGroupLayout.createSequentialGroup().addComponent((Component)this.rdbTitular, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblOu).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.rdbDependente, -2, -1, -2).addContainerGap(68, Short.MAX_VALUE)));
        tipoGroupLayout.setVerticalGroup(tipoGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tipoGroupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.rdbTitular, -2, -1, -2).addComponent((Component)this.rdbDependente, -2, -1, -2).addComponent(this.lblOu)));
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("<html><u>C</u>ancelar</html>");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImportacaoCarneLeao.this.btnCancelarActionPerformed(evt);
            }
        });
        GroupLayout jPanelPrincipalLayout = new GroupLayout(this.jPanelPrincipal);
        this.jPanelPrincipal.setLayout(jPanelPrincipalLayout);
        jPanelPrincipalLayout.setHorizontalGroup(jPanelPrincipalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPrincipalLayout.createSequentialGroup().addContainerGap().addGroup(jPanelPrincipalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPerguntaDeclaracao).addGroup(jPanelPrincipalLayout.createSequentialGroup().addComponent(this.lblDependente).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.lblAvisoDependenteVazio, -2, -1, -2)).addComponent((Component)this.cmbDependente, -2, 496, -2).addComponent((Component)this.tipoGroup, -2, -1, -2).addGroup(jPanelPrincipalLayout.createSequentialGroup().addComponent(this.btnOK, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancelar, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelPrincipalLayout.setVerticalGroup(jPanelPrincipalLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelPrincipalLayout.createSequentialGroup().addContainerGap().addComponent(this.lblPerguntaDeclaracao).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.tipoGroup, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelPrincipalLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblDependente, -2, 22, -2).addComponent((Component)this.lblAvisoDependenteVazio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmbDependente, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanelPrincipalLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOK, -1, -1, -2).addComponent(this.btnCancelar, -2, -1, -2)).addContainerGap(17, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelPrincipal, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelPrincipal, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        String pendencias = this.validarCampos();
        if (this.importacaoModel.getTipo().naoFormatado().equals("T") || pendencias.length() == 0) {
            this.opcaoSelecionada = 0;
            ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        }
    }

    private void rdbTitularKeyPressed(KeyEvent evt) {
    }

    private void rdbDependenteKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 9 && this.cmbDependente.isEnabled()) {
            this.cmbDependente.requestFocusInWindow();
        }
    }

    private void tipoGroupAtualizaPainel(GroupPanelEvent evt) {
        if (this.rdbDependente.isSelected()) {
            this.importacaoModel.getTipo().setConteudo("D");
            this.atualizaDadosComboDepentende();
            this.cmbDependente.setInformacao((Informacao)this.importacaoModel.getDependente());
            this.cmbDependente.getComponenteEditor().setEnabled(true);
        } else {
            this.importacaoModel.getTipo().setConteudo("T");
            this.cmbDependente.setDados(Collections.emptyList());
            this.cmbDependente.setInformacao((Informacao)new Alfa());
            this.cmbDependente.getComponenteEditor().setEnabled(false);
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.opcaoSelecionada = 1;
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    public ImportacaoModel getImportacaoModel() {
        return this.importacaoModel;
    }

    public int getOpcaoSelecionada() {
        return this.opcaoSelecionada;
    }

    private String validarCampos() {
        RetornosValidacoes retornosValidacoesDependente = this.importacaoModel.getDependente().validar();
        RetornosValidacoes retornosValidacoesTipo = this.importacaoModel.getTipo().validar();
        ArrayList listaRetornoValidacao = new ArrayList();
        listaRetornoValidacao.addAll(retornosValidacoesDependente.getLista());
        listaRetornoValidacao.addAll(retornosValidacoesTipo.getLista());
        StringBuilder mensagens = new StringBuilder();
        for (RetornoValidacao retornoValidacao : listaRetornoValidacao) {
            if (retornoValidacao.isValido()) continue;
            mensagens.append(retornoValidacao.getMensagemValidacao());
            mensagens.append(System.getProperty("line.separator"));
        }
        return mensagens.toString();
    }
}

