/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import serpro.ppgd.infraestrutura.util.MostrarProgresso;

public class DialogoProgresso
extends JDialog
implements MostrarProgresso {
    private static final long serialVersionUID = 1L;
    private JPanel pnlBarraProgresso = null;
    private JLabel lblTituloAcao = null;
    private JButton btnCancelar = null;
    private JLabel lblImagem = null;
    private JProgressBar barraProgresso = null;
    protected boolean canceladoOuFechado = false;
    private WindowAdapter windowListenerFechar;
    public static final Color corProgresso = new Color(10, 36, 106);

    public DialogoProgresso(Dialog janelaPai, String titulo) {
        super(janelaPai, titulo);
        this.initialize();
    }

    public DialogoProgresso(JFrame janelaPai, String titulo) {
        super((Frame)janelaPai, titulo);
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(420, 196));
        this.setContentPane(this.getPnlBarraProgresso());
        this.windowListenerFechar = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogoProgresso.this.janelaFechar();
            }
        };
        this.addWindowListener(this.windowListenerFechar);
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.btnCancelar.setFocusable(false);
    }

    private JPanel getPnlBarraProgresso() {
        if (this.pnlBarraProgresso == null) {
            this.lblImagem = new JLabel();
            this.lblImagem.setBounds(new Rectangle(180, 25, 50, 62));
            this.lblImagem.setText("");
            this.lblTituloAcao = new JLabel();
            this.lblTituloAcao.setText("T\u00edtulo");
            this.lblTituloAcao.setBounds(new Rectangle(9, 7, 384, 14));
            this.pnlBarraProgresso = new JPanel();
            this.pnlBarraProgresso.setLayout(null);
            this.pnlBarraProgresso.add((Component)this.lblTituloAcao, null);
            this.pnlBarraProgresso.add((Component)this.getBtnCancelar(), null);
            this.pnlBarraProgresso.add((Component)this.lblImagem, null);
            this.pnlBarraProgresso.add((Component)this.getBarraProgresso(), null);
        }
        return this.pnlBarraProgresso;
    }

    private JButton getBtnCancelar() {
        if (this.btnCancelar == null) {
            this.btnCancelar = new JButton();
            this.btnCancelar.setText("Cancelar");
            this.btnCancelar.setBounds(new Rectangle(135, 127, 138, 23));
            this.btnCancelar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogoProgresso.this.btnCancelarClick();
                }
            });
        }
        return this.btnCancelar;
    }

    protected void btnCancelarClick() {
        this.canceladoOuFechado = true;
        this.getParent().update(this.getParent().getGraphics());
        this.setVisible(false);
    }

    public void setTituloAcao(String titulo) {
        this.lblTituloAcao.setText(titulo);
    }

    @Override
    public void setProgresso(int progresso) {
        this.barraProgresso.setValue(progresso);
        this.repaint();
    }

    public int getProgresso() {
        return this.barraProgresso.getValue();
    }

    @Override
    public boolean foiCanceladoOuFechado() {
        return this.canceladoOuFechado;
    }

    private JProgressBar getBarraProgresso() {
        if (this.barraProgresso == null) {
            this.barraProgresso = new JProgressBar();
            this.barraProgresso.setBounds(new Rectangle(51, 92, 306, 20));
            this.barraProgresso.setForeground(corProgresso);
        }
        return this.barraProgresso;
    }

    public void janelaFechar() {
        this.canceladoOuFechado = true;
        this.getParent().update(this.getParent().getGraphics());
        this.setVisible(false);
    }

    @Override
    public void fecharProgresso() {
        this.setVisible(false);
    }

    public void naoMostrarBarraProgresso() {
        this.getBarraProgresso().setVisible(false);
        this.getBtnCancelar().setVisible(false);
        this.setSize(new Dimension(420, 130));
        this.setLocationRelativeTo(this.getParent());
        this.removeWindowListener(this.windowListenerFechar);
        this.setDefaultCloseOperation(0);
    }
}

