/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import serpro.ppgd.negocio.ControladorNegocio;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.RetornosValidacoes;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;

public abstract class Informacao<T>
implements Comparable<T> {
    public static final String VALIDO_PROPERTY = "Val-Property";
    public static final String READ_ONLY_PROPERTY = "ReadOnly";
    public static final String HABILITADO_PROPERTY = "habilitado";
    public static final String ROTULO_CHANGE_PROPERTY = "Label_Modificado";
    private ObjetoNegocio owner;
    private String nomeCampo = "";
    private String nomeCampoCurto = "";
    private String conteudo = "";
    protected WeakHashMap<String, Informacao> informacaoAssociada = new WeakHashMap();
    private String ficha = "";
    private String aba = "";
    private boolean readOnly = false;
    private boolean habilitado = true;
    private boolean transportado = false;
    protected String conteudoAntigo = "";
    protected boolean inicializouUltimoConteudoValido = false;
    private String ultimoConteudoValido = "";
    private transient List<ValidadorIf> listaValidadores;
    private transient List<ValidadorIf> listaValidadoresImpeditivos;
    private RetornosValidacoes retornoTodasValidacoes = new RetornosValidacoes();
    private transient PropertyChangeSupport observadores = new PropertyChangeSupport(this);
    private boolean observadoresAtivos = true;
    private boolean validadoresAtivos = true;
    private boolean desprezarMascara = true;
    private boolean atributoPersistente = true;

    public abstract void setConteudo(T var1);

    public Informacao() {
    }

    public Informacao(ObjetoNegocio owner, String nomeCampo) {
        this();
        this.setOwner(owner);
        this.setNomeCampo(nomeCampo);
        this.setNomeCampoCurto(nomeCampo);
        LogPPGD.debug("Campo [" + nomeCampo + "] criado como objeto " + this.getClass().getName() + ".");
    }

    public Informacao(String nomeCampo) {
        this();
        this.setNomeCampo(nomeCampo);
        this.setNomeCampoCurto(nomeCampo);
        LogPPGD.debug("Campo [" + nomeCampo + "] criado como objeto " + this.getClass().getName() + ".");
    }

    public void setConteudo(String conteudo) {
        if (!this.inicializouUltimoConteudoValido) {
            this.inicializouUltimoConteudoValido = true;
            this.ultimoConteudoValido = conteudo;
        }
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + conteudo);
        String antigo = this.asString();
        this.clearRetornosValidacoes();
        this.conteudo = conteudo;
        if (this.isVazio()) {
            this.ultimoConteudoValido = "";
        }
        this.disparaObservadores(antigo);
    }

    public abstract String getConteudoFormatado();

    public abstract String formatado();

    public String toString() {
        return this.formatado();
    }

    public String asString() {
        return this.conteudo;
    }

    public String naoFormatado() {
        return this.conteudo;
    }

    public boolean isVazio() {
        return this.naoFormatado() == null || this.naoFormatado().trim().isEmpty() || this.isDesprezarMascara() && UtilitariosString.retiraMascara(this.naoFormatado().trim()).isEmpty();
    }

    @Override
    public int compareTo(T pObjeto) {
        return this.asString().compareTo(pObjeto.toString());
    }

    public void clear() {
        this.setConteudo("");
    }

    public String getNomeCampo() {
        return this.nomeCampo;
    }

    public void setNomeCampo(String nomeCampo) {
        String nomeAntigo = this.getNomeCampo();
        this.nomeCampo = nomeCampo;
        this.getObservadores().firePropertyChange(ROTULO_CHANGE_PROPERTY, nomeAntigo, this.getNomeCampo());
    }

    public void addValidador(ValidadorIf validador) {
        if (validador instanceof ValidadorImpeditivoDefault) {
            this.getListaValidadoresImpeditivos().add(validador);
        } else {
            this.getListaValidadores().add(validador);
        }
        validador.setInformacao(this);
        validador.setRetornosValidacoes(this.retornoTodasValidacoes);
    }

    public boolean isValido() {
        return this.retornoTodasValidacoes.isTodosValidos();
    }

    public RetornoValidacao getPrimeiroRetornoValidacaoMaisSevero() {
        return this.retornoTodasValidacoes.getPrimeiroRetornoValidacaoMaisSevero();
    }

    public void clearRetornosValidacoes() {
        this.retornoTodasValidacoes.clear();
    }

    public RetornosValidacoes validar() {
        LogPPGD.debug("Valida\u00e7\u00e3o de " + this.getNomeCampo() + " [=" + this.toString() + "]");
        this.retornoTodasValidacoes.clear();
        if (this.isValidadoresAtivos()) {
            Iterator<ValidadorIf> validadores = this.getListaValidadores().iterator();
            while (validadores.hasNext()) {
                validadores.next().validar();
            }
        }
        if (this.isValido() && this.getRetornoTodasValidacoes().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() != 4) {
            this.setUltimoConteudoValido(this.asString());
        }
        return this.retornoTodasValidacoes;
    }

    public ObjetoNegocio getOwner() {
        return this.owner;
    }

    public void setOwner(ObjetoNegocio owner) {
        this.owner = owner;
    }

    public PropertyChangeSupport getObservadores() {
        return this.observadores;
    }

    public void addObservador(Observador observador) {
        this.observadores.addPropertyChangeListener(observador);
    }

    public void addObservador(String nomePropriedade, Observador observador) {
        this.observadores.addPropertyChangeListener(nomePropriedade, observador);
    }

    public void removeObservador(Observador observador) {
        this.observadores.removePropertyChangeListener(observador);
    }

    public void removeObservador(String nomePropriedade, Observador observador) {
        this.observadores.removePropertyChangeListener(nomePropriedade, observador);
    }

    public void disparaObservadores() {
        if (this.isVazio()) {
            this.disparaObservadores("");
            return;
        }
        this.disparaObservadores("_");
    }

    public void forcaDisparoObservadores() {
        this.disparaObservadores(this.asString() + "_");
    }

    protected void disparaObservadores(Object aConteudoAntigo) {
        if (aConteudoAntigo != null && !aConteudoAntigo.equals("-")) {
            this.setConteudoAntigo((String)aConteudoAntigo);
        }
        LogPPGD.debug("Chamando observadores de " + this.getNomeCampo() + " [=" + this.toString() + "]");
        if (ControladorNegocio.isObservadoresAtivos() && this.isObservadoresAtivos()) {
            this.getObservadores().firePropertyChange(this.getNomeCampo(), aConteudoAntigo, this.asString());
        }
    }

    public boolean isObservadoresAtivos() {
        return this.observadoresAtivos;
    }

    public void setObservadoresAtivos(boolean b) {
        this.observadoresAtivos = b;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean pReadOnly) {
        LogPPGD.debug(this.getNomeCampo() + ".readOnly = " + String.valueOf(pReadOnly));
        boolean readOnlyAntigo = this.readOnly;
        this.readOnly = pReadOnly;
        if (this.isObservadoresAtivos() && readOnlyAntigo != this.readOnly) {
            this.getObservadores().firePropertyChange(READ_ONLY_PROPERTY, !pReadOnly, pReadOnly);
        }
    }

    public String getFicha() {
        return this.ficha;
    }

    public void setFicha(String string) {
        this.ficha = string;
    }

    public RetornosValidacoes getRetornoTodasValidacoes() {
        return this.retornoTodasValidacoes;
    }

    public void setRetornoTodasValidacoes(RetornosValidacoes retornoTodasValidacoes) {
        this.retornoTodasValidacoes = retornoTodasValidacoes;
    }

    public List<ValidadorIf> getListaValidadores() {
        if (this.listaValidadores == null) {
            this.listaValidadores = new ArrayList<ValidadorIf>(5);
        }
        return this.listaValidadores;
    }

    public void setNomeCampoCurto(String nomeCampoCurto) {
        this.nomeCampoCurto = nomeCampoCurto;
    }

    public String getNomeCampoCurto() {
        return this.nomeCampoCurto;
    }

    public void setHabilitado(boolean aHabilitado) {
        LogPPGD.debug(this.getNomeCampo() + ".isHabilitado = " + String.valueOf(aHabilitado));
        this.habilitado = aHabilitado;
        if (this.isObservadoresAtivos()) {
            this.getObservadores().firePropertyChange(HABILITADO_PROPERTY, !aHabilitado, aHabilitado);
        }
        this.habilitado = aHabilitado;
    }

    public void sinalizaValidoEdit() {
        this.getObservadores().firePropertyChange(VALIDO_PROPERTY, "Invalido", "Valido");
    }

    public boolean isHabilitado() {
        return this.habilitado;
    }

    public boolean isTransportado() {
        return this.transportado;
    }

    public void setTransportado(boolean transportado) {
        this.transportado = transportado;
    }

    public String getConteudoAntigo() {
        return this.conteudoAntigo;
    }

    public void setConteudoAntigo(String valorAntigo) {
        if (!valorAntigo.equals(this.asString())) {
            this.conteudoAntigo = valorAntigo;
        }
    }

    public void removeObservadores(Class<?>[] pTipoClasses) throws ClassNotFoundException {
        PropertyChangeListener[] observadores = this.getObservadores().getPropertyChangeListeners();
        for (int i = 0; i < observadores.length; ++i) {
            String nomeClasse = observadores[i].getClass().getName();
            Class<?> classeBase = null;
            classeBase = nomeClasse.indexOf("$") != -1 ? Class.forName(nomeClasse.substring(0, nomeClasse.indexOf("$"))) : observadores[i].getClass();
            if (!this.comparaClass(pTipoClasses, classeBase)) continue;
            this.getObservadores().removePropertyChangeListener(observadores[i]);
        }
    }

    private boolean comparaClass(Class<?>[] pTipoClasses, Class<?> tipoProcurado) {
        for (int tipoClasse = 0; tipoClasse < pTipoClasses.length; ++tipoClasse) {
            if (!pTipoClasses[tipoClasse].isAssignableFrom(tipoProcurado)) continue;
            return true;
        }
        return false;
    }

    public void removeObservadoresAnonimosDesnecessarios(Class<?> pClasse) throws ClassNotFoundException {
        PropertyChangeListener[] observadores = this.getObservadores().getPropertyChangeListeners();
        for (int i = 0; i < observadores.length; ++i) {
            Class<?> classeBase;
            String nomeClasse = observadores[i].getClass().getName();
            if (nomeClasse.indexOf("$") == -1 || !pClasse.isAssignableFrom(classeBase = Class.forName(nomeClasse.substring(0, nomeClasse.indexOf("$"))))) continue;
            this.getObservadores().removePropertyChangeListener(observadores[i]);
        }
    }

    public boolean isValidadoresAtivos() {
        return ControladorNegocio.isValidadoresAtivos() && this.validadoresAtivos;
    }

    public void setValidadoresAtivos(boolean validadoresAtivos) {
        this.validadoresAtivos = validadoresAtivos;
    }

    public void setUltimoConteudoValido(String ultimoConteudoValido) {
        this.ultimoConteudoValido = ultimoConteudoValido;
    }

    public String getUltimoConteudoValido() {
        return this.ultimoConteudoValido;
    }

    public List<ValidadorIf> getListaValidadoresImpeditivos() {
        if (this.listaValidadoresImpeditivos == null) {
            this.listaValidadoresImpeditivos = new ArrayList<ValidadorIf>(5);
        }
        return this.listaValidadoresImpeditivos;
    }

    public void ordenaListaValidadoreImpeditivos() {
        LinkedList<ValidadorImpeditivoDefault> auxListaImpeditivos = new LinkedList<ValidadorImpeditivoDefault>();
        LinkedList<ValidadorImpeditivoDefault> auxListaOkCancelar = new LinkedList<ValidadorImpeditivoDefault>();
        for (ValidadorImpeditivoDefault validadorImpeditivoDefault : this.getListaValidadoresImpeditivos()) {
            if (validadorImpeditivoDefault.getSeveridade() == 5) {
                auxListaImpeditivos.add(validadorImpeditivoDefault);
                continue;
            }
            if (validadorImpeditivoDefault.getSeveridade() != 4) continue;
            auxListaOkCancelar.add(validadorImpeditivoDefault);
        }
        auxListaImpeditivos.addAll(auxListaOkCancelar);
        this.getListaValidadoresImpeditivos().clear();
        this.getListaValidadoresImpeditivos().addAll(auxListaImpeditivos);
    }

    public boolean isAtributoPersistente() {
        return this.atributoPersistente;
    }

    public void setAtributoPersistente(boolean atributoPersistente) {
        this.atributoPersistente = atributoPersistente;
    }

    public String getAba() {
        return this.aba;
    }

    public void setAba(String aba) {
        this.aba = aba;
    }

    public boolean isDesprezarMascara() {
        return this.desprezarMascara;
    }

    public void setDesprezarMascara(boolean desprezarMascara) {
        this.desprezarMascara = desprezarMascara;
    }

    public Informacao getInformacaoAssociada(String tipoAssociacao) {
        return this.informacaoAssociada.get(tipoAssociacao);
    }

    public void setInformacaoAssociada(String tipoAssociacao, Informacao informacaoAssociada) {
        this.informacaoAssociada.put(tipoAssociacao, informacaoAssociada);
    }
}

