/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Iterator;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

class IteratorColecaoPPGD<E extends ObjetoNegocio>
implements Iterator<E> {
    private Iterator<E> implementacao;
    private Colecao<E> owner;
    private E objetoCorrente;

    public IteratorColecaoPPGD(Iterator<E> implementacao, Colecao<E> owner) {
        this.implementacao = implementacao;
        this.owner = owner;
    }

    @Override
    public boolean hasNext() {
        return this.implementacao.hasNext();
    }

    @Override
    public E next() {
        this.objetoCorrente = (ObjetoNegocio)this.implementacao.next();
        return this.objetoCorrente;
    }

    @Override
    public void remove() {
        this.owner.objetoARemover(this.objetoCorrente);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoAremover", "alterou", this.objetoCorrente);
        }
        this.implementacao.remove();
        this.owner.objetoRemovido(this.objetoCorrente);
        if (this.owner.isObservadoresListaAtivos()) {
            this.owner.getObservadoresLista().firePropertyChange("ObjetoRemovido", "alterou", this.objetoCorrente);
        }
    }
}

