/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;

class ValidadorDigitosInteirosRepetidos
extends ValidadorDefault {
    String msgValidacaoPersonalizada = null;

    public ValidadorDigitosInteirosRepetidos() {
        super((byte)2);
    }

    @Override
    public RetornoValidacao validarImplementado() {
        if (!this.getInformacao().isReadOnly()) {
            String parteInteira = ((Valor)this.getInformacao()).getParteInteira();
            Pattern p = Pattern.compile(".*(\\d)\\1{4,}.*");
            Matcher m = p.matcher(parteInteira);
            boolean possuiCaracteresRepetidos = m.find();
            if (possuiCaracteresRepetidos) {
                String mensagemValidacao = ConstantesGlobais.MSG_DIGITOS_INTEIROS_REPETIDOS;
                mensagemValidacao = mensagemValidacao.replaceAll("(@1)", this.getInformacao().getNomeCampo());
                this.setMensagemValidacao(mensagemValidacao);
                RetornoValidacao retorno = new RetornoValidacao(this.getMensagemValidacao(), this.getSeveridade());
                return retorno;
            }
        }
        return null;
    }
}

