/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.jasperreports;

import br.gov.serpro.midas.jasperreports.JRXmlDataSource;
import br.gov.serpro.midas.negocio.MidasReportElement;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackedJRXmlDataSource
extends JRXmlDataSource {
    private static final Logger log = LoggerFactory.getLogger(BackedJRXmlDataSource.class);
    private List<MidasReportElement> nodes;
    private MidasReportElement current;
    private int currentIndex = -1;

    public BackedJRXmlDataSource(JRXmlDataSource rootDS, String xPathSelection, List<MidasReportElement> reportElements) throws JRException {
        super(rootDS.getRoot(), xPathSelection);
    }

    public BackedJRXmlDataSource(MidasReportElement currentNode, String xPathSelection) throws JRException {
        super(currentNode, xPathSelection);
    }

    @Override
    public MidasReportElement getCurrent() {
        return this.current;
    }

    @Override
    public void moveFirst() throws JRException {
        this.debug("BackedDS.moveFirst-START");
        this.nodes = this.updateNodes(super.getXPathExpression());
        log.debug("Updated nodes: " + this.nodes);
        this.currentIndex = -1;
        this.current = null;
        this.debug("BackedDS.moveFirst-END");
    }

    @Override
    public boolean next() {
        if (log.isDebugEnabled()) {
            log.debug("BackedJRXmlDataSource.Moving next...");
        }
        log.debug("CurrentNode: " + this.current);
        log.debug("CurrentNodeIndex: " + this.currentIndex);
        int nodeListLength = this.nodes.size();
        log.debug("NodeListLength: " + nodeListLength);
        int max = nodeListLength - 1;
        log.debug("Max: " + max);
        if (this.currentIndex == max) {
            log.debug("Just reached node limit. No more nodes to move next!");
            return false;
        }
        ++this.currentIndex;
        log.debug("CurrentNodeIndex updated: " + this.currentIndex);
        this.current = this.nodes.get(this.currentIndex);
        this.debug("next-END");
        return true;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        this.debug("GettingFieldValue.start");
        MidasReportElement currentNode = this.getCurrent();
        if (log.isDebugEnabled()) {
            log.debug("CurrentNode: " + currentNode);
        }
        return this.getFieldValueConverted(jrField, currentNode);
    }

    @Override
    public List<MidasReportElement> getNodes() {
        return this.nodes;
    }

    @Override
    public String toString() {
        return "\n{BackedDataSource:\n backed.rootName: " + this.getRoot() + ", \n xPathExpression: " + this.getXPathExpression() + ", \n current: " + this.getCurrent() + ",\n currentIndex: " + this.currentIndex + "\n nodes: " + this.getNodes() + "\n childNodesLength: " + (this.getNodes() == null ? 0 : this.getNodes().size()) + "}";
    }
}

