/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.negocio;

import br.gov.serpro.midas.negocio.MidasReportElement;
import br.gov.serpro.midas.negocio.MidasReportElementLeaf;
import br.gov.serpro.midas.negocio.MidasReportElementParent;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MidasReportElementBuilder {
    Document doc;
    Logger log = LoggerFactory.getLogger(this.getClass());

    public MidasReportElementBuilder(InputStream in) throws Exception {
        this.doc = this.createDocumentBuilder().parse(in);
    }

    private DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new Exception("Failed to create a document builder factory", e);
        }
    }

    public MidasReportElement build() {
        Element rootElement = this.doc.getDocumentElement();
        return this.createComponent(rootElement, null);
    }

    private void addChildren(MidasReportElement midasReportElementParent, NodeList children) {
        for (int i = 0; i < children.getLength(); ++i) {
            Node childNode = children.item(i);
            MidasReportElement childComponent = this.createComponent(childNode, midasReportElementParent);
            if (childComponent == null) continue;
            midasReportElementParent.add(childComponent);
        }
    }

    private MidasReportElement createComponent(Node node, MidasReportElement parent) {
        Node first;
        short nodeType = node.getNodeType();
        String nodeValue = StringUtils.trimToNull((String)node.getNodeValue());
        if (nodeValue != null) {
            // empty if block
        }
        if (3 == nodeType && StringUtils.trimToNull((String)nodeValue) == null) {
            return null;
        }
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() == 1 && (first = node.getFirstChild()).getNodeType() == 3) {
            return new MidasReportElementLeaf(node.getNodeName(), first.getNodeValue(), parent);
        }
        if (childNodes.getLength() == 0) {
            return new MidasReportElementLeaf(node.getNodeName(), nodeValue, parent);
        }
        MidasReportElementParent parentElement = new MidasReportElementParent(node.getNodeName(), null, parent);
        this.addChildren(parentElement, childNodes);
        return parentElement;
    }

    public static MidasReportElement cloneToEmptyParentNode(MidasReportElement element, MidasReportElement parent) {
        MidasReportElementParent newElement = new MidasReportElementParent(element.getName(), element.getValue(), parent);
        return newElement;
    }

    public static MidasReportElement cloneNode(MidasReportElement element, MidasReportElement parent) {
        if (element.isEmpty()) {
            return new MidasReportElementLeaf(element.getName(), element.getValue(), parent);
        }
        MidasReportElement newElement = MidasReportElementBuilder.cloneToEmptyParentNode(element, parent);
        for (MidasReportElement child : element.getAll()) {
            newElement.add(child);
        }
        return newElement;
    }
}

