/*
 * fail.c
 *
 * Pass "fail" ioctl() to kernel
 *
 */

#include <linux/auto_fs.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>

int main(int argc, char *argv[]) {
  int fd, err, errn;
  unsigned long id;

  if ( argc != 3 )
    exit(1);

  fd = open(argv[1], O_RDONLY);
  if ( fd < 0 )
    perror(argv[1]);

  id = strtoul(argv[2], NULL, 0);

  errno = 0;
  err = ioctl(fd, AUTOFS_IOC_FAIL, id);
  errn = errno;
  printf("Send fail id = 0x%08lx, result = %d\n, errno = %d\n",
	 id, err, errn);
  exit(0);
}


