%define version 1.3.24
Name:		devfsd
Summary:	devfs daemon for device name compatibility
Version:	%{version}
Release:	1
Copyright:	GPL, Copyright Richard Gooch (rgooch@atnf.csiro.au)
Packager:	William Stearns <wstearns@pobox.com>
Group:		System Environment/Daemons
Source:		ftp://ftp.atnf.csiro.au/pub/people/rgooch/linux/daemons/devfsd-v%{version}.tar.gz
URL:		http://www.atnf.csiro.au/~rgooch/linux/
BuildRoot:	/tmp/devfsd-broot

%description
The devfsd programme is a daemon, run by the system boot
scripts which can provide for intelligent management of
device entries in the Device Filesystem (devfs).

%changelog
* Fri Nov 09 2001 Pavel Roskin <proski@gnu.org>
- Update source to 1.3.18.
- Eliminate patch - use fixed makefile instead.
- Allow compressed manuals and manuals in /usr/share/man.

* Sun Aug 20 2000 William Stearns <wstearns@pobox.com>
- Update source to 1.3.10
- Remove ps check from rc.sysinit; /proc may not be mounted.

* Wed May 18 2000 William Stearns <wstearns@pobox.com>
- Update source to 1.3.7.

* Wed Mar 01 2000 William Stearns <wstearns@pobox.com>
- removed init script; by then it's too late.  Stick devfsd in
/etc/rc.d/rc.sysinit

* Sat Feb 19 2000 William Stearns <wstearns@pobox.com>
- First spec file.  Includes buildroot support, Changelog, and init script.

%prep
%setup -n devfsd


%build
make


%install
make install PREFIX=$RPM_BUILD_ROOT MANDIR=$RPM_BUILD_ROOT/%{_mandir}

						
%clean
rm -rf $RPM_BUILD_ROOT


%post
if [ "$1" = "1" ]; then         #This package is being installed for the first time
	if [ -f /etc/rc.d/rc.sysinit ]; then
		if [ `cat /etc/rc.d/rc.sysinit | grep devfsd | wc -l` -eq 0 ]; then	#If no references to devfs yet
			#Add the following lines just after #!/bin/sh or #!/bin/bash.
			cat /etc/rc.d/rc.sysinit | sed -e 's@\(#!/bin/.*sh\)@\1\
if [ -c /dev/.devfsd ]; then                        #devfsdinstall\
    /sbin/devfsd /dev                               #devfsdinstall\
fi                                                  #devfsdinstall\
@' >/etc/rc.d/rc.sysinit.tmp
			cat /etc/rc.d/rc.sysinit.tmp >/etc/rc.d/rc.sysinit
			rm -f /etc/rc.d/rc.sysinit.tmp
		fi
	else
		echo You don\'t have an /etc/rc.d/rc.sysinit - you will need to add
		echo 'if [ -c /dev/.devfsd ]; then'
		echo '    /sbin/devfsd /dev'
		echo 'fi'
		echo to your initialization scripts, before any filesystem checking is done.
	fi
fi
if [ -f /etc/modules.conf ] && fgrep -q "Generic section: do not change" /etc/modules.conf ; then
    echo "Please remove the generic devfs entries from /etc/modules.conf"
elif [ -f /etc/conf.modules ] && fgrep -q "Generic section: do not change" /etc/conf.modules ; then
    echo "Please remove the generic devfs entries from /etc/conf.modules"
fi
				

%postun
if [ "$1" = "0" ]; then         #Final removal, not upgrade.
	if [ -f /etc/rc.d/rc.sysinit ]; then
		if [ `cat /etc/rc.d/rc.sysinit | grep devfsdinstall | wc -l` -gt 0 ]; then
			cat /etc/rc.d/rc.sysinit | grep -v devfsdinstall >/etc/rc.d/rc.sysinit.tmp
			cat /etc/rc.d/rc.sysinit.tmp >/etc/rc.d/rc.sysinit
			rm -f /etc/rc.d/rc.sysinit.tmp
		fi
	fi
fi
		

%files
%attr(644,root,root)	%config	/etc/devfsd.conf
%attr(644,root,root)	%config	/etc/modules.devfs
%attr(755,root,root)		/sbin/devfsd
%attr(644,root,root)		%{_mandir}/man8/devfsd.8*
%attr(644,root,root)		%{_mandir}/man5/devfsd.conf.5*

