/*
 * linux/mm/oom_notifier.c
 *
 */

#include <linux/init.h>
#include <linux/module.h>
#include <linux/notifier.h>
#include <asm/semaphore.h>

static DECLARE_MUTEX(notify_mutex);
static struct notifier_block * oom_notify_list = 0;

int register_oom_notifier(struct notifier_block * nb)
{
	int err;

	down(&notify_mutex);
	err = notifier_chain_register(&oom_notify_list, nb);
	up(&notify_mutex);

	return err;
}
EXPORT_SYMBOL(register_oom_notifier);

int unregister_oom_notifier(struct notifier_block * nb)
{
	int err;

	down(&notify_mutex);
	err = notifier_chain_unregister(&oom_notify_list, nb);
	up(&notify_mutex);

	return err;
}
EXPORT_SYMBOL(unregister_oom_notifier);

void out_of_memory(void)
{
	down(&notify_mutex);
	notifier_call_chain(&oom_notify_list, OUT_OF_MEMORY, 0);
	up(&notify_mutex);
}
EXPORT_SYMBOL(out_of_memory);
