/*
 *	Header file for sorted list which can be accessed via hashkey
 *
 *	Authors:
 *	Sami Kivisaari		<skivisaa@cc.hut.fi>	
 *
 *	$Id: s.hashlist.h 1.8 02/11/25 11:18:16+02:00 vnuorval@amber.hut.mediapoli.com $
 *
 *	This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 */

#ifndef _HASHLIST_H
#define _HASHLIST_H

#define ITERATOR_ERR -1
#define ITERATOR_CONT 0
#define ITERATOR_STOP 1
#define ITERATOR_DELETE_ENTRY 2

struct hashlist_entry {
	unsigned long sortkey;
	struct list_head sorted;
	struct list_head hashlist;
};

/*
 * hashlist_create - create new hashlist
 */
struct hashlist * hashlist_create(
	int bucketnum, int max_entries, size_t size, char *name,
	void (*ctor)(void *, kmem_cache_t *, unsigned long),
	void (*dtor)(void *, kmem_cache_t *, unsigned long),
	int (*compare)(void *data, void *hashkey),
	__u32 (*hash_function)(void *hashkey),
	void *(*get_hashkey)(void *data));

/*
 * hashlist_destroy - destroy a hashlist object
 */
void hashlist_destroy(struct hashlist *hashlist);

/**
 * hashlist_get - get element from hashlist
 **/
struct hashlist_entry *hashlist_get(struct hashlist *hashlist, void *hashkey);

/*
 * hashlist_alloc - allocate memory for new entry
 */
void *hashlist_alloc(struct hashlist *hashlist, int type);

/*
 * hashlist_free - free allocated entry
 */
void hashlist_free(struct hashlist *hashlist, struct hashlist_entry *he);
/*
 * hashlist_exists - check if element exists in hashlist
 */
int hashlist_exists(struct hashlist *hashlist, void *hashkey);

/*
 * hashlist_delete - delete entry from hashlist
 */
void hashlist_delete(struct hashlist *hashlist, struct hashlist_entry *he);

/*
 * hashlist_add - add a new entry to hashlist
 */
int hashlist_add(struct hashlist *hashlist, void *hashkey,
		 unsigned long sortkey, void *data);

/*
 * iterator function
 */
typedef int (*hashlist_iterator_t)(void *, void *, unsigned long *);

/*
 * hashlist_iterate - apply an iterator function for all items in hashlist
 */
int hashlist_iterate(struct hashlist *hashlist, void *args,
		     hashlist_iterator_t func);

/*
 * hashlist_get_first - return pointer to first element in structure
 */
void * hashlist_get_first(struct hashlist *hashlist);

/*
 * hashlist_reschedule - set entry to new position in the list
 */
int hashlist_reposition(struct hashlist *hashlist, struct hashlist_entry *he,
			unsigned long sortkey);

#endif
