// **********************************************************************
// * ibmasmincludes.h                                                   *
// *                                                                    *
// * Written by Matthew DeLoera (deloera@us.ibm.com)                    *
// * (C) Copyright IBM Corporation, 1998-2001                           *
// *                                                                    *
// *  This software may be used and distributed according to the terms  *
// *  of the GNU Public License, incorporated herein by reference.      *
// **********************************************************************

// **********************************************************************
// * This header contains all standard kernel includes and defines for  *
// * building a Linux driver. I spun it out to make my build process    *
// * more versatile to work across kernel versions, multiple dists.,    *
// * and multiple versions of each dist.                                *
// *                                                                    *
// * Changes                                                            *
// * -------                                                            *
// * 03/18/2001 - Creation.                                             *
// **********************************************************************


#include <linux/config.h>
#ifdef CONFIG_SMP
     #define __SMP__
#endif
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
     #define MODVERSIONS
#endif
#ifdef MODVERSIONS
     #include <linux/modversions.h>
#endif
#include <linux/delay.h>
#include <linux/fs.h>
#include <linux/kernel.h>
// #include <linux/malloc.h>      // PHR_180252 
#include <linux/slab.h>           // PHR_180252
#ifdef UwsCmd_c
     #include <linux/module.h>   // ONLY INCLUDE THIS IN THE "MAIN" SOURCE FILE
#endif
#include <linux/pci.h>
#include <linux/sched.h>
#include <linux/signal.h>
#include <linux/timer.h>
#include <linux/tqueue.h>
#include <linux/types.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>
#ifndef LINUX_VERSION_CODE
     #include <linux/version.h>
#endif

// SPINLOCKS WERE NOT SUPPORTED UNTIL KERNEL VERSION 2.4 
#if LINUX_VERSION_CODE >= 132096
  #include <linux/spinlock.h>            
#endif
