/*
 * Connection tracking dependency helper module
 *
 * Authors: Michael Bellion and Thomas Heinz
 * (c) 2002-2003 by the hipac core team <nf@hipac.org>:
 *      +-----------------------+----------------------+
 *      |   Michael Bellion     |     Thomas Heinz     |
 *      | <mbellion@hipac.org>  |  <creatix@hipac.org> |
 *      +-----------------------+----------------------+
 * Licenced under the GNU General Public Licence, version >= 2.
 */


#include <linux/module.h>
#include <linux/version.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/netfilter_ipv4/ip_conntrack.h>
#include "nfhp_mod.h"

static int
__init init(void)
{
	if (nfhp_register_cthelp(THIS_MODULE)) {
		return -EINVAL;
	}
	return 0;
}

static void
__exit fini(void)
{
	nfhp_unregister_cthelp(THIS_MODULE);
}

module_init(init);
module_exit(fini);
MODULE_AUTHOR("Michael Bellion and Thomas Heinz");
MODULE_DESCRIPTION("NF-HIPAC - connection tracking dependency helper module");
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 10)
MODULE_LICENSE("GPL");
#endif
