/* -*- c -*- ------------------------------------------------------------- *
 *
 *   Copyright 2004 Murali Krishnan Ganapathy - All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, Inc., 53 Temple Place Ste 330,
 *   Bostom MA 02111-1307, USA; either version 2 of the License, or
 *   (at your option) any later version; incorporated herein by reference.
 *
 * ----------------------------------------------------------------------- */

/* This program can be compiled for DOS with the OpenWatcom compiler
 * (http://www.openwatcom.org/):
 *
 * wcl -3 -osx -mt <filename>.c
 */

#ifndef __MENU_H__
#define __MENU_H__

#include "biosio.h"
#include "string.h"

// Scancodes of some keys
#define ESCAPE     1
#define ENTERA    28
#define ENTERB   224

#define HOMEKEY  71
#define UPARROW  72
#define PAGEUP   73
#define LTARROW  75
#define RTARROW  77
#define ENDKEY   79
#define DNARROW  80
#define PAGEDN   81
#define SPACEKEY 57 // Scan code for SPACE

// Attributes
#define NORMALATTR   0x17
#define REVERSEATTR  0x70
#define INACTATTR    0x18
#define REVINACTATTR 0x78
#define STATUSATTR   0x74
#define FILLCHAR     177
#define FILLATTR     0x01
#define SHADOWATTR   0x00
#define SPACECHAR    ' '

#define TFILLCHAR    ' '
#define TITLEATTR    0x70

// Single line Box drawing Chars

#define TOPLEFT  218
#define BOTLEFT  192
#define TOPRIGHT 191
#define BOTRIGHT 217
#define TOP      196
#define BOT      196
#define LEFT     179
#define RIGHT    179
#define HORIZ    196
#define LTRT     195 // The |- char
#define RTLT     180 // The -| char

// Double line Box Drawing Chars
/*
#define TOPLEFT  201
#define BOTLEFT  200
#define TOPRIGHT 187
#define BOTRIGHT 188
#define TOP      205
#define BOT      205
#define LEFT     186
#define RIGHT    186
#define HORIZ    205
#define LTRT     199 // The ||- char
#define RTLT     182 // The -|| char
*/

// Attributes of the menu system
#define MAXMENUS      8 // Maximum number of menu's allowed
#define MAXMENUSIZE   12 // Maximum number of entries in each menu

// Upper bounds on lengths
// Now that the onus of allocating space is with the user, these numbers
// are only for sanity checks. You may increase these values without
// affecting the memory footprint of this program
#define MENULEN       30 // Each menu entry is atmost MENULEN chars
#define STATLEN       80 // Maximum length of status string
#define ACTIONLEN     80 // Maximum length of an action string

// Layout of menu
#define MENUROW       3  // Row where menu is displayed (relative to window)
#define MENUCOL       4  // Col where menu is displayed (relative to window)
#define MENUPAGE      1  // show in display page 1
#define STATLINE      23 // Line number where status line starts (relative to window)

// Other Chars
#define SUBMENUCHAR   175 // This is >> symbol
#define RADIOMENUCHAR '>' // > symbol for radio menu? 
#define EXITMENUCHAR  174 // This is << symbol
#define CHECKED       251 // Check mark
#define UNCHECKED     250 // Light bullet
#define RADIOSEL      '.' // Current Radio Selection 
#define RADIOUNSEL    ' ' // Radio option not selected

// Types of menu's
#define NORMALMENU 1 
#define RADIOMENU  2

typedef enum {OPT_INACTIVE, OPT_SUBMENU, OPT_RUN, OPT_EXITMENU, OPT_CHECKBOX,
	      OPT_RADIOMENU, OPT_EXIT, OPT_SEP, OPT_INVISIBLE,
	      OPT_RADIOITEM} t_action;

typedef union {
  char submenunum; // For submenu's
  char checked; // For check boxes
  char radiomenunum; // Item mapping to a radio menu
} t_itemdata;

struct s_menuitem;
struct s_menu;
struct s_menusystem;

typedef void (*t_item_handler)(struct s_menusystem *, struct s_menuitem *);
typedef void (*t_menusystem_handler)(struct s_menusystem *, struct s_menuitem *);

typedef struct s_menuitem {
  const char *item;
  const char *status;
  const char *data; // string containing kernel to run.. but... 
  // for radio menu's this is a pointer to the item selected or NULL (initially)
  void * extra_data; // Any other data user can point to
  t_item_handler handler; // Pointer to function of type menufn
  t_action action;
  t_itemdata itemdata; // Data depends on action value
  char index; // Index within the menu array
  char parindex; // Index of the menu in which this item appears. 
} t_menuitem;

typedef t_menuitem *pt_menuitem; // Pointer to type menuitem

typedef struct s_menu {
  pt_menuitem items[MAXMENUSIZE];
  const char *title;
  char numitems;
  char numvisible;
  char menuwidth;
  char row,col; // Position where this menu should be displayed
} t_menu;

typedef t_menu *pt_menu; // Pointer to type menu

typedef struct s_menusystem {
  pt_menu menus[MAXMENUS];
  const char *title; 
  t_menusystem_handler handler; // Handler function called every time a menu is re-printed.
  char nummenus;
  char normalattr; 
  char reverseattr;
  char inactattr;
  char revinactattr;
  char statusattr;
  char fillchar;
  char fillattr;
  char spacechar;
  char tfillchar;
  char titleattr;
  char shadowattr;
  char statline;
  char menupage;
  char maxrow,minrow,numrows; // Number of rows in the window 
  char maxcol,mincol,numcols; // Number of columns in the window
} t_menusystem;

typedef t_menusystem *pt_menusystem; // Pointer to type menusystem

/************************************************************************
 * IMPORTANT INFORMATION
 *
 * All functions which take a string as argument store the pointer
 * for later use. So if you have tfillDther daOrokoeng ar rathe windo a 'RTANlXsdef ts*****onu entting ttshouG7
#defin  tt R
//def N#de_ng ttshone UNCHECKED     250_SEP, OPT_INVISIro N1************ENU, OPTkoeng HECKE_TANlXsdef tmnseDthrra dependar> is atmo_E_TE ependar> is atmo_ VISIdioE  Nmelmg actnhandler)(sayou hY (;c#de_ng tLb/ This is  *********
 Iata depends on syswm {u. So if young anumberstrinbTcHECKED     2pendar> is eXL*Ntr> is ettumberstrinb3{u. So if yomuitem *thrlhisua(numbMATION
 *
 * All functions which take a string as argue"l)xSPACEKEY Repenhich take a strip eXLECKEDp lOo***n**
 IatH)elecV> is eta string as uRo1or7t>vm1andler handler; //3s*, struct s_meppt_a7yCKEDrdBnNumbegl*RndaoatH)erpoint to
  t_item)xSP revi;
 koenpD as uRo1or7t>vm1andler handler; //3s*, struct s_meppt_a7yCKEDrdBnNumbegl*RndaookoengMypor7t>vm1whis is  **f-  a strl.tof type6r_uecons;c#de_ng tLb/pt_menuitem items[MAXMENUSIZE]; //3s*,/e pTmHe'pt_ vtntfArtr;
 **** XITem
 oftfArtrr; /  type6r_us8L*Ntr> as[MAXnnt trftntt
  const2Zehi dependar>rwENc#de_
 Iato a 'ECKEDp lOo***/3s*xacechaIar space type6tfAtt
  const2Zeo 250_SEP, OPTw ECKa*/3s*xa ECKapaxcolwhar sta"HECKED    o type menu

typed*p s*xbolwhar tu *p s*xbolwhardare// strHAR paxcolwhuEepacechar;
  char tfilsxlwhu
 *a strit 1 ur tr,/e pr;
 *.sCauAE2H(aceECKa*/3s*xa ECKp37t>atus line>// strH.7t>aaceEma depK3s*xac
//def N#de_ngon syswm {u. SoC pede// IndeCta"/ Ind ta"/ Ind tae trit 1"/ U// uexcMENUSl Ekx_ Ind2      OPT7)r tfendeCtE0Indt>vm1anttnD;      C_
nECKapaxcolwhaTmenuEAEma depK3p|T KuEepacechar;
;
  s1ee/nX'                                                                                                                                      