/* pngvcrd.c - mixed C/assembler version of utilities to read a PNG file
 *
 * For Intel x86 CPU and Microsoft Visual C++ compiler
 *
 * libpng version 1.2.8 - December 3, 2004
 * For conditions of distribution and use, see copyright notice in png.h
 * Copyright (c) 1998-2004 Glenn Randers-Pehrson
 * Copyright (c) 1998, Intel Corporation
 *
 * Contributed by Nirav Chhatrapati, Intel Corporation, 1998
 * Interface to libpng contributed by Gilles Vollant, 1999
 *
 *
 * In png_do_read_interlace() in libpng versions 1.0.3a through 1.0.4d,
 * a sign error in the post-MMX cleanup code for each pixel_depth resulted
 * in bad pixels at the beginning of some rows of some images, and also
 * (due to out-of-range memory reads and writes) caused heap corruption
 * when compiled with MSVC 6.0.  The error was fixed in version 1.0.4e.
 *
 * [png_read_filter_row_mmx_avg() bpp == 2 bugfix, GRR 20000916]
 *
 * [runtime MMX configuration, GRR 20010102]
 *
 */

#define PNG_INTERNAL
#include "png.h"

#if defined(PNG_ASSEMBLER_CODE_SUPPORTED) && defined(PNG_USE_PNGVCRD)

static int mmx_supported=2;


int PNGAPI
png_mmx_support(void)
{
  int mmx_supported_local = 0;
  _asm {
    push ebx          //CPUID will trash these
    push ecx
    push edx

    pushfd            //Save Eflag to stack
    pop eax           //Get Eflag from stack into eax
    mov ecx, eax      //Make another copy of Eflag in ecx
    xor eax, 0x200000 //Toggle ID bit in Eflag [i.e. bit(21)]
    push eax          //Save modified Eflag back to stack

    popfd             //Restored modified value back to Eflag reg
    pushfd            //Save Eflag to stack
    pop eax           //Get Eflag from stack
    push ecx          // save original Eflag to stack
    popfd             // restore original Eflag
    xor eax, ecx      //Compare the new Eflag with the original Eflag
    jz NOT_SUPPORTED  //If the same, CPUID instruction is not supported,
                      //skip following instructions and jump to
                      //NOT_SUPPORTED label

    xor eax, eax      //Set eax to zero

    _asm _emit 0x0f   //CPUID instruction  (two bytes opcode)
    _asm _emit 0xa2

    cmp eax, 1        //make sure eax return non-zero value
    jl NOT_SUPPORTED  //If eax is zero, mmx not supported

    xor eax, eax      //set eax to zero
    inc eax           //Now increment eax to 1.  This instruction is
                      //faster than the instruction "mov eax, 1"

    _asm _emit 0x0f   //CPUID instruction
    _asm _emit 0xa2

    and edx, 0x00800000  //mask out all bits but mmx bit(24)
    cmp edx, 0        // 0 = mmx not supported
    jz  NOT_SUPPORTED // non-zero = Yes, mmx IS supported

    mov  mmx_supported_local, 1  //set return value to 1

NOT_SUPPORTED:
    mov  eax, mmx_supported_local  //move return value to eax
    pop edx          //CPUID trashed these
    pop ecx
    pop ebx
  }

  //mmx_supported_local=0; // test code for force don't support MMX
  //printf("MMX : %u (1=MMX supported)\n",mmx_supported_local);

  mmx_supported = mmx_supported_local;
  return mmx_supported_local;
}

/* Combines the row recently read in with the previous row.
   This routine takes care of alpha and transparency if requested.
   This routine also handles the two methods of progressive display
   of interlaced images, depending on the mask value.
   The mask value describes which pixels are to be combined with
   the row.  The pattern always repeats every 8 pixels, so just 8
   bits are needed.  A one indicates the pixel is to be combined; a
   zero indicates the pixel is to be skipped.  This is in addition
   to any alpha or transparency value associated with the pixel.  If
   you want all pixels to be combined, pass 0xff (255) in mask.  */

/* Use this routine for x86 platform - uses faster MMX routine if machine
   supports MMX */

void /* PRIVATE */
png_combine_row(png_structp png_ptr, png_bytep row, int mask)
{
#ifdef PNG_USE_LOCAL_ARRAYS
   const int png_pass_inc[7] = {8, 8, 4, 4, 2, 2, 1};
#endif

   png_debug(1,"in png_combine_row_asm\n");

   if (mmx_supported == 2) {
#if !defined(PNG_1_0_X)
       /* this should have happened in png_init_mmx_flags() already */
       png_warning(png_ptr, "asm_flags may not have been initialized");
#endif
       png_mmx_support();
   }

   if (mask == 0xff)
   {
      png_memcpy(row, png_ptr->row_buf + 1,
       (png_size_t)PNG_ROWBYTES(png_ptr->row_info.pixel_depth,
       png_ptr->width));
   }
   /* GRR:  add "else if (mask == 0)" case?
    *       or does png_combine_row() not even get called in that case? */
   else
   {
      switch (png_ptr->row_info.pixel_depth)
      {
         case 1:
         {
            png_bytep sp;
            png_bytep dp;
            int s_inc, s_start, s_end;
            int m;
            int shift;
            png_uint_32 i;

            sp = png_ptr->row_buf + 1;
            dp = row;
            m = 0x80;
#if defined(PNG_READ_PACKSWAP_SUPPORTED)
            if (png_ptr->transformations & PNG_PACKSWAP)
            {
                s_start = 0;
                s_end = 7;
                s_inc = 1;
            }
            else
#endif
            {
                s_start = 7;
                s_end = 0;
                s_inc = -1;
            }

            shift = s_start;

            for (i = 0; i < png_ptr->width; i++)
            {
               if (m & mask)
               {
                  int value;

                  value = (*sp >> shift) & 0x1;
                  *dp &= (png_byte)((0x7f7f >> (7 - shift)) & 0xff);
                  *dp |= (png_byte)(value << shift);
               }

               if (shift == s_end)
               {
                  shift = s_start;
                  sp++;
                  dp++;
               }
               else
                  shift += s_inc;

               if (m == 1)
                  m = 0x80;
               else
                  m >>= 1;
            }
            break;
         }

         case 2:
         {
            png_bytep sp;
            png_bytep dp;
            int s_start, s_end, s_inc;
            int m;
            int shift;
            png_uint_32 i;
            int value;

            sp = png_ptr->row_buf + 1;
            dp = row;
            m = 0x80;
#if defined(PNG_READ_PACKSWAP_SUPPORTED)
            if (png_ptr->transformations & PNG_PACKSWAP)
            {
               s_start = 0;
               s_end = 6;
               s_inc = 2;
            }
            else
#endif
            {
               s_start = 6;
               s_end = 0;
               s_inc = -2;
            }

            shift = s_start;

            for (i = 0; i < png_ptr->width; i++)
            {
               if (m & mask)
               {
                  value = (*sp >> shift) & 0x3;
                  *dp &= (png_byte)((0x3f3f >> (6 - shift)) & 0xff);
                  *dp |= (png_byte)(value << shift);
               }

               if (shift == s_end)
               {
                  shift = s_start;
                  sp++;
                  dp++;
               }
               else
                  shift += s_inc;
               if (m == 1)
                  m = 0x80;
               else
                  m >>= 1;
            }
            break;
         }

         case 4:
         {
            png_bytep sp;
            png_bytep dp;
            int s_start, s_end, s_inc;
            int m;
            int shift;
            png_uint_32 i;
            int value;

            sp = png_ptr->row_buf + 1;
            dp = row;
            m = 0x80;
#if defined(PNG_READ_PACKSWAP_SUPPORTED)
            if (png_ptr->transformations & PNG_PACKSWAP)
            {
               s_start = 0;
               s_end = 4;
               s_inc = 4;
            }
            else
#endif
            {
               s_start = 4;
               s_end = 0;
               s_inc = -4;
            }
            shift = s_start;

            for (i = 0; i < png_ptr->width; i++)
            {
               if (m & mask)
               {
                  value = (*sp >> shift) & 0xf;
                  *dp &= (png_byte)((0xf0f >> (4 - shift)) & 0xff);
                  *dp |= (png_byte)(value << shift);
               }

               if (shift == s_end)
               {
                  shift = s_start;
                  sp++;
                  dp++;
               }
               else
                  shift += s_inc;
               if (m == 1)
                  m = 0x80;
               else
                  m >>= 1;
            }
            break;
         }

         case 8:
         {
            png_bytep srcptr;
            png_bytep dstptr;
            png_uint_32 len;
            int m;
            int diff, unmask;

            __int64 mask0=0x0102040810204080;

#if !defined(PNG_1_0_X)
            if ((png_ptr->asm_flags & PNG_ASM_FLAG_MMX_READ_COMBINE_ROW)
                /* && mmx_supported */ )
#else
            if (mmx_supported)
#endif
            {
               srcptr = png_ptr->row_buf + 1;
               dstptr = row;
               m = 0x80;
               unmask = ~mask;
               len  = png_ptr->width &~7;  //reduce to multiple of 8
               diff = png_ptr->width & 7;  //amount lost

               _asm
               {
                  movd       mm7, unmask   //load bit pattern
                  psubb      mm6,mm6       //zero mm6
                  punpcklbw  mm7,mm7
                  punpcklwd  mm7,mm7
                  punpckldq  mm7,mm7       //fill register with 8 masks

                  movq       mm0,mask0

                  pand       mm0,mm7       //nonzero if keep byte
                  pcmpeqb    mm0,mm6       //zeros->1s, v versa

                  mov        ecx,len       //load length of line (pixels)
                  mov        esi,srcptr    //load source
                  mov        ebx,dstptr    //load dest
                  cmp        ecx,0         //lcr
                  je         mainloop8end

mainloop8:
                  movq       mm4,[esi]
                  pand       mm4,mm0
                  movq       mm6,mm0
                  pandn      mm6,[ebx]
                  por        mm4,mm6
                  movq       [ebx],mm4

                  add        esi,8         //inc by 8 bytes processed
                  add        ebx,8
                  sub        ecx,8         //dec by 8 pixels processed

                  ja         mainloop8
mainloop8end:

                  mov        ecx,diff
                  cmp        ecx,0
                  jz         end8

                  mov        edx,mask
                  sal        edx,24        //make low byte the high byte

secondloop8:
                  sal        edx,1         //move high bit to CF
                  jnc        skip8         //if CF = 0
                  mov        al,[esi]
                  mov        [ebx],al
skip8:
                  inc        esi
                  inc        ebx

                  dec        ecx
                  jnz        secondloop8
end8:
                  emms
               }
            }
            else /* mmx not supported - use modified C routine */
            {
               register unsigned int incr1, initial_val, final_val;
               png_size_t pixel_bytes;
               png_uint_32 i;
               register int disp = png_pass_inc[png_ptr->pass];
               int offset_table[7] = {0, 4, 0, 2, 0, 1, 0};

               pixel_bytes = (png_ptr->row_info.pixel_depth >> 3);
               srcptr = png_ptr->row_buf + 1 + offset_table[png_ptr->pass]*
                  pixel_bytes;
               dstptr = row + offset_table[png_ptr->pass]*pixel_bytes;
               initial_val = offset_table[png_ptr->pass]*pixel_bytes;
               final_val = png_ptr->width*pixel_bytes;
               incr1 = (disp)*pixel_bytes;
               for (i = initial_val; i < final_val; i += incr1)
               {
                  png_memcpy(dstptr, srcptr, pixel_bytes);
                  srcptr += incr1;
                  dstptr += incr1;
               }
            } /* end of else */

            break;
         }       // end 8 bpp

         case 16:
         {
            png_bytep srcptr;
            png_bytep dstptr;
            png_uint_32 len;
            int unmask, diff;
            __int64 mask1=0x0101020204040808,
                    mask0=0x1010202040408080;

#if !defined(PNG_1_0_X)
            if ((png_ptr->asm_flags & PNG_ASM_FLAG_MMX_READ_COMBINE_ROW)
                /* && mmx_supported */ )
#else
            if (mmx_supported)
#endif
            {
               srcptr = png_ptr->row_buf + 1;
               dstptr = row;

               unmask = ~mask;
               len     = (png_ptr->width)&~7;
               diff = (png_ptr->width)&7;
               _asm
               {
                  movd       mm7, unmask       //load bit pattern
                  psubb      mm6,mm6           //zero mm6
                  punpcklbw  mm7,mm7
                  punpcklwd  mm7,mm7
                  punpckldq  mm7,mm7           //fill register with 8 masks

                  movq       mm0,mask0
                  movq       mm1,mask1

                  pand       mm0,mm7
                  pand       mm1,mm7

                  pcmpeqb    mm0,mm6
                  pcmpeqb    mm1,mm6

                  mov        ecx,len           //load length of line
                  mov        esi,srcptr        //load source
                  mov        ebx,dstptr        //load dest
                  cmp        ecx,0             //lcr
                  jz         mainloop16end

mainloop16:
                  movq       mm4,[esi]
                  pand       mm4,mm0
                  movq       mm6,mm0
                  movq       mm7,[ebx]
                  pandn      mm6,mm7
                  por        mm4,mm6
                  movq       [ebx],mm4

                  movq       mm5,[esi+8]
                  pand       mm5,mm1
                  movq       mm7,mm1
                  movq       mm6,[ebx+8]
                  pandn      mm7,mm6
                  por        mm5,mm7
                  movq       [ebx+8],mm5

                  add        esi,16            //inc by 16 bytes processed
                  add        ebx,16
                  sub        ecx,8             //dec by 8 pixels processed

                  ja         mainloop16

mainloop16end:
                  mov        ecx,diff
                  cmp        ecx,0
                  jz         end16

                  mov        edx,mask
                  sal        edx,24            //make low byte the high byte
secondloop16:
                  sal        edx,1             //move high bit to CF
                  jnc        skip16            //if CF = 0
                  mov        ax,[esi]
                  mov        [ebx],ax
skip16:
                  add        esi,2
                  add        ebx,2

                  dec        ecx
                  jnz        secondloop16
end16:
                  emms
               }
            }
            else /* mmx not supported - use modified C routine */
            {
               register unsigned int incr1, initial_val, final_val;
               png_size_t pixel_bytes;
               png_uint_32 i;
               register int disp = png_pass_inc[png_ptr->pass];
               int offset_table[7] = {0, 4, 0, 2, 0, 1, 0};

               pixel_bytes = (png_ptr->row_info.pixel_depth >> 3);
               srcptr = png_ptr->row_buf + 1 + offset_table[png_ptr->pass]*
                  pixel_bytes;
               dstptr = row + offset_table[png_ptr->pass]*pixel_bytes;
               initial_val = offset_table[png_ptr->pass]*pixel_bytes;
               final_val = png_ptr->width*pixel_bytes;
               incr1 = (disp)*pixel_bytes;
               for (i = initial_val; i < final_val; i += incr1)
               {
                  png_memcpy(dstptr, srcptr, pixel_bytes);
                  srcptr += incr1;
                  dstptr += incr1;
               }
            } /* end of else */

            break;
         }       // end 16 bpp

         case 24:
         {
            png_bytep srcptr;
            png_bytep dstptr;
            png_uint_32 len;
            int unmask, diff;

            __int64 mask2=0x0101010202020404,  //24bpp
                    mask1=0x0408080810101020,
                    mask0=0x2020404040808080;

            srcptr = png_ptr->row_buf + 1;
            dstptr = row;

            unmask = ~mask;
            len     = (png_ptr->width)&~7;
            diff = (png_ptr->width)&7;

#if !defined(PNG_1_0_X)
            if ((png_ptr->asm_flags & PNG_ASM_FLAG_MMX_READ_COMBINE_ROW)
                /* && mmx_supported */ )
#else
            if (mmx_supported)
#endif
            {
               _asm
               {
                  movd       mm7, unmask       //load bit pattern
                  psubb      mm6,mm6           //zero mm6
                  punpcklbw  mm7,mm7
                  punpcklwd  mm7,mm7
                  punpckldq  mm7,mm7           //fill register with 8 masks

                  movq       mm0,mask0
                  movq       mm1,mask1
                  movq       mm2,mask2

                  pand       mm0,mm7
                  pand       mm1,mm7
                  pand       mm2,mm7

                  pcmpeqb    mm0,mm6
                  pcmpeqb    mm1,mm6
                  pcmpeqb    mm2,mm6

                  mov        ecx,len           //load length of line
                  mov        esi,srcptr        //load source
                  mov        ebx,dstptr        //load dest
                  cmp        ecx,0
                  jz         mainloop24end

mainloop24:
                  movq       mm4,[esi]
                  pand       mm4,mm0
                  movq       mm6,mm0
                  movq       mm7,[ebx]
                  pandn      mm6,mm7
                  por        mm4,mm6
                  movq       [ebx],mm4


                  movq       mm5,[esi+8]
                  pand       mm5,mm1
                  movq       mm7,mm1
                  movq       mm6,[ebx+8]
                  pandn      mm7,mm6
                  por        mm5,mm7
                  movq       [ebx+8],mm5

                  movq       mm6,[esi+16]
                  pand       mm6,mm2
                  movq       mm4,mm2
                  movq       mm7,[ebx+16]
                  pandn      mm4,mm7
                  por        mm6,mm4
                  movq       [ebx+16],mm6

                  add        esi,24            //inc by 24 bytes processed
                  add        ebx,24
                  sub        ecx,8             //dec by 8 pixels processed

                  ja         mainloop24

mainloop24end:
                  mov        ecx,diff
                  cmp        ecx,0
                  jz         end24

                  mov        edx,mask
                  sal        edx,24            //make low byte the high byte
secondloop24:
                  sal        edx,1             //move high bit to CF
                  jnc        skip24            //if CF = 0
                  mov        ax,[esi]
                  mov        [ebx],ax
                  xor        eax,eax
                  mov        al,[esi+2]
                  mov        [ebx+2],al
skip24:
                  add        esi,3
                  add        ebx,3

                  dec        ecx
                  jnz        secondloop24

end24:
                  emms
               }
            }
            else /* mmx not supported - use modified C routine */
            {
               register unsigned int incr1, initial_val, final_val;
               png_size_t pixel_bytes;
               png_uint_32 i;
               register int disp = png_pass_inc[png_ptr->pass];
               int offset_table[7] = {0, 4, 0, 2, 0, 1, 0};

               pixel_bytes = (png_ptr->row_info.pixel_depth >> 3);
               srcptr = png_ptr->row_buf + 1 + offset_table[png_ptr->pass]*
                  pixel_bytes;
               dstptr = row + offset_table[png_ptr->pass]*pixel_bytes;
               initial_val = offset_table[png_ptr->pass]*pixel_bytes;
               final_val = png_ptr->width*pixel_bytes;
               incr1 = (disp)*pixel_bytes;
               for (i = initial_val; i < final_val; i += incr1)
               {
                  png_memcpy(dstptr, srcptr, pixel_bytes);
                  srcptr += incr1;
                  dstptr += incr1;
               }
            } /* end of else */

            break;
         }       // end 24 bpp

         case 32:
         {
            png_bytep srcptr;
            png_bytep dstptr;
            png_uint_32 len;
            int unmask, diff;

            __int64 mask3=0x0101010102020202,  //32bpp
                    mask2=0x0404040408080808,
                    mask1=0x1010101020202020,
                    mask0=0x4040404080808080;

            srcptr = png_ptr->row_buf + 1;
            dstptr = row;

            unmask = ~mask;
            len     = (png_ptr->width)&~7;
            diff = (png_ptr->width)&7;

#if !defined(PNG_1_0_X)
            if ((png_ptr->asm_flags & PNG_ASM_FLAG_MMX_READ_COMBINE_ROW)
                /* && mmx_supported */ )
#else
            if (mmx_supported)
#endif
            {
               _asm
               {
                  movd       mm7, unmask       //load bit pattern
                  psubb      mm6,mm6           //zero mm6
                  punpcklbw  mm7,mm7
                  punpcklwd  mm7,mm7
                  punpckldq  mm7,mm7           //fill register with 8 masks

                  movq       mm0,mask0
                  movq       mm1,mask1
                  movq       mm2,mask2
                  movq       mm3,mask3

                  pand       mm0,mm7
                  pand       mm1,mm7
                  pand       mm2,mm7
                  pand       mm3,mm7

                  pcmpeqb    mm0,mm6
                  pcmpeqb    mm1,mm6
                  pcmpeqb    mm2,mm6
                  pcmpeqb    mm3,mm6

                  mov        ecx,len           //load length of line
                  mov        esi,srcptr        //load source
                  mov        ebx,dstptr        //load dest

                  cmp        ecx,0             //lcr
                  jz         mainloop32end

mainloop32:
                  movq       mm4,[esi]
                  pand       mm4,mm0
                  movq       mm6,mm0
                  movq       mm7,[ebx]
                  pandn      mm6,mm7
                  por        mm4,mm6
                  movq       [ebx],mm4

                  movq       mm5,[esi+8]
                  pand       mm5,mm1
                  movq       mm7,mm1
                  movq       mm6,[ebx+8]
                  pandn      mm7,mm6
                  por        mm5,mm7
                  movq       [ebx+8],mm5

                  movq       mm6,[esi+16]
                  pand       mm6,mm2
                  movq       mm4,mm2
                  movq       mm7,[ebx+16]
                  pandn      mm4,mm7
                  por        mm6,mm4
                  movq       [ebx+16],mm6

                  movq       mm7,[esi+24]
                  pand       mm7,mm3
                  movq       mm5,mm3
                  movq       mm4,[ebx+24]
                  pandn      mm5,mm4
                  por        mm7,mm5
                  movq       [ebx+24],mm7

                  add        esi,32            //inc by 32 bytes processed
                  add        ebx,32
                  sub        ecx,8             //dec by 8 pixels processed

                  ja         mainloop32

mainloop32end:
                  mov        ecx,diff
                  cmp        ecx,0
                  jz         end32

                  mov        edx,mask
                  sal        edx,24            //make low byte the high byte
secondloop32:
                  sal        edx,1             //move high bit to CF
                  jnc        skip32            //if CF = 0
                  mov        eax,[esi]
                  mov        [ebx],eax
skip32:
                  add        esi,4
                  add        ebx,4

                  dec        ecx
                  jnz        secondloop32

end32:
                  emms
               }
            }
            else /* mmx _not supported - Use modified C routine */
            {
               register unsigned int incr1, initial_val, final_val;
               png_size_t pixel_bytes;
               png_uint_32 i;
               register int disp = png_pass_inc[png_ptr->pass];
               int offset_table[7] = {0, 4, 0, 2, 0, 1, 0};

               pixel_bytes = (png_ptr->row_info.pixel_depth >> 3);
               srcptr = png_ptr->row_buf + 1 + offset_table[png_ptr->pass]*
                  pixel_bytes;
               dstptr = row + offset_table[png_ptr->pass]*pixel_bytes;
               initial_val = offset_table[png_ptr->pass]*pixel_bytes;
               final_val = png_ptr->width*pixel_bytes;
               incr1 = (disp)*pixel_bytes;
               for (i = initial_val; i < final_val; i += incr1)
               {
                  png_memcpy(dstptr, srcptr, pixel_bytes);
                  srcptr += incr1;
                  dstptr += incr1;
               }
            } /* end of else */

            break;
         }       // end 32 bpp

         case 48:
         {
            png_bytep srcptr;
            png_bytep dstptr;
            png_uint_32 len;
            int unmask, diff;

            __int64 mask5=0x0101010101010202,
                    mask4=0x0202020204040404,
                    mask3=0x0404080808080808,
                    mask2=0x1010101010102020,
                    mask1=0x2020202040404040,
                    mask0=0x4040808080808080;

#if !defined(PNG_1_0_X)
            if ((png_ptr->asm_flags & PNG_ASM_FLAG_MMX_READ_COMBINE_ROW)
                /* && mmx_supported */ )
#else
            if (mmx_supported)
#endif
            {
               srcptr = png_ptr->row_buf + 1;
               dstptr = row;

               unmask = ~mask;
               len     = (png_ptr->width)&~7;
               diff = (png_ptr->width)&7;
               _asm
               {
                  movd       mm7, unmask       //load bit pattern
                  psubb      mm6,mm6           //zero mm6
                  punpcklbw  mm7,mm7
                  punpcklwd  mm7,mm7
                  punpckldq  mm7,mm7           //fill register with 8 masks

                  movq       mm0,mask0
                  movq       mm1,mask1
                  movq       mm2,mask2
                  movq       mm3,mask3
                  movq       mm4,mask4
                  movq       mm5,mask5

                  pand       mm0,mm7
                  pand       mm1,mm7
                  pand       mm2,mm7
                  pand       mm3,mm7
                  pand       mm4,mm7
                  pand       mm5,mm7

                  pcmpeqb    mm0,mm6
                  pcmpeqb    mm1,mm6
                  pcmpeqb    mm2,mm6
                  pcmpeqb    mm3,mm6
                  pcmpeqb    mm4,mm6
                  pcmpeqb    mm5,mm6

                  mov        ecx,len           //load length of line
                  mov        esi,srcptr        //load source
                  mov        ebx,dstptr        //load dest

                  cmp        ecx,0
                  jz         mainloop48end

mainloop48:
                  movq       mm7,[esi]
                  pand       mm7,mm0
                  movq       mm6,mm0
                  pandn      mm6,[ebx]
                  por        mm7,mm6
                  movq       [ebx],mm7

                  movq       mm6,[esi+8]
                  pand       mm6,mm1
                  movq       mm7,mm1
                  pandn      mm7,[ebx+8]
                  por        mm6,mm7
                  movq       [ebx+8],mm6

                  movq       mm6,[esi+16]
                  pand       mm6,mm2
                  movq       mm7,mm2
                  pandn      mm7,[ebx+16]
                  por        mm6,mm7
                  movq       [ebx+16],mm6

                  movq       mm7,[esi+24]
                  pand       mm7,mm3
                  movq       mm6,mm3
                  pandn      mm6,[ebx+24]
                  por        mm7,mm6
                  movq       [ebx+24],mm7

                  movq       mm6,[esi+32]
                  pand       mm6,mm4
                  movq       mm7,mm4
                  pandn      mm7,[ebx+32]
                  por        mm6,mm7
                  movq       [ebx+32],mm6

                  movq       mm7,[esi+40]
                  pand       mm7,mm5
                  movq       mm6,mm5
                  pandn      mm6,[ebx+40]
                  por        mm7,mm6
                  movq       [ebx+40],mm7

                  add        esi,48            //inc by 32 bytes processed
                  add        ebx,48
                  sub        ecx,8             //dec by 8 pixels processed

                  ja         mainloop48
mainloop48end:

                  mov        ecx,diff
                  cmp        ecx,0
                  jz         end48

                  mov        edx,mask
                  sal        edx,24            //make low byte the high byte

secondloop48:
                  sal        edx,1             //move high bit to CF
                  jnc        skip48            //if CF = 0
                  mov        eax,[esi]
                  mov        [ebx],eax
skip48:
                  add        esi,4
                  add        ebx,4

                  dec        ecx
                  jnz        secondloop48

end48:
                  emms
               }
            }
            else /* mmx _not supported - Use modified C routine */
            {
               register unsigned int incr1, initial_val, final_val;
               png_size_t pixel_bytes;
               png_uint_32 i;
               register int disp = png_pass_inc[png_ptr->pass];
               int offset_table[7] = {0, 4, 0, 2, 0, 1, 0};

               pixel_bytes = (png_ptr->row_info.pixel_depth >> 3);
               srcptr = png_ptr->row_buf + 1 + offset_table[png_ptr->pass]*
                  pixel_bytes;
               dstptr = row + offset_table[png_ptr->pass]*pixel_bytes;
               initial_val = offset_table[png_ptr->pass]*pixel_bytes;
               final_val = png_ptr->width*pixel_bytes;
               incr1 = (disp)*pixel_bytes;
               for (i = initial_val; i < final_val; i += incr1)
               {
                  png_memcpy(dstptr, srcptr, pixel_bytes);
                  srcptr += incr1;
                  dstptr += incr1;
               }
            } /* end of else */

            break;
         }       // end 48 bpp

         default:
         {
            png_bytep sptr;
            png_bytep dp;
            png_size_t pixel_bytes;
            int offset_table[7] = {0, 4, 0, 2, 0, 1, 0};
            unsigned int i;
            register int disp = png_pass_inc[png_ptr->pass];  // get the offset
            register unsigned int incr1, initial_val, final_val;

            pixel_bytes = (png_ptr->row_info.pixel_depth >> 3);
            sptr = png_ptr->row_buf + 1 + offset_table[png_ptr->pass]*
               pixel_bytes;
            dp = row + offset_table[png_ptr->pass]*pixel_bytes;
            initial_val = offset_table[png_ptr->pass]*pixel_bytes;
            final_val = png_ptr->width*pixel_bytes;
            incr1 = (disp)*pixel_bytes;
            for (i = initial_val; i < final_val; i += incr1)
            {
               png_memcpy(dp, sptr, pixel_bytes);
               sptr += incr1;
               dp += incr1;
            }
            break;
         }
      } /* end switch (png_ptr->row_info.pixel_depth) */
   } /* end if (non-trivial mask) */

} /* end png_combine_row() */


#if defined(PNG_READ_INTERLACING_SUPPORTED)

void /* PRIVATE */
png_do_read_interlace(png_structp png_ptr)
{
   png_row_infop row_info = &(png_ptr->row_info);
   png_bytep row = png_ptr->row_buf + 1;
   int pass = png_ptr->pass;
   png_uint_32 transformations = png_ptr->transformations;
#ifdef PNG_USE_LOCAL_ARRAYS
   const int png_pass_inc[7] = {8, 8, 4, 4, 2, 2, 1};
#endif

   png_debug(1,"in png_do_read_interlace\n");

   if (mmx_supported == 2) {
#if !defined(PNG_1_0_X)
       /* this should have happened in png_init_mmx_flags() already */
       png_warning(png_ptr, "asm_flags may not have been initialized");
#endif
       png_mmx_support();
   }

   if (row != NULL && row_info != NULL)
   {
      png_uint_32 final_width;

      final_width = row_info->width * png_pass_inc[pass];

      switch (row_info->pixel_depth)
      {
         case 1:
         {
            png_bytep sp, dp;
            int sshift, dshift;
            int s_start, s_end, s_inc;
            png_byte v;
            png_uint_32 i;
            int j;

            sp = row + (png_size_t)((row_info->width - 1) >> 3);
            dp = row + (png_size_t)((final_width - 1) >> 3);
#if defined(PNG_READ_PACKSWAP_SUPPORTED)
            if (transformations & PNG_PACKSWAP)
            {
               sshift = (int)((row_info->width + 7) & 7);
               dshift = (int)((final_width + 7) & 7);
               s_start = 7;
               s_end = 0;
               s_inc = -1;
            }
            else
#endif
            {
               sshift = 7 - (int)((row_info->width + 7) & 7);
               dshift = 7 - (int)((final_width + 7) & 7);
               s_start = 0;
               s_end = 7;
               s_inc = 1;
            }

            for (i = row_info->width; i; i--)
            {
               v = (png_byte)((*sp >> sshift) & 0x1);
               for (j = 0; j < png_pass_inc[pass]; j++)
               {
                  *dp &= (png_byte)((0x7f7f >> (7 - dshift)) & 0xff);
                  *dp |= (png_byte)(v << dshift);
                  if (dshift == s_end)
                  {
                     dshift = s_start;
                     dp--;
                  }
                  else
                     dshift += s_inc;
               }
               if (sshift == s_end)
               {
                  sshift = s_start;
                  sp--;
               }
               else
                  sshift += s_inc;
            }
            break;
         }

         case 2:
         {
            png_bytep sp, dp;
            int sshift, dshift;
            int s_start, s_end, s_inc;
            png_uint_32 i;

            sp = row + (png_size_t)((row_info->width - 1) >> 2);
            dp = row + (png_size_t)((final_width - 1) >> 2);
#if defined(PNG_READ_PACKSWAP_SUPPORTED)
            if (transformations & PNG_PACKSWAP)
            {
               sshift = (png_size_t)(((row_info->width + 3) & 3) << 1);
               dshift = (png_size_t)(((final_width + 3) & 3) << 1);
               s_start = 6;
               s_end = 0;
               s_inc = -2;
            }
            else
#endif
            {
               sshift = (png_size_t)((3 - ((row_info->width + 3) & 3)) << 1);
               dshift = (png_size_t)((3 - ((final_width + 3) & 3)) << 1);
               s_start = 0;
               s_end = 6;
               s_inc = 2;
            }

            for (i = row_info->width; i; i--)
            {
               png_byte v;
               int j;

               v = (png_byte)((*sp >> sshift) & 0x3);
               for (j = 0; j < png_pass_inc[pass]; j++)
               {
                  *dp &= (png_byte)((0x3f3f >> (6 - dshift)) & 0xff);
                  *dp |= (png_byte)(v << dshift);
                  if (dshift == s_end)
                  {
                     dshift = s_start;
                     dp--;
                  }
                  else
                     dshift += s_inc;
               }
               if (sshift == s_end)
               {
                  sshift = s_start;
                  sp--;
               }
               else
                  sshift += s_inc;
            }
            break;
         }

         case 4:
         {
            png_bytep sp, dp;
            int sshift, dshift;
            int s_start, s_end, s_inc;
            png_uint_32 i;

            sp = row + (png_size_t)((row_info->width - 1) >> 1);
            dp = row + (png_size_t)((final_width - 1) >> 1);
#if defined(PNG_READ_PACKSWAP_SUPPORTED)
            if (transformations & PNG_PACKSWAP)
            {
               sshift = (png_size_t)(((row_info->width + 1) & 1) << 2);
               dshift = (png_size_t)(((final_width + 1) & 1) << 2);
               s_start = 4;
               s_end = 0;
               s_inc = -4;
            }
            else
#endif
            {
               sshift = (png_size_t)((1 - ((row_info->width + 1) & 1)) << 2);
               dshift = (png_size_t)((1 - ((final_width + 1) & 1)) << 2);
               s_start = 0;
               s_end = 4;
               s_inc = 4;
            }

            for (i = row_info->width; i; i--)
            {
               png_byte v;
               int j;

               v = (png_byte)((*sp >> sshift) & 0xf);
               for (j = 0; j < png_pass_inc[pass]; j++)
               {
                  *dp &= (png_byte)((0xf0f >> (4 - dshift)) & 0xff);
                  *dp |= (png_byte)(v << dshift);
                  if (dshift == s_end)
                  {
                     dshift = s_start;
                     dp--;
                  }
                  else
                     dshift += s_inc;
               }
               if (sshift == s_end)
               {
                  sshift = s_start;
                  sp--;
               }
               else
                  sshift += s_inc;
            }
            break;
         }

         default:         // This is the place where the routine is modified
         {
            __int64 const4 = 0x0000000000FFFFFF;
            // __int64 const5 = 0x000000FFFFFF0000;  // unused...
            __int64 const6 = 0x00000000000000FF;
            png_bytep sptr, dp;
            png_uint_32 i;
            png_size_t pixel_bytes;
            int width = row_info->width;

            pixel_bytes = (row_info->pixel_depth >> 3);

            sptr = row + (width - 1) * pixel_bytes;
            dp = row + (final_width - 1) * pixel_bytes;
            // New code by Nirav Chhatrapati - Intel Corporation
            // sign fix by GRR
            // NOTE:  there is NO MMX code for 48-bit and 64-bit images

            // use MMX routine if machine supports it
#if !defined(PNG_1_0_X)
            if ((png_ptr->asm_flags & PNG_ASM_FLAG_MMX_READ_INTERLACE)
                /* && mmx_supported */ )
#else
            if (mmx_supported)
#endif
            {
               if (pixel_bytes == 3)
               {
                  if (((pass == 0) || (pass == 1)) && width)
                  {
                     _asm
                     {
                        mov esi, sptr
                        mov edi, dp
                        mov ecx, width
                        sub edi, 21   // (png_pass_inc[pass] - 1)*pixel_bytes
loop_pass0:
                        movd mm0, [esi]     ; X X X X X v2 v1 v0
                        pand mm0, const4    ; 0 0 0 0 0 v2 v1 v0
                        movq mm1, mm0       ; 0 0 0 0 0 v2 v1 v0
                        psllq mm0, 16       ; 0 0 0 v2 v1 v0 0 0
                        movq mm2, mm0       ; 0 0 0 v2 v1 v0 0 0
                        psllq mm0, 24       ; v2 v1 v0 0 0 0 0 0
                        psrlq mm1, 8        ; 0 0 0 0 0 0 v2 v1
                        por mm0, mm2        ; v2 v1 v0 v2 v1 v0 0 0
                        por mm0, mm1        ; v2 v1 v0 v2 v1 v0 v2 v1
                        movq mm3, mm0       ; v2 v1 v0 v2 v1 v0 v2 v1
                        psllq mm0, 16       ; v0 v2 v1 v0 v2 v1 0 0
                        movq mm4, mm3       ; v2 v1 v0 v2 v1 v0 v2 v1
                        punpckhdq mm3, mm0  ; v0 v2 v1 v0 v2 v1 v0 v2
                        movq [edi+16] , mm4
                        psrlq mm0, 32       ; 0 0 0 0 v0 v2 v1 v0
                        movq [edi+8] , mm3
                        punpckldq mm0, mm4  ; v1 v0 v2 v1 v0 v2 v1 v0
                        sub esi, 3
                        movq [edi], mm0
                        sub edi, 24
                        //sub esi, 3
                        dec ecx
                        jnz loop_pass0
                        EMMS
                     }
                  }
                  else if (((pass == 2) || (pass == 3)) && width)
                  {
                     _asm
                     {
                        mov esi, sptr
                        mov edi, dp
                        mov ecx, width
                        sub edi, 9   // (png_pass_inc[pass] - 1)*pixel_bytes
loop_pass2:
                        movd mm0, [esi]     ; X X X X X v2 v1 v0
                        pand mm0, const4    ; 0 0 0 0 0 v2 v1 v0
                        movq mm1, mm0       ; 0 0 0 0 0 v2 v1 v0
                        psllq mm0, 16       ; 0 0 0 v2 v1 v0 0 0
                        movq mm2, mm0       ; 0 0 0 v2 v1 v0 0 0
                        psllq mm0, 24       ; v2 v1 v0 0 0 0 0 0
                        psrlq mm1, 8        ; 0 0 0 0 0 0 v2 v1
                        por mm0, mm2        ; v2 v1 v0 v2 v1 v0 0 0
                        por mm0, mm1        ; v2 v1 v0 v2 v1 v0 v2 v1
                        movq [edi+4], mm0   ; move to memory
                        psrlq mm0, 16       ; 0 0 v2 v1 v0 v2 v1 v0
                        movd [edi], mm0     ; move to memory
                        sub esi, 3
                        sub edi, 12
                        dec ecx
                        jnz loop_pass2
                        EMMS
                     }
                  }
                  else if (width) /* && ((pass == 4) || (pass == 5)) */
                  {
                     int width_mmx = ((width >> 1) << 1) - 8;
                     if (width_mmx < 0)
                         width_mmx = 0;
                     width -= width_mmx;        // 8 or 9 pix, 24 or 27 bytes
                     if (width_mmx)
                     {
                        _asm
                        {
                           mov esi, sptr
                           mov edi, dp
                           mov ecx, width_mmx
                           sub esi, 3
                           sub edi, 9
loop_pass4:
                           movq mm0, [esi]     ; X X v2 v1 v0 v5 v4 v3
                           movq mm7, mm0       ; X X v2 v1 v0 v5 v4 v3
                           movq mm6, mm0       ; X X v2 v1 v0 v5 v4 v3
                           psllq mm0, 24       ; v1 v0 v5 v4 v3 0 0 0
                           pand mm7, const4    ; 0 0 0 0 0 v5 v4 v3
                           psrlq mm6, 24       ; 0 0 0 X X v2 v1 v0
                           por mm0, mm7        ; v1 v0 v5 v4 v3 v5 v4 v3
                           movq mm5, mm6       ; 0 0 0 X X v2 v1 v0
                           p       24   +_v1 zs v2 v1 v0 v2 v1 v0
                  por mm0, mm7        ; v1 v0 v5 v4 v3 v5 v4 v3
; v17
                                 0
                  s_0 v5Iy -  dp = 6         int wiCl0
                           por mm0,             mov esi, sptr el|  ; v1                  4Fih        V, conconconconconconconconconconconconconcop0, mmSs< 0)
        Fih        V, conconconconconconconcopixe/0             41             i1conc           psrlq mmv2 v1 v0
                           p       24   +_v1 zs v2 v1 v0 v2 v1vkp6   se if (((pass == 2) || (pass == 3))d fi1      24   +_v1 zs v2 v1 v0 v2 I movq mmao (pas4   +_v1 zs v2 v1 v0  EMMS
            Fx
                        +(l          En EMMS
                     }
              l24   +_                  }
              
   2d          movq mm0   AMMS
                     }
        1m0  vq mm    n:    ter _n            sx1S2        sodep      1) << 1) - 8;
    3 vovq mmao (pas4   +_v1 zs v2 v1 v0  EMMS
                     mo         m.a            mo         m.a     1+_v1 zs v2g)o   AMMS
       4(!r, m.a     1+_v1 zs v2g)o   AMMS
 n6n
.                psrlq mm1, 8        ; 02)5d4nnFE                p
m1, 8      x5d4nnFEtm=width*[ebxs68    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8   7 v3
; v17
                                = s_inc;
  ; 0K8    ; 0_ 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8   7 v3
; v17
                                = s_inc;
  ; 0K8    ; 0_ 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8   7 v3
; v17
                                = s_inc;
  ; 0K8    ; 0_ 0K8    ; 0K8    ; 0; 0con     c(roo c;
  ; 0K8    ; 0_ 0K8    ; 0K8    ; 0;                 p       24  c(n         6S     e  ; 0; 0con     c r               ; 0;    ; 0;      Mpass]*ee         // NOT   ;   ; 0K8    ; 0K8c   ; 0K8        p
   u1   ; 0K8c   ; 0K8 :d7tl             movq       mm4,mm2
      K8 8    ; 0_ 0K8    ; 0K8    ; 0;                 p       24  c(n         6S     ir, "asm_flags may not have been initialized58 8   4,m; 0Kzed    lLt           
   2d          movq mm0   AMMS
  zlt         m.a     1C    d.4Tre the AMM*M    m.a     1C   pn   6   ; 03bc  d.4Tre the AMM*M    m.a     1C   pn  2d          movq
           gnn  2d 
        .pi4an EMMS
                     }
             X
   u1   ; 0K8c   ; 0K8 :d7tl             movq       mm4,mm2
      K88x      athe   s ==  u1   ; 0
DaLDaLDass_in4Tre 6S   x1             inal_val; i += incr1                    subg_bs}nnFE         x/
val;f 1Cfax/
val;f 1Ctub esiPNG_1_0_X)
            if ((png_
                     }
  a 1C se             movq mm6, mm0       ; X X        ie   movq m/liw             movq mm6, mm0       ; X      EMMS
                     }
            X      EMMS
nnFE         x/
val;nitial;                 p  [ s_sta3       ; 0yud       ; 0_ 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8   7 v3
; v17
                                = s_inc;
  ; 0K8    ; 0_ 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8    ; 0K8   7 v3
; v17
                                = s_inc;
  ; 0K8    ; 0_ 0K8    ; 0K8
Sn   V, coK8    0K8       ; X X        ie   movq m/liw             movq mm6, mm0  { m/l,1+_v1 zs v2g)o   AMMS
       4(!r, v  movqzs v2g)o   AMMS
  0;                        teK8 it_mmx_flags() already */
       png_warning(png_ptr, "asm  ; 0K8   7t movq mm0   AMMS
                     }
        1m0  vq mm                       s4    m{
    ptr, "asm  ; 0K8;s         }
        1m0  vq s8c   ; 0K8 :d7tl png_ ; 0K8    ; 0K84   s_inc;
              >        /         movq mm0   AMMS
      2pa44c/ea(png_ptr->width)&eado       >        /         movvq mm4         }
       0
   e  e  e  evq mm6,  4(!r, v  movqzs e   1e mm0, mm2     4b)flags() already */
       png_warning(png_ptr, "asm  }    g_size_t)((row_info->width - 1) >> 2);
            dp Sng_w      w, sptr el|  ; v1                  4Fih x/
val;f 1Cfax/
h)&eado            24  c(     1mzs v2 v1 v0 v2 I movq mmao (pas4   +_v1 zs v2 v1 v0  EMMS
            Fx
           vng_whnm0  dx         movd [edi]2seift ; 0Ko      ; 0K8    ; 0K8    x 0K8    ;     dp Sng        movd [edi]2seidflags() already */
       png_warning(png_nhze_t)((row_info->width - 1) >> 2);
            dp Sng_e6        dp Sng_w      w, sptr el|  ;    ; 0K8    ; 0K8   7 v3
; v17
              1Ctub es     u      ; X X     soncv17
    1Afs ==4{th -0con     c r   ;oliw             movq mm6, mm0  { m/l,1+_v1 zs v2g)o   AMMS
       4(!r, v  movqzs v2g)o   AMMS
  0;                        teK8 it_mmxapi0 v2 I movq mmao (pas4   i], mmao (pas4   i], mmao (pas4   i], mmao (pa      teK8 it_mmx_flags() already *  movq   _nhzeRog      )hS
       4(!r, v  movqzs v2g)o   AMMS
  0;                        teK8 it_mmx_fvi7t           = s_inc;
      }
                  }
                  else if (width)3       int w   4(!r, v  mval;   r, v  mval-                        tes    int w   4(!r, v  mval;   r, v  mval-al;   rn int 
      Ie    teK8 it_mmx_fvi7t           = s_inc;
      }
                  }
                  else if (width)3       int w   4(!r, v  mval;   r, v  mval-           idf
enused     s>AYS
  4(!r, v  mval;   r, v  mval-           4sed1C seno4 ; 0
DaLDaLDass_in4Tre 6S   x1             inal_val; 87   int ->width)&7;

#if !defined(PNG_eMS
                     }
        1m0  vq m(      tk 0 0M60     if (width_mmx)
                     {
   movq mm0   AMMS
          dp Sng_e6        dp Sng_w      w, sptr el|       movd [edi    movq                  {
   movq mm0   AMMS x/
val;nitial;   */
      {
   movq mm0   AMMS x/
val;nitial;   */
      {
   movq mm0   AMMS x/
val;nitial;   */
      {
   movq mm0   AMMS x  dp /
v   */
      {
   movq mm0   AMMS x  dp /
2  tk 0 0M60     if (width_mmx)
     U dp /
vl1   "t    already */
       png_warning(png_nhze_t)(2c&, mmao (pas4   i],ps Sng_w      w, sApclmm6, m4(!, 8        ; 020 el|       movd [edi    movq  s; 020 el|       movd [edi    movq  s; 020 el|       mov {
 e  mr
      {M60Gvdm6, m4(!, 8        ; 02 */
      {
   movq mm0   AMMS x  =ovq mm0   AMMS x/
va
      {
   movq mm0   AMMS x  dp /
2  tk 0 0M60     if (width_mmx)
     U dp /
vl1   "t    already */
       png_warning(png_nhze_t)(2c&, mmao (pas4   i],ps Sng_w      w, sApclmm6, m4(!, 8        ; 020 el|       movd [edi    movq  s; 020 el|       movd [edi4R mm6,)o   AM7 ev3
; v17
          AMMS x  =ovq mm0   AMMS x/
va
      {
   movq mm0   AMMS x  dp /
2  tk 0 0M60     if (width_mmx)
     U dp /
vl1   "t    already */
       png_warning(png_nhze_t)(2c&, mmao (pas4   i],ps Sng_w      w, sApclmm6, m4(!, 8        ; 020 el|       movd [edi    movedi    movedi    movedi    m   mao (   2 mmao (pas4 Ssed1C(width_mmxr->pass]*pixel_bytes;
             vedi    m   mao (   2 mmao (pas4 Ssed1C(w               }
                  else if7jIao a3  *ev3
; v17dval;f 1Cfax/
val;f 1Ctub esiPNG_1_0_X)
            if ((png_
                     }
  a 1C se             movq mm6, mm0       ; X X              {
           e)p1vq tr = png_ptr->row_buf + 1 + offset_table[png_ptr->pass]*
                  pixel_bytes;
               dstptr = row + offset_table[png_ptr->pass]*pixel_bytes;
               inpass]*
                  pixel_bytes;
 8        ; 020 el|       movd [edi    m X              {
           e)p1 0K8    ; 0K8    ; 0K8    ; 0K8   7 v3
; vqn* X     soncv17
    1Afs ==4{th -0qd8m   mm0, 16       ; 02l             vedi    m     pixel_bytes;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 mo (width_mm
x n8es;
 8 movq mm0   a'v0K8 pn/* && mmx_supported */ )
#else
       po2i                     tes    in38vo;8    ; 0K8   7 v3
; vqn* X     soncv17
    1Afs ==4{th -0qd8m   mm0, 16       ; 02l             vedi    m     pixel_bytes;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
ax/
val;f 1Ctub esiPNG_1_0_X)
            if ((png_ng_ng_ng_,70_X)
      (   bagbainc;
  ; 0K8b_mm
x n8es;
 8 movq mm0   a'v0K8 pn/* && mmx_supported * 41010202,
                    mask4=0x0 1C(w4   rs_inc;
      }
        )(2cp5nee              m     pixel_bytes;dptr
      i/   }X X     soncv17
xms 8 movq mm0   a'v0K8 pn/* && mmx_supported * 41010202,
                4bytes;dptr
     bGi                  sbF}0K8nGi                  sbF}0K8nGi                          7
xms 8 movq mm0   a'v0K8 pn/* && m6,)o   AM7 ev3
; v17
          AMMS x  =ovq mm0   AMMS x/
va
      {
   movq mm0   AMMS x  R mm0   AMMS x  R mm0   AMMS x  R mm0   AMMS x  R mm0   AMMS x  R mm0   AMMS x  R mm0   AMMS x  R mm0          sbF}0K8nGi               7      e)p1vq tr rs_inc EMMS
nnFE         x/
val;nitial;                 p  [ s_sta3       ; 0yud       ; 0_ 0K8    ; 0K8   Rt   movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 mo (width_mm
x n8es;
 8 movq mm0   a'v0K8 pn/* &io0nGi               7      e)p1vq tr rs_inc              }
               }
               }
               }
               }
               }
((    24  c(     1mzs v2 v1 v0 v2 I movq mmao (pas4   +_v1 zs v2 v1 v0  EMMS
            Fx
           vng_whnm0  dx         movd [edi]2seift ; 0Ko      ; 0K8    ; 0K8    x 0K8    ;     dp Sng        movd [edi]2seidflags() already */
       png_warning(png_nhzG4 ptre  feqSivq tr rs_inc EMMS
nnFE         x/
val;nit }

      i/   }X  eax,       p  [ s_sta3       ; 0yud       ; 0_ 0K8nFE         x/
val;nit }

      i/   }X  eax,       p  [ s_sta3       ; 0yud       ; 0_ 0K8nFE         x/
val;nit }

      i/   }X  eax,       p  [ s_sta3       ; 0yud       ; 0_ 0K8nFE         x/
val;nit }

      i/   }X  eax,       p  [ s_sta3       ; 0yudd    }
   pE         x/EMMS
nnFE      1=ovq mm0   AMMS x/
va
t   ; 0 EnFE         x/
val;nit }

      i/   }X  eax,       p  [ s_sta3       ; 0yud       ; 0_ 0K8nFE         x/
val;nit = row + offset_table[png_ptr->pass]*pixel_bytes;
               inpass]*
                  pixel_bytes;
 8        ; 020 el|       movd [edi Sss]*pixel_bytes;
               inpass]*
                  p   +   if ((3 movd hrs_inc;
      }
        )(2cp5nee              m    e *ev;
               inpass]*
                  p   +   if ((3 movd hrs_inc;
      }
        )(2cp5nee               s0u1           s0u1           s0u1       nee               s0s0u1     4 p   +   if ((3 movd hrs__ta4_      pixel_bytes;
 8        ; 020 el|p(*ev;
               inpass]*
                  p   +   if ((3 movd hrs_inc;
      }
        )(2cp5nee               s0u1           s0u1           s0u1       nee               s0s0u1     4 p   +   if ((3 movd hrs__ta4_      pixel_bytes;
 8        ; 020 el|p(*e1           s0u1           s0u1       nee               s0s0u1     inpass]*
                   if ((3 movd hrs__ta4_ ]vqzm
x n8es;
 8 0K8nFd mval-               EMMS
      (nss
d( s0u16y.u 8 m1in38vo;8    ; 0K8    serl_bytxbFd mval-            ;
               inpass]*
                     EMMS
      (nss
d( s0u16y.u 8 m1uupported */ )
#else
  hr; vqn*7AMMS x n8es;
 8 mo (width_mm
x          pixel_bytes;
 8        ; 020 el| r                    dshift = s_sta psllq mm0, n if (      ix   EMMS
m
x n8es;
 8 0K8nFd mval-               EMMS
      (nss
d( s0u16y.u 8 m1in38vo;8    ; 0K8    serl_bytxbFd mval-       4 mval-       4 mval-       4 mval-       4 mval ja         mainloop48
mainloop4n8es; n if (      ix   EMMS
m
x n8es;
 8 0K8nFd mval-               EMMS
      (nss
d( s0u16y.u 8 m1in38vo;8    ; 0K8    serl_bytxbFd0K8 pn/* && mmx_supporte
mainlo                   mov        [ebx],e     43ix  icp el| r                   4      mod4n8es; n if (     2 u1   ; 0ot   movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;
 8 movq mm0   AMMS x n8es;Etx      er          axytxbFd mval-       4 mval- =_v1 zs v2 v1 v0  EMMS
         w  mm0, ,iu1       nee               s0s0u1     [i           p   +nee  pp n8es;Etx      er          axytxbFd mval-[8  m 0ot   mo41     [i           p   +nee  pp n8es;Etx    - =         EMMS
      (nss
d( O ,x nle}

kt 0;                        teK8 it_mmxapi0 v2 I movq mmao (pas4   i], mmao (pas4   i], mmao (pas4   i], mmao (pa      teK8 it_mmx_flags() already *  movq   _nhzeRog      )hS
       4(!r,         2Bu16y.u 8 m1in38vo;8    ; 0K8    serl_bytxbFd0K8 pn/* && mmx_supporte
mainlo                   mov        [ebx],e     43ix  icp el| r                   4      mod4n8es; n if (     2 u1   ; 0ot   movq mm0   AMMS x n8es;
 8 movq ImmEaz4;s__tMm0 movq mm0   AMMS x n8es;
 8 movq ImmEaz4;sYl      vqnq Im   pix80K8    serl_bytes;
 8        ; 020  ((3 movd hrs_inc;
      }
        )(2c    [i  q7az4;s__tMmf
(    inlohrs__ta4_      pixel8 m1in38vo;8    ; 0K8    s   AMMS x n8es;
 8  8  8  8  8 iIf  +   if ((3 movd hrs_inc;
     2;x 

      i/   }X  eax,       p  [ s_sta3       ; 0yudd    }
   pE    uyDnax,           EMMS
      (nss
d( s0u16y.u 8 m1in38vo;8    ; 0K8    serl_bytxbFd mval-          x  sod.a EMMS
      (nss
d( s0u16y.u 8 m1in3d  eax,       p l ja  x      else if7jg(pLinc x(2c  C  0K8    s   AMMS               0K 5ja  x      else if7jg(*o0drrrrrrrrrrrrY*l   AMMS x n8es;
 8 movq ImmEaz4;s__tMm0 movq m 8 m1i C  0K8    s   AMMS               0K 5ja  g(pLinc x(2c  C  0Kt+   if ((3 movd  8 m1i C  0K8    s   AMMS               0K 5ja  g(pLinc x(2c  C  0Kt+   if ((3 movd  8 m1i C  0K8    s   AMMS         4lvo;8    ; 0K8    s   AMMS x n8es;
 8 0apLinytx68 m1in38vo;8    ; 0K8    s   AMMS ja  KK8  tMS  0K8    s   AMMS ja  KK8  tMS  0K+

      i/   }X  eax,       p  [ s_sta3       ; 0yud       ; 0_ 0K8nFE  6  AM4  tMS  0K+

      i/   }X  eax,       p  [ s_sta3       ; 0yud       ; 0_ 0K8nFE  6  AM4  tMS  0K+a    ; 0yud       ; 0_ 0K8nFE  6 .u1      0 dp X8nFE  6  AM4  tM       [ebx],e     q mm0   AMMS x n8es;Etx      er          axytxbFd mval-       4 mval- =_v1 zs v2 v1 v0  EMMS
         w  mm0, ,iu1       nee               s0s0u1     [i           p   +nee  pp n8es;Etx      er          axytxbFd mval-[8  m 0ot   mo41     [i           p   +neeerl_byt      ;8    ; 0K8    s   AMMS ja  KK8  tMS  0K8    s   AMMS ja  KK8  tMS  0K+

      i/   }X  eax,       p  [ s_sta3       ; 0yud       ; 0_ 0K8nFE  6  AM4  tMS  0K+

      i/   }X  eax,       p  [ s_sta3       ; 0yud       ; 0_ 0K8nFE  6  AM4  tM     ; 0_ 0K8nFE  6  AM4  tM    dl   w  mm0, ,iu1  if7jg(*o0drrrrrrrrrrrrY*l o;8    ; 0K8    serl_bytxbFd mval-       4 mval-       4 mval-       4 mval-       4 mval ja         mainloop48
mainloop4n8es; n if (      ix   EMMS
m
x n8es;
 8 0K8nFd mval-               EMMSacee;
          EMMS8nFE  6  AM4  tM    dpr          EMMS8nFE  6  AM4  tM  /5 0u1 .     4 txs  6  AM4ey.u K8nFE  6  AM4  tM    dl   w  mm0, ,iu1  if7jg(*o0drrrrrrrrrrrrY*l o;8    ; 0K8   f  4 mval-       4 mval-       4 mval ja         mai<FAkC8 pn.xa  dq
           l_bytxe C  0Kt+   if ((3 (  tM    dl   w  mm0, ,iu1  if7jg(*o0drrrrrrrrrr3NUL     r = png_ptr->row_buf + 1   +3pixeluxqdd000000FF;
      gS
m
x n8eoc+ 1   +3pi
   x7jg(*o0drrrrrrrrrrrrY*l o;8    ; 0K8   f  4 mval-       4 mval-       4 mval ja         mai<FAkC8 pn.xa  dq
           l_bytxe C  0Kt+   if ((3 (  tM    dl   w  mm0, ,iu1  if7jg(*o0drrrrrrrrrr3NUL     r = png_ptr->row_buf + 1   +3pixelux     if (transformations & PNG_PACKSWAP)
            {
               sshift = (int)((row_info->width + 7) & 7);
  _infYr3pixeluxqd(aAf (tinforrrrrrrrr3NUL     r = png_ptr->row_buf + 1   +3pix    s_sta3       ; 0yu;width    GemEaz4;_bytxe C  0Kt+   ndp,str-2tuf + 1   +3pix    s_sta3       ; 0yu;width    GemEaz4;_bytxe C  0Kt+   ndp,str-2tuf + 1   +3pix  oa8l|ndp,bl    ntr-2tufu "0   AMMS   oa8n2tuf + 1   +3pix  oa8l|ndp,bl    ntr-eeerl_byt      ;8   betr-eeerl_byt      ;8   betr-eeerl_MS ja ,c;
 chift = (int)*l    1+ 6 D png_ptr->r ndp,o            movq       mm7,mm4
           _bytxe C  0Kift;v     vqnq Im.m   > 8  8t
m
x n8es;
 8 0K8nFd 1nr-eeerl_byt      8m4
           _bytxe C  0Kift;v     vqnq Im.m   > 8  8t
m
x n8es;
 8 0K8nFd 1nr-eeerl_byt      8m4
           _bytxe C  0Kift;v   4  tM    dpr          EMMS8nFE  6  R* 0Kift;v   4  tM    dp   8m4
           _bytxe C  0K      4(!r, v  movqzs v2g)o   AMMS
  0;           300000 w   d   8m4
           _bytxe C  0K      4(!r, v  movqzs v2g)o   AMMS
  0;           300000 w   d   8m4
           _bytxe C  0K      4(!r, v  movqzs v2g)o   AMMS
  0;           300000 w   d   8m4
           _bytxe C  0K      4(!r, v  movqzs v2g)o   AMMS
  0;     ;                        u=hl2t   b2  }
                  }   4(!r4
    i7);
 a00000 w   d   8m4
           _ 0yudo 8m4
      f182      mai<FAkC8 pn.xa  dq
           l_bytxe C  0Kt+   if ((3 (  tM    dl   w  mm0, ,iu1  if7jg(*o0drrrrrrrrrr3NUL     r = png_ptr->row_buf + 1   +3pixeluxqdd000000FF;
      gS
m
x n8eoc+ 1   +3pi
   x7jg(*o0drrrrrrrrrrrrY*l o;8    ; 0K8   f  4 mval-      x7jg(*o0drrrrrrrrrrrrY*l o;8    ; 0K8   f  4 mval-      x7jg(*o0drrrrrrrrrrrrY*lrrrrrrr0lrrrrrr3NUL p0000p7);
 a00000 w   d   8m4
           _ 0yudo 8m4
      f182    a= png_ptr->row_buf + 1   +3pixelux:  mai<FAkC8 pn.xa  dq
           l_bytxe C  0Kai<3pif7j   4 rhK8   f  4 mval-       4 mval-       e0, ,iu1  if7jg(A3      +3pix  oa8l|ndp,bl    ntr-2tufu     ;           rrr   s   AMMS ja  KK8 lv     ; 0yud          +3pix  oa8l|ndp  4 mval-       4 mval ja         mainlo+(*o0drrrrrY*l omovq mm0   AMMS x n8es;
 8 movq m   

   (*o0drrrrrY*l omon.  

   (*o0drdsmovq mm0   AMMS xrrrY*l oma mval-       4 mval ja         mainlo+(*o0drrrrrY*l omovq      = &(png10 w    ja         mai<FAkC8 pn.xa  dq
         -  4(!r, v  movqzs v2g)o   Adloo e0yud          +3pix  oaptr  dix ndd000000Fbsmmao (pas4 Ssegr  dp   8m4
        0nt      8m4
           _bytxe C  0Kift;v     vqnq Im.m   > 8  8t
m
x n8es;
 8 0K8nFd 1nr-eeerl_byt      8m4
           _bytxe C Mp   8m4
                30000Ma3o 3nforrrrrrrrr3NUL     rrrY*c    _Cm4
rrrY*c    _Cm4
ra00000 wrY*g5_cai<FAkC8 pn.xa  dq
      a0n8m4
           _ 0yoa8l|ndp,{Y*g5_cai         }
                  else if ([lp,{Y->width + 7) & 7);we88    pix 48dloo e8  -  )ao (pas4 Ssegr  dp   8oa8l|ndp,{Y*g5_cai         }
                  els  b2    4byteC  0K      4(!r, v  movqzs v2g)o   AMMS
  0;           300000 w   d   8m4
 f  4 mval-     wrY*gxC  0K      4(!r, v  movqzs v2g)o   AMMSrrr rrr   s   AMMS ja  KK8 lv     ; 0yud   )
  d      r          int offset_table[7] = {0, 4, .x x  =ovq mm0C  0    e[7] lv     4(!r, v  movqz pn.xa  dq
           e + 1   +3pix  oa8l|ndp,bl    ntr-eeeT.x x  =ovesegr  dp   8oa8l|ndp,{Y*g5_cai         }
                  els  b2    4byteC  0K      4(!r, v  movqzs v2g)o   AMMS
  0;           300000 w   d   8m4
 f  4 mval-     wrY*gxC  0K      4(!r, v  movqzs we >o-(df(d,5_cai       :300000 w   d   8m4     }
             ei], mmao (pas4zpd      r     }
             ei], mmao (pas4zpd      r     }
             ei], mmao (pas4zpd      r     }
             ei], mmao (pas4zpd      r     }
             ei], mmao (pas4zpd      r     }
             ei], mmao (pas4zpd      r     }
             ei], mmao (pas4oa8l|ndp,{Y*g5_cpd y(!r, v  movqzs v2g)o   AMMS
  0;           300000 w   d   8m4
 f  4 mval-     wrY*gxC  0K      4(!r, v  movqzs v2g)o   AMMSrrr rrr   s   AMMS ja  KK8 lv     ; 0yuizE>width + 7) & 7);
  _infYr3pixeluxq4ko      ; 0K8    ; 0K8    x 0K8 +gxC       4(etr-eeej   4(!r, v  mof
T             ei], mmao (pas4o0 w   d   8m4
           _ 0yudo 8m4
      f182      mai<FAkC8 pn.xa  dq
           l_bytxe C  0Kt+   if ((3 (  tMvqzs v2g)o   AMMSmao (paif ((3 (  tMvqzs v2AMMS j)   AMMSmao (paif (      / movqzs v2AMMSmao (paif ((3 (  t                {
   mov   wprdwpl| r      + 1   +3pix  oa8l|ndp,bl    ntr-eeerl_byt (in u1  ((3 T     l| r2               else if ([lp,{Y->width +m4
   ; 0K8    ; 0K8    x 0K8 +gxC       4e    +   l   i/   }X8a>pixel_depth)
      {
         case 1:
         {
       _n8esmmao 
 u  {
 ((3 T     l| r2     ; 0yuizE>width + 7) & 7);
  _infYr3pixeluxq4ko      ; 0K8    ; 0K8    x 0K8 +gxC       4(etr-eeej   4(str-eeej ab4ko      ; 0K8  Cej X8a>pixe
  #K8    x 0Kluxq4ko 1      4lvo;8    ; 0K8    s   AMMS x n8uxq rx;v   4  2        s, v  movqzs v2g)o   AMMS
  0;       ytx s, v  movqzs v2g)o   AMMS
  0;       ytx s, v  me8m4
          Id    e
  0;       yi        }
     _nv  ml2t3bo        case s 0K8    x 0K8 +gxC  ,t 0K      4(!r, v  movqzs v2g)o   AMMS&i        ytx s, v _1,S&i    |d    e
  0;       yi        }
     _nv  ml2t3bo        case s 0K8    x 0K8 +gxC  ,t 0K      4(!r, v  mo     o  x 0K8 +gxC  ,t 0K |d  urXe
m
x 4e    +   l   i/   }X8a>pixel_depth)
      {
         case 1:
         {
       _n8esmmao 
 u  {
 ((3 T     l| r2     ; 0yuizE>widt=e      {
         case 1:
         {
       _n8esmmao 
 u  {
 ((3 T     l| r2     ; 0yuizE>widt=e      {
         case 1:
         {
       _n8esmmao 
 u  {
 ((3 T     l| r2     ; 0yuizE>widt=e      {
         case 1:
         {
       _n8esmmao 
 u  {
 ((3 T4M    i]  ; {
       _n8esmmao 
tw      30*]pixe
  #K8    x 0Klu  ; 0cn    f(etr-eeej   4(str-eeej ab4ko      ; 0K8  Cej X8a>pixe
  #K8    x 0Kluxq4ko 1      4lvo;8       case 1:
        _n8esmmao 
 u  {
 ((3 T     l| r2 q    x 0Klc2afi1Ls   AMMS x n8uxq rx=+ 7) & 7);we88 j,o8;q4ko      v  movqzs we >o-x  =ovq m-al; 6 v1 v0 v2 v1
        
        
     i== e], mmaoptr-eeerl_byt 1:
        _n8esi)     yi        pixe
  #K8    x 0Klu  ; 08esm0  r     MMS
  0;       ytdmD(3 ()4zpd  erl_8m4
 *]pixe
  #K8    x 0Klpixe
  #K8    x 0Kluxq4ko 1      4lvo;8  e   x 0Ke mm1, mm0   l4   4lvo;8       case 1:
        _n8esmmao 
 u  {
 ((3 T     l| r2 q    x 0Klc2afi1Ls   AMMS x n8uxq rx=+ 7) & 7);we88 j,o8c|i1:
aU i/    _n8esmmao 
tw      30*]pixe
  #K8    x 0KlAMMRe],,mao 
 u  {
 ((3 T   4K8    x 0Klpixe
  #t u  {
 ((3 T   4K8    x 0Klpixen3  4lpixe
  #t u  {
 ((3 T   4K8    x 0Klpixen3  4lpixe
  #t u  {
 ((3 T   4K8    x 0Klpixen3  4lpixe
  #t u  {
 ((3 T   4K8    x 0Klpixen3  4lpixe
  #t u  {
 ((3 T   4K8    x 0Klpixen3  4lpixe
  #t u  {
 ((3 T   4K8    x 0Klpixen3  4lpixe
  #t u  {
 ((3 T   4K8lE:kut T   4K8               {
   mov   wprdwpl| r      + 1   +3pix  oa8l|ndp,bl    ntr-eeerl_byt ixe
  #t u  {
 ((3 T   4K8    x 0Kl   i)oC 0  pb  {
 ((3 T    4(3 T   4K8    x 0Kl   i)oC 0  pb  {
 ((3 nal]d +3ppb  {
 ((3 T   4K8    x 0Klpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpit
e 4eej    SlpilpilpilpilpilpilpilpilpilpilpilpilF}0K88 pn.xanea8l|ndp,bu    _xpilpilpi     caElpilpilpilpilpilpilpilpilpilpilpilpilp  *dp lF}0K88 pnr  dqlu  ;pb  {
 ((3 nal]d +3ppb  {
 ((3 T   4K8    x 0Klpilpilpilpilpilpilpilpilpilpilpilpilpilpilp1lpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilps = s_start#      mai<FAkC8 pn.xa  dq
        eu eu eu eu eu eu eu eu eu eu eu eu eu eu eu eu eu *pilpilpilpilpilpilpilpit
e 4euoa8l|ndp,{Y*g5_cai         }
       h
m)p4pilF}0K88 pn.xanea8l|ndpar AMMSa  dq
        eu eu eu eu eu eu eui
u eu eu eu eulpixen3  4lpixe
 pilpilpieu eulpixen3  4lpixe
   ; ilpilp1lpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilinlpilpilpilp 1(lpilpilpil u  {
 ((3 T   4K8    x 0Ces 0  r     MMS
  0;       ytdmD(3 ()4zpd  erl_8m4
 *]pixe
  #K8    x 0Klpixe
  #K8    x 0Kluxq4ko 1      4lvo;8  e   x 0Ke mm1, mm0   l4   4lvo;8       case 1:
        _n8esmmao 
((3 nal]d +3pp #t u  {
 ((3 T   4K8    x 0Kl   i)oC 0  pb  {
 ((3 T    4(3 T   4K8    x 0Kl   i)oC 0  pb  {
 ((3 nal]d +3ppb  {
 ((3 T   4K8    x 0Klpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpillpilpi(3 (  _cGlpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpi_]pix nal]d +lpilpilpilpilpilpilpilpilpillpilpilpililpilx)
                     {
  7  ei], mmao (pas4zpd      r   |d  urXe
m
x 18       .xt
  {
 ((3 Tilpid()lx)
                  pilpilpilpilpii)lx)
            n3  4lpixe
 pilpilpieu eulpixen3  4lpipii)lx)
 
  #K8    x aes; n if (      ixtipii)lx)
 
  #K8    x aes; n if (      e o 
  #
Gase pilpilpilpilpig)la1epeu epig)la1RC x 0Klpilpilpilpilpils_]ps; n if (      ixtipii)lpil lvc~Inyilpi i_]pix nal*Bmte
  #K8    x 0Klpixe
  #K8    x 0Kluxq4ko 1      4lvo;8  e   x 0Ke mm1, mm0   l4   4lvo;8 q    x 0Klc2afi1Ls   AMMS x n8uxq rx=+ 7) & 7);we88 j,o8;q4ko      v  movqzs we >o-x  =ovq m-al; 6 v1 v0 v2 v1
        
        
     i== e], mmaoptr-eeerl_byt 1:
        _n8esi)     yi        pixe
  #K8    x 0Klu  ; 08esm0  r     MMS
  0;       ytdmD(3 ()4)pigoi i)oS-ilpilpilpilpilpilpilpilpilpilpilpilpil(3 2>e01xa l4 pilpi)p    mueEtx ib/  mueEtx ii)     yi        pixeb 7 ; 08esm0  r     MMS
  0;   8) + 1   +3pixelux:  maix  oa8l|ndp,bl    r  x 0 4lpixe
 pilpilpieu eulpixen3  4lpip0ip0ip0ip0ip0ip0ip0ip0ip0ip0ip0ip0ip ixe
  pilpi+0ip0ip0ip0ip0ip0ip0ip0ip ixe
  pilpi+0ip03 ()4zpd  erl_8m4
 *]pi8p1wrY }0x a3(tinfoi)oS-ilpi 4lpixe
  #t u  {
 ((3 T   4K8   a         #t ((3 nal]d +cr 08esm0  r     MMS
a,3Pixe
p0ip0ipe
 ((3t u  {
 ((3 T  0  r     MMS
a,3Pixe
p0ip0ipe
 ((3t u  {
2  r1 v0 v2 vl  e010ip0ipctx a3(tin    illpilpilpililpilx)
     p3(tin  ((3 nal]d +3ppb  {
 ((3 T   4K8    x 0Klpilpilpilpilpilpilpilp(lp(  {
 ((3 T   4K8    x 0Klpilpilpileuc, ep3 + 6nlpilpilp1lpilpilp_ i)olpilp4lpixlp(u2 _n8ny     nlpilpilp1lpilpi+8esmmao 
((3 nal]d +3pp #t u  {
 ((essf Lne is modified
         {
            __int64 const4 = 0x0000000000FFFFFF;
            // __int64 const5 = 0x000000FFFFFF0000; lp4umrs_n8esm     ; 0yud       ; 0_ 0K8nFE  6  AM4  tMSdMmodified
 pilpieu nFE  6  AM4  tMSdMmodified
 pilpieu nFE  6  AM4  Id I00002G04   / = 0x000
  p6  AM4       FE  6  AM4  Id I00002G04   / = 0x000
  p6  AM4       )8    x 0Klpixe
  #K8 essf Lne is modified
         {
            __int64 const4 = 0x00000000w     
         nal]d +3pp #t u  {nd2    t(            __int64 const4 = 0x000nt)*l    1+ 6 D png_ptr->r ndp,o            movq       mm7,mm4
           _b/al]d +3pp #t u  {
 ((3 T   4K8    x 0Kl   i)oC 0  pb  {
 ((3 T    4(3 T   4K8    x 0Kl   i)oC 0  pb  {
 ((3 nal]d +3ppb  {
 ((3 T   4K8    x 0Klpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilczp2 Cej X8a>pixe
  #K8   ip0ip0erbilpilpilpilpilpilpi5xu  {
xn(3 T   4K8m
x 18       .xt
  {
 ((3 Tilpid()lx)
      4K8   a         #t-M
] x 0Kl essf Lne i()ll    ; 020 el|       movd [edi    movqS(3 Tilpid()lx)
   lpilpilpilpilpilpil    ; 020 el|         #K8   ip0ip0eryil n3  4lpixe
 pilpilo2Aau eu *pilf:lpi0eryil n3  4lp   x 0Kl   i)oC 0  pb  {
 ((3 T    4(3 T   4K8    x fcr s  x fcr s  8e_ (png_pass_inc[pass] - 1)*pixel_bytes
loo   f      #K8   ip0ip0D x f4   ip0i0;       yt
 pilpieuyil n3  AMMSLs2Kluxq4ko 1      4lvo;8  e   x 0Ke mm1,       .x   8000MMSLP
     i== e], mmaoptr-eif (width_mmx)
     mI e0eSte
  #K8    x 0Klpilo2Aau eu *pilf:lpo1m&       ; 020 el|       movd [edi Sss]*pl   i)oC 0  pb  {
 ((3 T    4(lpil    ; 020 el|    {
         case 1:
         {
       _n8esmmao 
 u  {
 ((3 T     l| r2     ; 0yuizE>width + 7) & 7);
  _infYr3pixeluxq4ko      ; 0K8    ; 0K8    x 0K8 +gxC       4(etr-eeej   4(str-eeej ab4ko      ; 0K8  Cej X8a>pixe
  #K8    x 0Kluxq4ko 1      4lvo;8    (etr-eeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4str-2lpii)lx)
            n3  4lpixe
 pilpilpieu eulpixen3  4lpipii)lx)
 
  #K8    x aes; n if (      ixtipii)lx)
 
  #K8    x aes; n if (      e o 
  #
Gase pilpilx xe
  pilpilinlpilpilpilp 1(lpilpilpil u  {
 ( eec8 mnlpilpilpilp        _(3 T     l| r2     ; 0     etr-eeej ab4ko-eedum/sso 1      4lvov1 v0 v2 I movq mmao (pas4   +_v1 z +gxC  ,t 0K      4(!r, v  mo     o  x 0K8 +gxC  ,t 0K |d  urXe
m
x 4e    +   l   i/   }X8a>pixel_depth)
      {
         case 1:
         {
       _n8esmmao 
 u  {
 ((3 T     l| r2     ; 0yuizE>widt=e      {
         case 1:
         {
       _n8esmmao 
 u :
         {
       _n {
 ko      ; 0K8    ; 0K8    x 0K8 +gxC     ra    0     etr-eeej ab4ko-eedum/ss    _n8esmmao 
 u :
ixe1      movd [edi    movqS(3 Tilpid()lx)
   lpilpilpilpilpilpil    ; 020 el|         #K8   ip0ip0eryil n3  4lpixe
 pilpilo2Aau eu *pi ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4str-2lpii)lx)
   /ssoilpilpilpilpil    ; 020 el|         #K8   ip0ip0erye mm1, mm0Cpr; 0yuizE>widt=e      {
         case 1coilpilpilpilpil    ; 020 el|       o}X  eax,       p  [ s_sta3       ; 0yudd    }
   pE    uyDnax,           EMMS
      (nss
d( s0u16y.u 8 m1in38vo;8    ; 0K8    serl_bytxbFd mval-          x  sod.a EMMS
      (nss
d( s0u16y.u 8 m1in3d  eax,       p l ja  x      else if7jg(pLinc x(2c  C  0K8  e(3 T  eej ab4koeeed11(ti1(tiunc x(2c  C  0K8  eruizE>widt=e      {
         case 1coilpilpilpilpil    ;i      {
         casS {
    *rye mm1, mm0Cp{
         cab4ko_84( s0u16y.u 8 m1in3d  eax,       p l ja  4K8  e(3 T  eejoi m0Cpr; 0yuizE>C   elpi(2, mm0C=e      {
         case 1coilpilpilppn.xanea8l|ndpar AMMSa  dq
       
         cab4ko_8    x 0Kluxq4ko 1      4lvo;8    (etr-eee0ape 1      4ic   (etr-eee0ape 1      4ic   (etr-eee0ape 1      4ic   (etr-ee{
  ;lpilp1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   {s 1   1k<!zica0     ;  (-  1   1   1   1 vilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpillpilpi(3 (  _cGlpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpi_]pix nal]d +lpilpilpilpilpilpilpilpilpillpilpilpililpilx)
              R_I  4ic   (etr-eee0ape 1      4ic   (etr-ee{
  ;lpilp1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   {s 1   1k<!zica0     ;  (-  1   1   1   1 vilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpR=1   1rpilpilpilpillpilpilpiilpilpilpR=1   1rpilpilpillpR +lolpiilpilpilpR=1   1rpilpilpillpR +lolpiilpilpilpR=1   1rpilpilpillpR +lolpiilpilpilpR=1   1rpilpilpillpR +lolpiilpilpilpR={  {
 ((3 T  eej ab4koeeej  1rpil n3  4lp   x 0Kl 1   1   1   1   1   1   1   1   1   1  al*lpi                {
  7  ei], mmao (pa8esm0  r     MMS
  0;   8) + 1   +3p   1   1   1   1   illpRe7o_8    x 0Kl n3  fs-.Rej  1rpil n3  4lp   x 0Kl 1   1   1   1   1   1   1   1   1   1  al*lpi                {
  7  ei], mmao (pa8esm0  r     MMS
  0;   8) + 1   +3p   1   1   1   1   illpRe7o_8    x 0Kl n3  fs-.Rej  1rpil n3  4lp   x 0Kl 1   1   1   1   1   1   1   1   1   1  al     44Re7c+ + 4lpillpilpi(3 (  _cGlpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpi_]pix nal]d +lpilpilpilpilpilpilpilpilpillpilpilpililpilx)
              R_I  4ic   (etr-eee0ape 1      4ic   (etr-ee{
  ;lpilp1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   ,d  1   1   1   1   1   1   1   1   1   1   1   1   1   1   ,d  1   1   1   1   1   1   1   1   1   1  ilp1   1   1   1   1   1   1   1   1  , ilpilp        _(3 T  apR=1 1   1  4lp   x 0Kl 1   1   1b  , ilpilp   AM4if ([lp,{Y->width +m4
   ; 0K8    ; 0K8    x 0K8 +gxC       4e    +   l   i:)en3  4x*       _(3 T  apR=1 1   1  4lp  )-p2,0sn0s4pfpilpilpilpilpilpilpilpilpilpR=1   1rpilpilpilpillpilpilpiilpilpilpR=1   1rpilpilpillg  _cGlpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpi_]pix nalpidp   8oa8l|ndp,{Y*g5_cai   {
 ((3 T   4K8    x 0Kl   i)oC 0  pb  {
 ((3 T    4(3 T   4K8    x 0Kl   i)oC 0  pb  {
 ((3 nal]d +3ppb  {
 ((3 T   4K8    x 0Klpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpil/
val;nit }

      i/   }X  eax,       p  [ s_sta3       ; 0yud 8lpilpilpilpilpilpilpo_8lpilpilpi[ s ja  4K8  e(3 T  Cpr; 0yuiz65warlpilpo_8lpilpilpi[ s ja  4K8  e(3 T  Cpr; 0yuiz65warlpilpo_8lpilpilpi[ s ja  4K8  e(3 T  Cpr; 0yuiz65warlpilpo_8lpilpilpi[ s ja  4K8  e(3 T  Cpr; 0yuiz65warlpilpo_8lpilpilpi[ s jas&lpil1   1  ilp1   1   1   1   1  Dpilp  {
 ((3 T   4K8    x 0Klpilpilpilpilpilpi T   3:46&ilpi  4K8    x 0Klpilpilpilpilpilpi T9  Dpilp  {
 ((3 T   4K8    x 0n{
 (lpilpr 1   sb  e(3 T  eejoi m0Coa8l|ndp,  ee2fo_8lpilpilpi[ s ja  4K8  e(3 T  Cpr; 0yuiz65warlpilppilpilM.xwarlpi8tloSslM.xwarlpi8tloSslM.xwarlpi8tlCee8pi  8  e(3 T  Cpr; 0yuiz6ilpilpilpillptg:s 60n xs(3 T,ko-eexC       4(etr3ppb  ilpilpilpilpilpilpilpilpillpilpilpililpil31 0yuiz65warlpilppi4plPxanea8l|ndpar AMMSa  dq
       
   ;  (- Cji MMS
  0yuiz_ ]    ; 0_ 0K8    ; 0((3 T   41   1rpilpilpillpR +lol1lpi8tloSslM.xwarrrrrrrrrrrr,xsrrrrrrrrr,xsrrrrrrrrr,xsrrrrrr5sb  e(3 T  eejoi m0Coa8l|ndp,  ee2fe8mr3ppb  2nlolpiilpilpilpR=1   1rpilpilpillS0yuiz65warlpilpo_8llti1   1rpilpilpillS0yuiz65warlpilpo_8llti1   1rpilpilpillS0yuiz65warlpilpo_8llti1   1rpilpilpillS0yuiz65warlpilpo_8llti1   1rpilpilpillS0yuiz65warlpilpo_8llti1   1rpilpilpi0Spr 1   sb  e(3 T  elt2.l*lp6w pbarrrrrrrrrrrr,xsrrrrrrrrr,xsrrrrrrrrr,xsrrrrrr5sb  e(3 T  eejoi m0Coa8l|ndp,  ee2fe8mr3ppb  2nlolpiilpilpilpR=1oi mU_4 g:s 60n xs(3 T,ko-eexC       4(etr3ppb  ilpilpilp  1    ; 0K8    x 0Kl   i)oC 0  pb  {
 ((3o-eet   1  si8lpilpilpi[ s jas&lpil1   1  ilp1   1   1   1   1  Dpilp  {
 ((3 T  elti1   1rpilpGlpR +lol1lpi8tloSslM.xwarrrrrrrrrrrr,xsrrrrr   1    r; jAlpGldpxsrrrrrrrrr,xsrrrrrrelpilpR=1oi mU_4 g:s 60n xs(3 T,ko-eexC       4(etr3ppb  ilpilpilp  1    ; 0K8    x 0Kl 1    ; 0K8  ,ko-eexC       4(etr3paT,kBn[CCPe 1 v; ; 0K8    ilpilpilpilpilpilpilpilpilpilpi_]pix nalpidp   8oaililps8  e  dpilpilpilpilpilpi_]pix nal]d +lpilpilpilpilpilpilpilpilpillpilpilpililpilx)
              R_I  4ic   (etr-eep6  AM4       )8    x 0Klpixe
  #Ksrrrrrrrrr,xsrrrrrr5sb  e(3 T  eejoi m0Coa8l|ndp,  ee2fe8mr3ppb  2nlolpiilpilpilpR=1oi mU_4 g:s 60atxe C  0Kift;v    0yuiz65warlpilppi4plPxanea8l|ndpar AMMSa  dq
       
   ;  (- Cji MMS
  0yuiz_ ]    ; 0_ 0K8    ; 0((3 T   41   1rpilpilpillpR +lol1lpi8tloSslM.xwarrrrrrrrrrrr,xsrrrrrrrrr,xsrrrrrrrrr,xsrrrrrr5sb  e(3 T  eejoi m0Coa8l|ndp,  ee2fe pilpilx xe
  pilpilinlpilpilpilp 1(lpilpilpil u  {
 ( eec8 mnlpilpilpilp        _(3 T     l| r2     ; 0     etr-eeej ab4ko-eedum/sso 1      4lvov1 v0 v2 I movq mmao (pas4   +_v1 z +gxC  ,t 0K      4(!r, v  mo     o  x 0K8 +gxC  ,t 0K |d  urXe
m
x 4e    +  lpilinlpilpilpilp 1(lpilpilpil u  {
 ( eec8 mnlpilpilpilp     rlptg:s 60n xs(3  e(3 T  elt2.l*lp6w pbarrrrrrrrrrrr,xsrrrrrrrrra8eso
 (3  e(3 T  5r2dpRx, s jas&]rrrrra8eso
 -ylpilpil u  {
 ( eec8 mnlpilpilpilp        _(3 T     l| r2     ; 0     etr-eeej ab4ko-eedum/sso 1      4lvov1 v0 v2 I   AM1_(3 T     l| r2     ; 0     etr-eeej ab4ko-eedum/sso 1      4lvov1 v0 v2 I   AM1_(3 T     l| r2     ; 0     etr-eeej ab4ko-eedum/sso 1      4lvov1 v0 v2 I   AM1_(3 T     l| r2     ; 0     etr-eeej ab4ko-eedum/sso 1      4lvov1 v0 v2 I   AM1_(3 T     l| r2   r     _(3 T     l|   etr-   8MMSa  dq
       
 c8 8lpilpo_8MMSa  dq
       Sa  d4ko-ko-eexC       4(etr3ppb  ilpilpilpilpilpilpilpilpillpilpilpililpil31 0yuiz65warlpilppi4plPxanea8l|ndpar AMMSa  dq
       
   ;  (- Cji MMS
  0yuiz_ ]    ; 0_ 0K8    ; 0((3 T   41   1rpilpilpillpR +lol1lpi8tloSslM.xwarrrrrrrrrrrr,xsrrrrrrrrr,xsrrrrrrrrr,xsrrrL Ir r3 rrrrrr s_sta3 s      e4s  1    rlptg:s 6 a r3 t 2olpilpillpR +lol1lpi8tloSsl1  si8lpilpilpi[ s jas
 (3  a r3 {
 ((3 T     l| r2     ; 0     etr-sr,xsrrrrrrrrr,xsrrrL Ir r3 rrn3   1 yrrL Ir r3 rrrrrr s_ilpieu eulpixen3  4lpipii)lx)    mainloop48
mainlolpilpilpilpilpilpilpilpilpilpilxanea8l|ndparilpilpR=1 neal| r2 pilpilpilpilplpi8tloSs1
mainpariipi4plPxanea8D ((3 T     l| r2;piz65wr0mainp_d/1(pxm1, 3.eilpilppilpilpiD (w pbarrrrrrrrrrrr,xsrrrrrrrrra8eso
 (3  e(3 T  5r2dpRx, s jas&]rrrrra8eso
 -ylpilpil u  {
 (p0 (pt4plPxaneedU 1   1   1   1   1   1   1   1   1   1   1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilplx)    mpilpilp ilplx4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4str-2lpii)lx)
            n3  Otr-2lpii)lx)
      2nlolPxanea8D     2nlolPxanea8D     2nlolPxaneey    m   1rrrrrrrrrrrr,xsrr3o-eexC     8{
 ((3 T  e
 -ylpilpil u  {
 (p0 (pt4plPxaneedU 1  4lpi8tloSslM.xwarlpi8tloSslM.xwarlpi8tlCee1lpilpil    ; 020 el|  e  dpilpilpilpilpileec8 mu     l| r2     ; 0     etr-eeej ab4ko-eedum/sso 1      e2dpRx, s jas&]rrrrra8eso
 -ylpilpil u  {
 (p0 (pt4plPxal&]rrrrra8eso
 -ylpilpil u  {
 (p0 (pt4plPxaneedU u  {
 (p0 (pt4plPxal&]rrrrra8eso
 -ylpisso 1    loSslM.xw; 0     etr-eeej ab48eso
 (3  e(3 T{
 ((3 T  e
 -ylpilpil u  {
 (p0 (pt4pl.xwarlpi8tlCee1npt4plPxaneedU u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u sa loSslM.xw; 0   iorrrr,xeE  1   ilp1h(eexC u u u u u u u u u  (9 u u u u u u u s/lCee1npt4plPxaneedU u un1 (wvh=1oiS
  0;aci<(Ssl1  si8lpilpilpi[ s jas
 (3  a r3 {
  ab48esn;astr-eeej ab4ko-eedum/sso 1      e28pillseso
 -ylpilpil u  {
 (=0 1      e28pilltdv8    va l| r2  i mU_4 g:s 60n xs(3 T,ko-eexC       4(ej 3 s      e4s  1    rlptg:s 6 a r3 t 2olpilpillpR +lol1lpi8tloSsl1  si8lpilpilpi[ s jas
 (3  a r3 {
 ((3 T     l| r2   b4koa rrra8eso
 -ylpisso 1    loSslM.xw; 0     etr-eeej ab48eso
 (3  e(3 T{
 ((3 T  e
 -ylpilpil u  {
 (p0 (pt4pl.xwarlpi8tlCee1npt4plPxaneedU u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u u sa loSslM.xw; 0  j(pt u uB;Ywieilltdv8   lpixe
  #t u  {
 ((3 T   4K8    x 0KlpixU_4 g:s 60n xs(3 T,ko-eexClpilpilpileec8 mu     l| r2     ; 0    llS0yuiz65warlpu u u u u u u u u u u u u u u u e     sAdTec8 mu     l| r2     ; 0u sa loSslM.xw; 1    uB;Ywieilltdv8   lpixe
<lllll 8ei8eso
 (3  e(3 T  5wieil4}EEEEEEEEEi+uil31 0yuiz65warlpilppi4plPxanea8l|ndpar AMMSa G3typrr,xeE  1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilpl;ilo2Aau eu *pi ab4ko-a 0   0 u u u uafxClp/Ei+uil31 0yuiz65warlpilppi4plPxanea8l|ndpar AMMSa G3typrr,xeE  1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilpl;ilo2Aau eu *pi ab4ko-a 0   0 u u u uafxClp/Ei+uil31 0yuiz65warlpW 0((el&]rrrrra8e2 xs(3 T,k    loSslM.xw; 0     etr-eeej ab48eso
 ko-a
 (p0 (pt4a8e2 xs(3llpR +lol1lpidpar AMMSa G3typrr,xeE  1   iwarlpW 0((l xs(3llpR +lol1lpidpar AMMSa G3typrr,xeE  1   iwarlpW 0((l xs(3llpR +lol1lpidpar AMMSa G3typrr,xeE  1   iwarlpW 0((l xs(3llpR +lol1lpidpar AMMSa G3typrr,xeE  1   iwarlpW 0((l xs(3llpR +lol1lpidpar AMMSa G3typrr,xeE  1   iwarlpW 0((l xs(3llpR +lol1lpidpar AMM ilpl;ilo2Ae     s8Var A pidp ia   EMMS
      (nss
d( sdv8   lpixe
<llea:wW 0b3  rr,xeE  1   ilplx)  xlpR   lp_O1lpidparrrtrr,xeE  1   ilplx)  xlpR   lp_O1lpidrr,xsrrrrrrrrr,xsrrrrrrrrr,xsrrrrrri,xsrrrrrrrrr,xsrrrrrrrrr,xsrrrrrri,xsrrrrrrrrr,xsrrrrr rrrrrrr,xeE  1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilpl;ilo2Aau eu *pi ab4ko-a 0   0 u u u uafxClp/Ei+uil31 0yuiz65warlpilppi4plPxanea8l|ndpar AMMSa G3typrr,xeE  1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilpipiD (w pbarrrrrrrrrrrrrr,xeE  1   ilpl;ilo2Aau#4 0  4 g:u u u u  ,api4plPxanea8l|ndplpvMMSa G3typrr,phnrc   (etr-eee0ape44S0yuiz65warlpilpo_8llti1   1rpilpilpill4iz65warlpilpo_8llti1   1rpilpilpill4iz65warlpilpo_8llti1   1rpilpapR +lpu16y.u 8 m1uwarlpilppi4plPxanea8l|ndpar AMMSa G3typrrrrwhlc44S0yud_8llti1   18llti1   18llti1   18lpR   joi lpil u  {
 (p    p2u1  ilpl;ilo2Aau eu *pi ab4ko-a 0   0 u u u uafxClp/Ei+u o 8e_ (png_pass_inc[pass] - 1)*pixel_bypil u  {
 (p    p2u1  ilpl;ilo2Aau eu *pi ab4ko-a 0   0 u u u uafxClp/Ei+u o 8e_ (pngpilpapto
 -ylpilpil u  
    _n8esmmao ilpapto+pR  lo2Aautyprr,xe1afxClp/Ei+uil36  4(etr3paT,kBn[CCPe 1 v; ; 0K8   u uafxClp/Ei+u o 8e_ (pngpilpapto
 -ylpilpil u  
    _n8esmmao ilpapto+pR  lo2Aautyprr,xe1afxClp/Ei+uil36  4(etr3paT,kBn[CCPe 1 v; ; 0K8   u uafxClp/Ei+u o 8e_ (pngpilpapto
 -ylpilpil u  
    _n8esmmao ilpapto+pR  lo2Aautyprr,xe1afxClp/Ei+uil36  4(etr3paT,kue+pR  lo2Aautyprr u u uEi+u o  r u u+pR  lo2Aautyprr u u uEi+uu uEi+3:0   0 u (pt4pl1 31 0yuiz65warlpilppi4plPxanea8l|ndpar AMMSa  dq
       
   ;  (- Cji MMS
  0yuiz_ ]    ; 0_ 0K8    ; 0((3 T   41   1rpilpilpillpR +lol1lpi8tloSslM.xwarrrrrrrrrrrr,xsrrrrrrrrr,xsrrrrrrrrr,xsrrrL Ir r3 rrrrrr s_sta3 s      e4s  1    rlptg:s 6 a r3 t 2olpilpill1Ie4s  18tlCee1lpilpil    ; 02
     ytx s, v  me8m4
          Id    e
  0;       yi        }
     _nv  ml2t3bo        case s 0K8    x 0K8 +gxC  ,t 0K      4(!r, v  movqzs v2g)o   AMMS&i        ytx s, v _1,S&i    |d    e
  0;       yi        }
     _nv  ml2t3b  |d rCji *pe
  0;       yi        }
     _nv  ml2t3vl|d   rpilpilpill|d    e
  0;       yi        }
     _i4ko-eedum/sso 1      4 uil36 rlptgt  e
  0;      9r,xsrrrrrrrrr,xsrrrL Ir r3 rrrrrr s_lptg:0K8   }
   Elinlpilpilpilp 1(lpilphc1uilplx)  xlpR   lp_O1lpill4iz65warlpilpo_8llti1   1rpilpapR +9+lol1lpi8tloSslM.xwarrrrrrrrrrrr,xsrilo2Aau eu *pulplx)  xlpR   lp_O1lpia 1 v,t 0rrrrrrrrr,xsrilo2Aau eu *pulplx)  3 (w pe
  0;       yi      S   ; 0     etpilpo_8MMi1rpilpapRafxClp/Ei+uil36   g:u u u u  ,api4plPxanea8l|ndplpvM)  xlpR   lp_O1lpill4iz65warlpilpo_8llti1   1rpilpapR +9+lol1lpi8tloSslM.xwarrrrrrrrrrrr,xsrilo2Aau;o-eedum/sso3 e
  0;     s8ep u7o_8   g:u u u u  ,api4plPxanea8l|ndplpvM)  xlpRrM)  xlpR       s8ep u7o_8   g:u u u u  ,api4plPxanea8l|ndplpvM)  xlpRrM)  xlpR       s8ep u7o_8   g:u u u u  ,api4plPxanea8l|ndplpvM)pi4plPxanea8l|ndplpvM)  xlpRrM)  xlpR     _O1lpidrr,xsmr  xlpR          3 (ilx)
              R_I  4ic   (etr-eed   g:u u u u  ,aSa G3typrr,xea018   g:u u  3 (ilx)
               3*r-eed   xhbs-u u  1oSslM.xwarrrrrrr:3 (ilx)
          vpo_eE eautyp0;       yi      S i4plarrrrrrrrrrrr,xsr et I movihanea8l|ndplpvM)  xlpRrM)  xlpR       s8ep u7o_8   g:u u u u  ,api4plPxanea8l|ndplPxarrrrrrrrrrrr,xsr et I movihanea8l|ndplpvM)upi4m  1rpilpap      S i4plarrrrrrrrrrrr,xsr et I movihanea8l|ndplpvM)  xlpRrM)  xlpR       s31 applarrrrrrrrrrrg T   4K8    xfu u u    g:u u u u  ,api4plPxanea8l|ndplpvM)pi4       it2(l po_eEel1  si8lpilpilpi[ s jas
 (3  a r3 {
 ((3 T     l| r2   b4koa g:u u  3 (ilx)
    sgv] ((3 T  lp  *dp lF}0K88 pnr  dqlu  ;pb  {
 ((32+p u      l| r2n,00lpil  l| r2   b4koX)upieedU u u u u u u e r3  
 ((3 T     l| r2   b4koU u u u u u u e r3  
 ((3 T2   b4koU +u o 0 2oa g:u ufrrrrrapi4plPxanea8li2oa g:u ufrrrrrapi4plPxlpidpar AMMSa G3typr(ha G3typrr,+pR  lo2Aautyprr,xe1afxClp/Ei+uil(ha G3typrr,+pR  lo2Aautyprr,xe1afxClp/Ei+uil(ha G3typrr,+pR  lo2Aautyprr,xe1afxClp/Ei+uil(ha G3typrr,+pR  lo2Aautyprr,xe1afxClp/Ei+uil(ha G3typrr,+pR  lo2Aautyprr,xe1afxClp/Ei+uil(ha G3typrr,+pR  lo2Aautyprr,xe1afxClp/Ei+uil(ha G3typrr,+pR  lo2Aautyprr,xe1a: rilpilpilplpi8tloSs1
mainpariipi4plPxanea8D ((3 T     l| r2;piz65wr0mainp_d/1(pxm1, 3.     ; 0    llS0yuiz65warlpu uetr-ee0larrrrrrrrrrrg T   4K8    xfu uwdpar AMMSa G3typ etpi1f    i+uil(ha G3typrr,+pR  lo2Aautyprr,xe1a: ea8D(prr,+pR  lo2Aautyprr,xe1afxClp/Ei+uil(ha G3typrr,+pR  lo2Aautyprr,xe1afxClp/Ei+uil(ha G3typrr,+pR  lo2Aautyprr,xe1afxClp/Ei+uil(ha G3typrr,+pR  lo2Aautyprr,xe1a: rilpilpilplpi8tloSs1
mainpariipi4plPxanea8D ((3 T     l| r2;piz65wr0mainp_d/1(pxm1, 3.     ; 0  K8    x 0KSvnea8anea8l|ndplpvM)  xlpRrM)  xlpR     _O1lpidrr,xsmr  
s] - 1)*pixel_bypi llS2Ae     s8Var A pidp fl| r 2     ; 0yuizE>widt=e      {
         case 1:
         {
       _n8esmmao 
 r A pidp fl|anea8l|ndplpvM)  xlpRrM)aiplpvM)dM)dMa , 1:
         {
       _n8esmmao 
 r A pidp fl|anea8l|ndplpvM)  xlpRrM)aiplpvM)dM)dMa , 1:
         {
       _n8esmmao 
 r A pidp 
oR    na _n8esmme2e     nIA pidp 
oR  8BXhRSrrrrrrpidp 
o
lpilplpi8tloSs1
mainpazilpilplpi8tloSs1
mainpar   Uapto
 , 1:
         {
       _n8esmmao 
 r A pidp fl|anea8l|no 
 r A pidp fl|anea8l0|anea8l|ndplpvM)   mpilpilp ilplx4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4str-2lpii)lx)
            n3  Otr-2lpii)lx)
      2nlolPxaner _nv  ml2t3bo        case s 0K8 r,+pR  lo2Aautyp lplpi8tloSs1
main 2nlolPxaner _nv  ml2t3bo 4uEi+uu {
       _n8esmmao 
 r A pidp fl|anea8l|no 
 r A piner _nv  ml2t3bo.  l2t3bo 4uEesme| r2   b4koU u u u u u u e r3  
 ((3 T2   b4koU +u o 0 2oa g:u ufrrrrrapi4plPxan  U3R  lo2Aautyp lplpi8tloSs1
6an_o0  =du
       _n8esmmao 
 r A pidp fl|anea8l|ndplpvM)  xlpRrM)aiplpvM)dM)dMa , 1:
         {
       _n8esmmao 
 r A pidp 
oR 2Aautyprr,xe1afxClp/Ei+uil(h0e,Cbia 
oR 2Aautyprr,xe1afxClp/Ei+uil(h0e,Cbie,Cb.p040  =du
 
eAautyprr,xe1afxClp/Ei+uil(h0e,Cbia 
oR 2Aautyprr,xe1afxClp/Ei+uil(h0e,Cbie,Cb.p040  =du
 
eAautyprr,xe1afxClp/Ei+uil(h0e,Cbia 
oR 2Aautyprr,xe1afxClp/Ei+uil(h0e,Cbie,Cb.p040  =du
 
eAautyprr,xlpilpil m(inpariipi4plPxaprr,xe1afxClp/Ei+uil(h0e,Cbie,Cb.xa  dq
          t4il(h0exy      il(irrr1 _nv  ml2t3bo        3n8t/& nilpilpilpR=1oiipi4plPxaprr,xe1afxClp/Ei+uil(h0e,Cbie,Cb.xa  dq
       d.A o41     [i           p   +neeerl_byt       7 1   iwarlpW 0(neeerl_byt       7 1   ei+uil(
        p   +neeerl_byt       7 1   iwarlpW 0(neeerl_byt       7 1   ei+uil(
        p   +neeerl_byt       7 ),g
ed; 0yuizE>widtrpidp 
o
lpilplpi8tlrade)dM)dMa , 1:
         {
       _n8esmmao/Ei+zE>widtrpidp 
o
lpilplpi8tlrade)dM)d( eec8 mnxn_u
 
eAautyprr,xe1(2(l po_eEel1  si8lpiai 6ilplpi8tloSs  xlpRrM)aiplpvM44uEi+uu {
       _n8esmmao 
 r A pidp fl|aw pb4,CbhClp/ _nv  ml2t3bo.  l2t3bo 4uEesme| r2   b4koU u u u u u u e uEesme| r2   b4koU u u ue,Cst2t3bo 4uEesme|dpli r2   b4koU usiai 6ilp p   +neeeCbie,rEuEi+uu 5B (paif ((3 (  t                {
   mov   wprdwpl| r      + 1   +3pix  oa8l|ndp,b     [i  Ubo.  l2t3bo b4koUn9eililpilx)
              R_I  4ic   (etr-eep6  AM4       )8    x 0Klpixe
  #Ksrrrrrrrrr,xsrrrrrr5sb  e(3 T  eejoi m0Coa8l|ndp,  ee2fe8mr3ppb  2nlolpiilpilpilpR=1oi mU_4 g:s 60atxe C  0Kift;v    0yuiz65warlpilppi4plPxanea8l|ndpar AMMSa  dq
       
   ;  (- Cji
Pxrkaxn    0yuiz65warlpilppi4plPxanea; 0         s8ep u7o_8   g:u u u u  0         s8ep u7o_8   g:u u u _5pRrM)aiplpvM:u u u _5pRrM)aiplp,Ei+uu3( 4uEesme|d,m1/fu u u  0         s8ep u7o_8   g:u u u _5pRrM)aiplpvM:u u)* eu *pi
Pxrkaxn    0yulplpvM:sP,a 2  case 1:
           en:u u u _5pRrM)aiplp,Ei+uu3( 4uEesme|d,m1/fu u u  0         s8ep u7o_8   g:u u u _5pRrM)aiplpvM:u u)* eu *pi
Pxrkaxn    0yulplpvM:sP,a 2  case 1:
           en:u u u _5pRrM)aiplp,RrM)aiSwrh;c      2AautyEr)aiplpvM:u u)* eu *pi
Pxrkaxn    0yulpll(h0aip,m1/pi
Pxr  g:u u plpvM:u u)* eu *pi
Pxrkaxn    0yulplpvM:sP,a 2  case 1:
           en:u u u _5pRe0yulpanv PcVar A pidp
   mov   wprdwpl| r      + 1   +3pix  op,RrM)aiSwrh;c      2U u u x_5pRe0yulpanv PcVar A piAautyEr)aiplpvM
   mov   wprdwpl| r      + 1   +3pix  op,RrM)aiSwrh;c      2U u u x_5pRe0yulpanv PcVar A piAautyEr)aiplpvM
   mov   wprdwpl| r      + 1   +3pix  op,RrM)aiSwrh;c      2U u u x_5pRe0yulpanv PcVar A piAautyEr)aiplpvM
   mov   wprdwpl| r      + 1   +3pix  op,Rr/e     p   +neeerl_17s,Cb.xA piAautyEr)aiplpvM
   mov   wprdwpl| r  r      + 1 lp   mxu  0         s rrrrrrr,xeE  1   ilpipiD (w pw pu eu        s rrrrrrr,xeE  1   ilpipiD (w pw pu eu        s rrrrrrr,xeE  1 4pR +lols  p   +neeerl_byt VafxClp/lpi8tloSs  xlpRrM)aipr(7(_8m4? Vafx eu        s Aauti    en:u u u _5pRrM)aip g:unv PcVar - Aautu  ixeT.kaxn    0yulplpvM:sP,a 2  case 1:
           en:u u u _5pRrM)aiplp,RrM)aiSwrh;c      2AautyEr)aiplpvM:u u)* eu *pi
Pxrkaxn    0yulpll(h:u u u     + 1 lp   mxu  0   4m0yulpll(h:u u u     + 1 lp   mx4   i +lols  r    ddv_5pRrM)aiplpI ftyEr)aiplpva210yuizE> 4uEesme|d,m1/fu u u  0         s8ep u7o_8   bt ufrrr,xeE  1   ilpipiD (w pw pu eu        s rrrrrrr,xeE  1 4pR +lols  p   +neeerl_byt VafxClp/lpi8tloSs  xlpRrM)aipr(7(_8m4? Vafx eu        s Aauti    en:u u u _5pRrM)aip g:unv PcVar - Aautu  ixeT.kaxn    0yulplpvM:sP,a 2  case 1:
           en:u u u _5pRrM)aiplUg caseedi    movqS(3 Tilpid()lx)
   lpi 8xu  0   4m0yulpll(h:u u u     + 1 lp   mx4   i +lols  r    ddv_5pRrM)aiplpI ftyEr)aiplpva210yuizE> 4uEesme|d,m1/fu u u  0         s8ep u7o_8   bt ufrrr,xeE  1   ilpipiD (w pw pu eu        s rrrrrrr,xeE  1 4pR +lols  p   +neeerl_byt VafxClp/lpi8tloSs  xlpRrM)4il(h      s rrrrrrr,xeE  1 4pR +lols  p   +neeerl_byt VafxClp/lpi8tloSs  xlpRrM)4il(h      s rrrrrrr,xeE  1 4pR +lols  p eRrM)aiSwpPe6y rrrw; 0     etr-eeej etrols ;10ya+lpu16y.u 8 m1uwarlpilppi4plPxanea8l|ndpar AMMSa G3typrrrrwhlc44S0yud_8rl__22dcase 1:
    tndpli    ddv_5pRrM)aiplpI ftyEr)aiplpva210yuizE> 4uEesme|d,m1*pelM)aiplpI ftyEr)aiplpva210yuizE> 42(dlpRrM)      + 1 lp   mxu  0         s rrrrrrr,xeE  1   ilpipiD (w pw pu eu        s rrrrrrr,xeE  1   ilpipiD (w pw pu eu        s rrrrrrr,xeE  1 4pR +lols  p   +neeerl_byt VafxClp/lpi8tloSs  xlpRrM)aipr(7(_8m4? Vafx eu        s Aauti    en:u u u _5pRrM)aip g:unv PnlolPxxClp/lpi8t1_((3 T   41   1rpilpilpillpR +lol1lpi8tlel(irrilpi8t1_((3 T   41   1rpilpilpillptyprrr_  p   +neeerl_byt VafxClp/lpi8tloSs  xlpRrM)aipr(7(_8m4? Vafx eu        s Aauti    en:u u u _5pRrM)aip g:unv PnlolPxxClp/lpi8t1_((3 T   41   1rpilpilpillpR +lol1lpi8tlel(irrilpi8t1_((3 T   41   1rpilpilpillptyprrr_  p   +neeerl_byt VafxClp/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)aip g:unv Pnloi8tloSs1
mainpariipi4plxe1cv r    ddv_5pRrM)aiplpI ftyEr)  ilpipiD (w pw pu e1ew+
Pxrkaxv(ariipi4plxe1cv r    ddv_5pRrM)aiplpI ftyE8,s   
 r A pidp fluClpe*   s rrrrrrr,xeE  1704u u u  pidp fluClpe*  lstloSsi(3 T   41   1rpilpilpillpR +lol1lpi8tlel(irrilpi8t1_((3 T   41   1rpilpilpillptyp2s1
_llpR +lol1lpi8tlel pu e1ew+
Pxrkaxv(arb  etizE> 4uEesme|d,m1/fu u u  0         s8ep upilplpi8tlo T  )ai1e1N  2U u u x_5pRe0yulpanv PcVa4pR +lols  p  
d0drslxe1cv r    ddv_5pRrM)aiplpI ftyEr)  ilpipiD (w p  p  p  p             tolplpi8tloSs1
mxe1cvlpeso
 ko3o3o3o0A+ht1_((3 T   44f4uEeRe0_5pRrM)aip g:0A+ht1_((3 T 1ewDf4uEeRe0_5pRrM)aip g:0A+ht1_((3 T 1eClpddv_n
,2pi
Pxrkaxlx e   b4koU 4SD (we=ilpdp 
pb  {
 ((3 nal]d +3ppb  {
 ((3 T   4K8  * r    ddvR/lpi 4D (we=ilpdp 
pb  {
 ((3 nal]d +3p u u     + 1 lpuizE>=umsi8tloSs  xlpRrM)4il(h  np-vR/lpi 4D (we=ilpdp 
pb  {
 ((3 nal]d 2lwe=ip2w + 1 lp  r    dp4D (we=ilpdp 
pb  {
 ((3 nal]d +3p u u     + 1 lpuizE>=umsi8tl 1:
 [=umsi8tl 1omovq      = &(png10 w    ja     tndpli    ddv_5pRrM)aC* [=ums fmrwhlizE>Rr/)aC* [=uirpl| r     g10 w   )aip g:unv PcVar - AauteUd-gRr/cVar - AauteUd-gRr/cVar - AauteUd-gRr/cVar - AauteUd-gRr/cVar - AauteUd-gRr/cVarlols  p  
d0drslxe1cv r    ddv_5pI ftyEr)aiplpva210yurb +3;1 yi  ascxe1a: rilpilpilpgRr/[C* [=ums fmrws2Aautyr    ddv_5pI ftyEr)aiplpva210yurb +3;1 yi srrr_5pI ftyEr)aiplpva210yurb +(         __int64 const4 = 0x00yurb +(  hIcVarl = 0x00yurb +(  hIcVa0e,Cilplpi8tloSs1
mainpar   Uapto
 ne23ppb  {
 (4lpidpar AMM ilpl;ilo2Ae     s8Var A peth   _n8esmmao 
 r faSVa0e,Cilplpi8tloSs1
ms r faSVa02du+3;1 yi srrr_5pI ftyEr)aiplpva210yurb +(3r pi8t1_((3 T   41   1rpilpilpillpR +lol1lpi8tlel(irrilpi8t1_((3 T   41   1rpilpilpi)* [1lpil(irrito1lpil(irrito1lpilpi8tlw pekoU usiai 6illp/lpi8t1_((3 T eMMSa  dq
       !4onda{pekoU usiai 6illp/lpi8t1_((3 T ,tloSn1
mannparlgej,pil(irrito1lpilpi8tlw pekoU usi(pilpil    ; 02
  C* [=u,r)  ilpiCd41   1rpilpilpillpR +lol1lpi8tl28_xpVafxClp/lpi812dv_5pI ftyEr)aiplpva210yurb +3;1_plpi8tlw pekoU usiai 6illp/lpig +lo(4lpT4esa_1_plpi8tlw pekoU usiai 6ieerl_byua Gdd +3i8tloSN4 4(etr3ppb  {
 ((3 T  eej ab4koeeej   rVafx51lpi8tl28_xpVafxClp/lpi812dv_5pI ftyEr)aiplpva210yurb +3;1_plpi8tlw pekoU usiai 6illp/lpea8l|ndplpvM)  xlpRrM)  xlpR       s8ep u7o_8   g:u u u u  ,api4plPxanea8l|nlep u7o_8   g:u u u u  ,api4plPxanea8l|pi8tloS u 2tA1r
 r falp1lth +mlpig1_((3 T   41   1rpilp_byt Val u u u l3neaClp/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  +l=RrM)ap/lpi8tloSscLinc x(2c  C  0K8  TM)ap/lpi8tloSs  xlpRrM)_s215utix 1rpil;  (- Cjis  x n6illp/lpea8l| zatloSs9/lpe3 xlpRrM)_s215utix 11
mannparlgej,pil(irrito1lpilpi8tlw pekoU usi(pilpilealo8t1_(e15uti    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215uti    en:u u u _5pRrM)ap/lpi8tloSs  +l=RrM)ap/lpi8tloSscLinrs0)_s2    }
     _nv  Rr/cVarlols  p  
d0drslxe1cv r    ddv_5pI ftyEr)aiplpva210yurb +3;1 yi  ascxe1a: rilpilpilpgRr/[Cva210yurb hs8"41   1rppi8tloSs  +l=RrM)ap/lpduaY)d  xlppppppppppppppppppppppppppppppppppppppppppp _i4ko-eedum/sso 1      4 uil36 rlptgt  ll:u u ct   4 uil36 rlptgteUd-g_byiSwrh;c  g  g ,4o 1      4 uil36  41   1rpilpilpillpR +lol1lpi8tlel(irrilpi8t1_2tk v2 vl  e010ip0ipctx a3(tin    illpilpilpililpilx)
     p3(tin  ((3 nm/sso 1      4 uil36 rlptgt  lxe
  #K8    x 0Kluxq4ko 1      4lvo;8      d 4lp   x 0Kl   i)oC 0  pb  {
 ((3 T    4(3 T   4K8    x fcr s  x fcr s  8e_ (png_pass_inc[pass] ue6        nep+lol1lpi8tlel pu  0Kluxqx   nep+lol1lpi8tlel pu  0Kluxqx   nep d 4lp   x 0Kl   i)oC 0  pb  {
 ((3 T    4(34plPxanea8l|p2lPxanea8l|p2lPxanea8l|p2lPxb4
_byt V1  (xcxanea8l|p2lPxanea8l|p2lPxb4
_byw22rr3pv44K8    x autup+lopR +lol1lpi8tlel(il,RrM)aiSwrh;c      2U u u x_5pRe0yulpanv PcVar A piAautyEr)aiplpvM
 1pi8ttSwrh;c      2U u u x_5pRe0yulpanvele3 nlptgt  ll:u u ct pgRr/[C* [=rws2Aautyr pilpilpillp ((3 T  eej ab4koeeej      r((3 (            tol40repild(  pb  {
 ((e0yulpne0j
h;c u,onepab4koeeej      r((3 (            tol40repild(  pb  {
 ((e0yurlpW 0((lpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpincuxqilpilppilpincuxqilpilpp)cuxqllpillp)cuxb4
_byw22rr3pv44K8    x autup+lopiplpvM
 1pi8ttSwrh;c      2U u u x_5pRe0pddv_ppppppppppppppppppppu x(((((((l0  pb  {
 pddv_pqpRrMl0yuizE> 4uEesme|d,m1/fu u u  0         s8ep u7o_8   bt ufrrr,xeE  1 loSs  xlpR)
   u u u  0         s8ep u7o_8   bt ufrrr,xeE  1 loSs  xlpR)
   u u u  0         4rilpil6u  0)uEepixeno)   lpilp
Bes4R)
  qpddv5lpiSwrh;c Mf   4rilpi D   u uDufrrr,ec8 mu     l| r2     ; 0u sa l1cv r I)    s8ep u7o_8sufrrr,ecrr, r2     ; 0u me 1fsa0e,Cilplpiurlpulpanv Pc2ol4xpincuxqilpilppilpincuxqilpilpp)cuxqllpillp)cuxb4
_byw22rr3pv44K8    x au   _nv  Rr/cVarlols  p  
d0drslxe1cv r    ddv_5pI ftyplpi8tlo T  )ai1e1N  2U u u x_5pRelyplpi8tlo T  )ai1e1N  2U u u x_5pe1N  2U u u x_5pRelyplpi8lmlpilpilpi6 MMSa  dq
       !4onda{pekoU uscLiniSwrh;c Mf   4rilpi D   u o,&es2 ufrrr,xeE ril41 u  Slpilpilpilpilpilpilplp/ewrh;c Mf   4rilpi D  a4PepR)
,e2u1a 2  case 1:        nea4clep uscLi21
6an_o0  =du
       _n8esmmao 
 r A pidp fl|anea8l|ndplpvM)  xlpRrM)aiplpvM)dM)dMa , 1:
         {
       _n8esmmao 
pvM)  e4   _nv  Rr/cVarlols  p  
d0dai1e1pli    ddvcM 0  pb  {
 ((3 T    4(3 T   4K8  4pi8ta2Aautyr pilpilpillp ((3 T  eej ab4koeeej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r(4pilpilpilpilpilpilpilpil3 (6Rnieej      r((3 (6Rnieej      r((3g1  r(4pilpilpo_8   bt ufrrr,xeE  1 loSs  ,ea3;1_plpi8tlw pekoU usialpilp       h
t ufrrr,xeE  1 loSs  ,ea3;1_plpi8tlw pekoU usi    h
t ufrrr,xeE  1 loSs  ,eti    en:u u u _5pRrM)ap/lpi8  ,ea3;1_plpi8n 1 loSs  ,ea3;1_plnpvM)dM)dMa , 1_plpi8tlw pekoU usi    h
t uf(6Rnieej      r((3 (6Rnieej  i8tloSs  xlpRrM)_s215u(4pilpilpo_8   bt ufrrr,xeE  1 loSs  ,ea3aa3aa3aa3aa3aa3aa3aa3aa3aa3aa(caii1oSs  ,ea3aa3aa3aa3aa3aa3aa3aa3a=du
       _n8esmmao 
 r A pidp fl|anj   e)aiplpva210y1uaa3aaip g:unv PcVar - AauteUd-gRr/cVar - AauteUd-gRr/cVar3(3xeE  1 loSs  xlpR)
   u u u  0         4r tp  )ai1e1N  2U up15uti    en:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4pilpilpo_8   bt ufrre1   en:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4p=du
       _n8esmmao 
 r A pidnh
t ufrrr,xeE  1 loSs  ,lns  ,eti    enl1 loSs  ,lns  ,eti       _n8esmmao ilpapto+pR  lo2A2lxlp.lteUd-gRr/cVar3(3xeE  1 loS0t pgRr/[C*    4lvo;80
Re0yulpanvele3 nlptgt  ll:u u ct pgRr/[C* [=rwu ct teUd-gRr/cVar3(3xeE  1 loSs  xni1C+lopiplpvM
 1pi8ttSwrh;c     n:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4p=du
  M)_s215u(4uu {
       _n8esmmao 
 r A pidp fl|aw pb4,CbhClp/ _nv  ml2t3bo.  l2tn4oSs  xlpRrM)_sr)  e)aiplpva210y1uaa3aaip g:unv PcVar - AauC{8     2nlolPxanea8D     2nlolPxaneee1cv r    ddv_5pRrM)aiplpI ftyEra    ddv_5pRrM)aiplpnlpR)
   u u u  0         4r tplfalp1lth +mlpnt64 const4 = pA+ht1_((3 T 1eClpddv_n
,TA+ht12a*nRrM)aiplpI ftyEracv ra8l|nlep u7o_8   g:u u u u  ,api4plPxaneaptacv roo_8   bt ufrrr,v+t roo_8   bt ufrrr,v+t roo_8   bt ufrrr,v+t ddv_n
,TA+ht12a*nRrM)aiplti1   1rpilpilpi0Spr 1   sb  e(3 T  elt2.l*lp6w pbarrrrrrrrrrrr,xsrrrrrrrrr,xsrrrrrrrrr,xsrrrrrr5sb  e(3 T  eejoi m0Co5rrrrrrrrrrrr,xioi m0C 0Kift;v    0lpi0Sp  r((3 (            tol40repild(  pb  {
 (m1
mainpariipi4plxe _n8es,,bep d (3 2tacv roo_8   bt ufrrr,v+t roo_8  i1e(3 T  elt2.l*lp6w pbarrrrr  ,api4pl>+  bt ufrrr,v+t roo_8   bt ufrrr,v+7ss  ,ea3;n8o_8 3oufrrr_*2       4r tdu u u  ,api4plPxaneaptacv roo_8   .m.    h
t ufrrr,xeE  1 loSs  ,eti    en:u u u _+  ,ea3aa3aa3aa3aa3aa3aa3aa3aa3aa3a6kb y_see _n8es,,bep1lt _+  ,ea3aa3aa3aa3aa3aa3aa3aa3aa3aa3aa6kb y_see _n8es,dL,bep1lt _+ xqx   e(3 T  elt2.l*rupl>+  bt ufrrr,v+tmC 0Ko_8*he)a3aa3aa3aa3aa3aa3aa(caii1ol o_8   bt ufrrr,xeE  1 loSs  ,ea3;1_plpi8tlw pekoU usialpilp       h
t ufrrr,xeE  1 loSs  ,eaE  1 loep d 4)t+1lea3
pil(irrito1lpilpi8tlw pekoU usi(pils4g3autyEr)aiplpvM
 1pi8ttSwrh;c      Op3o0A+ht1_((3 p4i    en:u u u _5pRrM)ap/lpi8tloSs  xlpRrM)_s215ut
t ufr/lp u u _5pRrM)ap/lpi8tloSs  +l=RrM)ap/lpi8t 4lvo;5_nv 40n8o_8 3oufrrr_*,     4r tdu u u  ,api)AN.n      4r tplfalp1lth +mlpnt64 con,dti  2o  ll:u u ct pgRr/[x u u  ,api)AN.n      4r tplfalp1lth +mlpnt64 con,dti  2o  ll:u u ct pgRr/[x ua403aa3aa3aa3aa3aa3aa3aa3aa6kb y_see _n8es,dL,bep1lt _+ xqx)EmedL,b0M)_s21au u ugl (64d3aa3aa3asrupl>+  bt ufrrr,v+tmC 0Ko_8*he)a3aa3aa3aa3aa3aa3aa(caii1o)Eme1lth klD ufrroufrrr_*,     4r tdu uhSld(  pb  {
 ((e0yulpne0j
h;c u,onepab4koefu u u  pidp fluClpe*  lstloSsi(3 T   41   1rpilpilpillpR +lol1lpi8tlelr40n8o_8 3oufrrr_*,     4r tdu u u  ,sggvAN.n      4rab4koeonep)ap/lpi8t 4lvo;5_nv 4i(3 T   41   x 11
mann4r tdu up15uti    en:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4pilpilpo_8   bt ufrre1   en:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4p=du
       _n8esmmao 
 r A pidnh
t ufrrr,xeE  1 loSs  ,lns  ,eti    enl1 loSs  ,lns  ,eti       _n8esm_8   bt4 lpi8tlIhctsn#]e5_nv 4i(3 T   41   x 11
mann4r tdu up15uti    en:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4pilpilpo_8   bt ufrre1   en:u xqx   w     4 uil36 rlptgt  ll:u u n:u en:us   4pihYil3-d  4 : y_see _n8es,,bep1lt _+  ,ea3aa3aa3aa3aa3aa3aa3aa3aa3aa3aa6kb y_see _n8es,dL,bep1lt _+ xqx   e(3 Tb y_see _n8eses   4pihYil3-d  4 : y_sewr1 _see _n8es,dL,bep1lt _30         s8enG4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eej ab4koeeej   4(str-eeej ab4ko-e}AkCn215u(4pilpilpo_8   bt ufrre1   en:u xqx   w     4 uil36 rlptgt  ll:u u n:u en:us   4pihYil3-d  4 : y_see _n8es,,bep1lt _+  ,ea3aa3aa3aa3aa3aa3aa3aa3aa3aa3aa6kb y_   bt urors,dL up15uti    en:see _n8es,,bep1lt _+u _5pRgeej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eaase 1:u _5pRgeej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eaase 1:u _5pRgeej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eaase 1:u _5pRgeej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eaase 1:u _5pRgeej ab4koeer 1:u _5pRgeej ab4koeeej   4(str-eeejeejrjrjrjrtab4koesr  4(spol|eyulpanvele3 nlptgt  ll:u u ct oeeej   4(str-eeej ab4ko-eexCneeepb  {st r((s-s4iz6Era    dd;1:usrrrrrrrrr,xsrrrrrrrrr,xsr15ut
t ufr/lp u u _5pRrM)ap/lpi8tloSs  +l  wr4j ab4dr   :kaxr1 _see-eeejeejrjrjrjrts,xsr  wr36 srrslpRrM)_s215uti    en:u u urjrjrjrts,lt _lrjrFpbarbrlprrrrrrr,xsr15ut
8/lp s215u(4pilpilpo_8   bt ufrre1  v 3 3 3 3 3 3 3 3 3 3  3  3  3(o-errrrrrr,xsrrep d 4)t+1lea3
pil(irrito1lpilpi8tlw pRrM)aiplpnlpR)
  3 3 ed _)ep dv roxsrrer)z 8p)plpnlpR)
  3 3 ed _)ep dv roxsrrer)t5aa3bt ufraa3aa3aa3a;6Rn  4(3 r15ut
t ufr/lp u l>+  bbep1lt _+uilpi(4p=du
  er)t5aa3bt ufraa3aa3aa3a;6Rn  4(3 r15ut
t ufr/lp 
  3
dxqxs7Rgee
t ufr/lp 
  3
dxp/lpi8tl)atr-eeejeoi8tloSx2
x2
x2
x2
x2
x2
x2
x2
x](etxqxs7Rg)n  4nlptgt  ll:u u ct o-z1ar/lp u l(3 r15ut
t ugt  ll:u u n:u en:us   4pihYil3-d  4 : y_see _n8es,,bep1lt _+  ,ea3aa3aa3aa3i)o0n
3RA  en:u5eej ab4koeeej   4ns  4ns  4ns  4ns  4ns  b,ea3aa3aa3aa3i)o0n
3RAtl)at   p ab4koeeej   4ns  2
x](etxqxs7Rg)n  4nlptgt  ll:u u ct o-z1ar/lp u l(3 r15ut
t ugt  ll:u u n:u en:us   4pihYil3-d  4 : y_see _n8es,,bep1lt _+  ,ea3aa3aa3aa3i)o0n
3RA  en:u5eej ab4koeeej   4ns  4ns  4ns  4ns  4ns  b,ea3aa3aa3aa3i)o0n
3RAtl)at   p ab4koeeej   4ns  2
x](etxqxs7R4koeeej   4ns  2
x]()anea8D     2nlolPxaneee1cv r    ddv_5lptgt  ll:u u ct o-z1arjzx(/lp 
  3
dxp/lpi8tl)atr-eeejelpi(3 (4koeeej   4(str-eeejet-z1arjzx(/lp 
  3
dx-z1apy_see exC       4(etr3ppb  {
 ((3 T  eaase 1:u _5ppilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilpilt/lp 
  ilpoihYil3-d  4 : y_see _n8es,,bep1lt _+  ,ea3aa3aa3aa3aa3aa3aa3aa3aa3aa3aa6kb y_   bt urors,dL up15uti    en:see _n8es,,bep1lt _+u _5pRgeej ab4koeeej   4(str-eeej ab4ko-eexC       4(etr3ppb  {
 ((3 T  eaase 1:u _5pRgeej ab4koeeej   4(str-eeej ab4ko-eexC       4epb  {
 ((3 T  eaase 1:u _5pRg1)1lpeIu u-eeeerr,xeE  1 loSs  ,ea3;1_4vd(3 T  eaase 1:u _5}upilpilpRL42 eaase 1:u _5}upilpilpRL42 eaase 1:ulpi8tl)attp dv rn_
x](etxqxs7R4koeeej   4ns);3arrrrr,xsrrrrrrrrr,xsr15ut
t ufr/lp u u _5pRrM)ap/lpi8tloSs  +l  wr4j ab4draase 1:u _5pRgeej ab4koeeej   4(str-eeej a dv rnrp+l  wr4j ab4draas        {
      Ailpilpilpilpilpilpilpilt/lp  _5pR oSx2aorM)1l
3lpilpillpR +lol1lpi8tlelr40n8o_8 3oufrrr_*,     4r tdu u u  ,sggvAN.n      4rab4koeonep)ap/lpi8t 4lvo;5_nv 4i(3 T   41   x 11
mann4r tdu up15uti    en:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4pilpilpo_8   bt ufrre1   en:u xqx   nep d 4lp    noSs  xlpRrM)_s2pmn:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4 _n8es,blpneoyd  CUx 11
mann4r tdu up15uti    en:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4pilpilpo_8   UA xlpRrM)_s215u(4pilpilpo_8   UA 8tlw pekoU usUA xlpRrM)_s215u(4pilpilpo_8   UA 8tlw pekoU usUA xlpRrM)_s215u(4pilpilp pekoU usUA xlpRrM)_s215u(4pilpilpo_8   UA 8tlw pekoU08d 4lko-eexC       4(etr3ppb  {
 ((3 T  eaase 
x2Cbia 
oR 2Aautyprr,xeEeej S 
 ((3 T  eaase 
x2Cbia 
oR 2Aautyprr,xeEeej S 
 ((3 T  eaaad 8frr    tol40repild(  pb  {
 ((e0yulpne0j
h; S 
 ((3 Txqx  ild(  pb  {
 ((slpi15uT  4ld(  pb  {
 ((e0yulpne0j
h; S 
 ((3 Txqx  e0j
h; S 
 ((1ase xlpRrM)_s215u(4pilpilpo_8   pilpilse xlpRrM)_s2teus   4  _&UA xlpRrM)_s215u(4pilpilp pekoU usUA xlpRrM)_s215u(4pilpilpo_8   UA 8tlw pekoirM)_s215u(4pilpilpo_8 hrM)_s215u(4pilpilp pekoU usUA xlpRrM)_s215u(4pilpilpo_8  )_s215u(4pilpili18tlo=M)_s2teus   4  _&UA xlpRrlpilpo_8 hrM  pb  {
 ((e0yulpne0j
h; S 
 ((3 Txqx  ild(  -atus   4  _&e
Txqx  e0j

oR 2Aautyprr,xeEeej S 
 ((3 T  eaaad 8frr    tol40ree_m,ea3;v 4i(3 T   41   x 11
mus   4  _&e
Txqx  e0j

oR 2Aautyprr,xe36 rld6l(hxlptob  {
 ((3 T   4K8  * r    ddvR/lpi 4D tl(4pilpilpo_8 hrM)_s215u(ab4ko-eexC       4epb ld:0 (( 4i(,vtllti1   1rpilp      4epb ld:0 (( 4i(,vtllti1   1lp      4epb ld:0 (( 4i(,vtllti1   1lp      4epb ld:0 (( 4i(,vtllti1   1lp      4epb C1:u _5}uprRd bd bd bdpi[ s jaepbltivtllti1   1rpilp      4epb ld:0 (( 4i(,vtllti1   1lp      4epb ld:0 (( 4i(,vtllti1   1lp      4epb ld8frr    tol40ree_m,ea3;v 4i(3 T   41   x 11
mus   4mao hea3;1_4vd(3 i/u  4ns  4y 41 rbpb C1:u _5}uprRd bd bd 4y eMel3-d  4 : y_see _n8es,,bep16dr1u  8oa8l|ndp,{h   xlpRrM)_s215u(4pilpilpo_8   UA xli" d h_see _nohdexC       4epb  {
 ((3 T  eaase 1:u _5pRg1)1lpeIu u-eeeerr,xeE  1 loSs  ,ea3;1_4vd(3 T  eaase 1:u _5}upilpilpRL42 eaase ampilp 4naa3a    p"ilpRL42 eaase asee e _mte 1:u _5}upilpilpRL42h1plarrrrrrrrrrrr,xsr et I movihanea8l|nfvno8es,,lpilpi_a8l|nppieelm  1 loc4pilp 4naa3a    p"ilpRL42|nppieelm  1 loc4pilpgp      4epb ld:0 (( 4i(,vtllti1   1lp      4epb ld:0 (( 4i(,vtllti1   1lp      4ei 6illp/lpi8t1_((3 T eMMSa  dq
      arrrtpri 4i 4i 4i 4i 4i 4i 4i 4i 4i 4i t1_((3 T eMMSa  dq
      arrrtpri 4i 4i 4iU(3 T ri 4i 4i 4i 4i 4i 4i 4i 4i 4i 4i t1_((3 T eMMSa  dq
      arrrtpri 4i 4i 4iU(3 T ri 4i 4i 4i 4i 4i 4i Dpilpo_8   h; a3ailpRL42|nppie r; 0 2ailpRL42h1plarrrrrrrrrrrr,xsr et I movihan b4i 4i 4i 4i )& 2aio_a8l05i 4i )p)7ao
et I movihan b4i 4i 4i 4i )& 2aio_a8l05i 4i )p)7ao
et I movihan b4i 4i 4i 4i )& 2aio_a8l05i 4i )p)7ao
et I movihan b4i 4i 4i 4i )& 2aio_a8l05i 4i )p)7ao
et I movihan b4i 4i 4i 4i )& 2aio_a8l05i 4i )p)7ao
et I movihan b4i 4i 4i 4i )& 2aio_a8l05i 4i )p)7ao
et ,*8 4i )p)7ao
et ,*8  0yuiz65warri
x2
ia 
oR"u-eeeerr,xeE  1 loSty
et I movihas;1ao he,lvihan )hi
x2;1ao he,lvihan )hi
x2ao_aphihan b4i 4i 4i 4i )& 2aio0a3ailpRL4  1 loSty
et I movihas;1ao he,lvihao_a : yi )lpR   +n,e,lvvvvv____-2,%iaAauC{8     2nlolPxanea8D     2nlolPxaneee1 n);3arrrrr,xsrrrrrrrrr,E    2nlolPxanea8D     2nlolPxaneee1 n);3arrrrr,xsrrrrrrrrr,E    2nlolPxan{h o*lole0j

oR 2A   4 uil36 rlptgt  ll:u u ct   4 uil36 rlx fcr s  x fcr s  80 4 uil36 rlx fcr s -4d3:is4   4ns  2
x]()anea8D      0yu)aiSwrh;c      2U u u x_5pRe0yulpanv PcVar A piAautyEr)aiplpvM
 1pi8ttSwrh;c      2U u u x_5pRe0yulpanvele3 nlptgt  ll:u u ct pgRr/[C* [=rws2le3 nlptgt  ll:u u ct pgRpRe0y9+ll:u  ll:u u ct pgRpRe0y9+ll:u  e  4 uil36 rlptgt  ll:ull:u u4
lu [=rw   x 11
mus   4mao hea3;1_4vd(3 i/u  4ns  4y 41 rbpb C1:u _5}uprRd bd bd 4y eMel3-d  4 : y_see _n8es,,bep16dr1u  8oa8l|ndp,{h   xlpRrM)_s215u(4pilpilpo_8   UA xli" d h_see _nohdexC       4epb  {
 ((3 T  eaase 1:u _5pRg1)1lpeIu u-eeeerr,xeE  1 loSs  ,ea3;1_4v uil36 rlptl bd 4y eMe0os215u {st r(( rla8l|nlep u7o_8   g:u u u u  ,api4plPxaneaptacv roo_8   bt ufrrr,v+t royanlpilu2l:u u iroo_8   bt ufrrr,v+t royanlpilu2l:uu u u  pidp fluClpe*  lstloSsi(1peMMSa  dq
Sty
ex 11
mus   4mao hea3;1_4vd(3 i/u  4ns  4y 41 rbpb C1:u _5}uprRd bd bd 4y eMel3-d  4 : y_see _n8es,,bep16dr1u  8oa8l|ndp,{h   xlpRrM)_s215u(4pilpilpo_8   UA xli" d h_see _nohdexC       4epb  {
 ((3 T  eaase 1:u _5pRg1)1lpeIu u-eeeerr,xeE  1 loSs  ,ea3;1_4v ui_s215u(4pilpilpo_8   UA xli" d h_see _nohdexC       8po_8   UA xli" d h {
 ((3 T  eaas ab4koeeej   4(str-eeejeejrjrjrjrtab4k u7o_8   g:ua i8t1_((3 T eMMSa  dq
    i-eeejeejrjrj4vd Av3 T   41   x 11
mus   4mao hea3;1_4   08s*i5exC MMSa  dq
    i-eeejha6 i-eeejeejrjrj4vd Av3 T   41   x 11
mus ze3 T   41   x 11
mus   4mao hea3;1_4T   410   +n,e,lvvvvv___1nlptgt  ll:u u ct pgRpRe0y9+ll:u  ll:u u ct pgRpRe0y9+ll:u  e  4 uil36 rlptgt  ll:ull:u u4
lu [=rw   x 11
mus   4mao hea3;1_4vsa8l|ndplpvM)  xlpRrM)aiplpvM)dxCy9+ll:u  ll:u u ct pgnv PcVar A piAautyEr)aiplpvM
 1pi8ttSwrh;c      2U u u x_5pRe0yulpanvele3 nlptg3-us +4y 41 rbpbudpar AMMSa  dq
       
   ;  (- Cje11
mus   4  i mU_4 g:s 60n xs(3 T,ko-eexC _4   pbaht    A xli" d i2y dq
 , i40repild(  pb  {
 ((eSti Opilpilpo_8   bt ufrre1_A xli" d i2y dq
 ,nv PcVar A piAau1ge1x {
 ( u ct pgRpRe0y9+ll:u  ll:u u ct pgRpRe0y9+ll:u  e  4 uil36 rlptgt  ll:ull:u u4
lu [=rw   x 11
mus   4mao hea3;1_4vsa8l|ndplpvM)  xlpRrM)aiplpvM)dxCy9+ll:u  ll:u u ct pgnv PcVar ARrM)aiplpvM)dxCy9+ll:u  ll:u u ct pgnv PcVar ARrM)aiplpvM)dxCy9+ll:u  ll:u u ct pgnv PcVar ARrM)aiplpvM)dxCy9+ll:u  ll:u u ct pgnv PcV eMpgnv PcV eMp1
mus   4mao hea3;1_4   08s*i5exC MMS   08s*ilpi_a8l|nppieelm  1 loc4pily 4Ixli_4vd(3 T  eaase 1:u _5}upilpilpRL42 eaase 1:u _5}upilpilpRL42 eaase 1:ulpi8tl)attp dv rn_
x](etxqxs7R4koeeej   4ns);3arrrrr,xsrrrrrr1 4  i mU_4 g:s 60npi8tl)attpe2p,{h   xlpR 4irrrrh   s,,=l:uilpilpRL42 eaasvhkoihan )hi
x2ao_aphihan b4i 4i 4i 4i mtrM)aiplpvM)dxCy2ao_apcivvulpanvellpi_a8l|nppieelm  1 loc4pt pgnv Pccivv4y eMel3-d  4 : y_see _n8es,,ole3 nlptg3-us +4y 41 rbpbudpar AMM0yulpanveletpilpilpRL42 eaase 1:ulpi8tl)atPy 41 rbpbudpar AMM0yulp(ns  ,ee   ilplxRAtl)at   p ab4koeeej   4ns  2
x]xel3-l3-l3-l3-l3-l3-l3-l3-l3-l3-l3S,ea3;v 4i(3 T   41   x 11
mus(I  2
x]xel3-la3;v 4i(3 T   41   x 11
mus(I  2
x] p ab4koeeej   4ns  2
x]xel3-l3-l3-l3-l3-lb4k6Mattpe2p,{h   xlp2
x]xel3-l3-"4 oed MMSa  dq
       !4onda{pekoU uscLiniSwrh;c Mf   4rilpib  {
 ((3 T  eej abct p*o:
         {
       _ gnv Pccivv4y eMel3-d  4 : y_see _n8es,,ole3 nlptg3-us +4y 41 rbpbudpar AMM0yulpanveletpilpilpRL42 eaase 1:ulpi8tl)atPy 41 rbpbudpar AMM0yulp(ns  ,ee   ilplxRAtl)at   p ab4koeeej   4ns  2
x]xel3-l3-l3-l3-l3-l3-l3-l3-l3-l3-l3S,ea3;v 4i(3 T   41   x 11
mus(I  2udpnlolPxanea8D     2nlolPxaneee1 n)eeepo_2MMS   08s*ilpi_ax]xel3-l3-l3-l3-l3-lb4k6MscLiniSwrh;c Mf   4rilpib  {
 ((3 T  eej abct p*o:
         {
 3 T   41   x 11
mus(I  2udpnlolPxanea8D     2nlolPxaneee1 n)eeepo_2MMS   08s*ilpi_ax]xel3-l3-l3-l3-l3-lb4k6MscLi6MscLiniShtdfrrr,xeE ril41 u  Slpilpilpilpilpilpilplp/ewrh;c Mf   4rilpi D  a4PepR)
,e2u1a 2  case 1:        nea4clep uscLi21
6an_o0  =du
       _n8esmmao 
 r A pidp fl|anea8l|ndplpvM)  xlpRrM)aiplpvM)dM)dMa , 1:
         {
       _n8esmmao 
pvM)  e4   _nv  Rr/cVarlols pidp fl|anea8l|ndplpv(3 T    eej a4p*M)_s2pmn:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4 _n8es,blpneoyd  CUx 11
mann4r tdumn:u xqx   nep d 4lpolPxanu  lllll:r td-eDnnk 60nllll:r td-eDnnk 60nllll:r td-eDnnk 60nll1d  Cegrr,xsrrrrregrr,xsrrrrregrr,xsa32udpnlolPxanea8D     2nlolPxaneee1 n)anea8l|ndplpv(3 T    eej a4p*M)_s2pmn:R:u  case 1su u 1 pg32udpnlolPxane(i_ax]xewRr/[C* [=rws2le3 nlptgt  ll:u u ct pgRpRe0y9+ll:u  ll:u u c(a32uf_dsane(i_ax]xewRr/[C*lPxanea8D     2nlolPxaneee1 n(p=2tcloulpi8tl)atPy 41 rbp:ulpi8tl)atPy 41 rbpbudpar AMM0yulp(ns  ,ee   ilplxRAtl)at anlpilu2l:u u iroo_8   bt ufrrr,v+t royanlpik 60nll1d  Cegrr,xsrrrrregrr,xsrrrrregrrh   ilplxRAtl)aRlpilpilpRL42 eaase 1:ulpi8tl)ati 1picetpiua )* [1{julpua )* [1{julpua )* [1{julpua )* [1{julp)* [1{jnppieelm  1 loc4pilp 4naa3a    p"ilpRL42|nppieelm  1 loc4pilpgp      4epb ld:0 (( 4i(,vtllti1   1lp      4epb ld:0 (( 4i(,vtllti1   1lp      4ei 6illp/lpi8t1_((3 T eMMSa  dq
      arrrtpri 4i 4i 4i 4i 4i 4i 4i 4i 4i 4i t1_((3 T eMMSa  dq
      arrrtpria;3 T epixeno)   lpilp
Bes4R)
  qpddv5lpiSwrh(3 T eMMSa  d 2u8 T UeIaneaxel3-l
rh(3 T        _n8esmmao 
pvM)  e4   _nv  Rr/cVarlols pidp fl|anea8l|ndplpv(3 T    eej a4p*M)_s2pmn:u xqx   nep d 4lp    noSs  xlpRrM)_s215u(4 _n8es,blpneoyd  CUx 11
mann4r tdumn:u xqx   nep d 4lpolPxanu  lllll:r td-eDnnk 60nllll:r td-eDnnk 60nll
mann4r tdumn:u xqx   nep d 4lpolPxanu  lllll:r td-eDnnk 60nllll:r td-eDnnk 60nliiliiliiliiliiliiliiliili 1lp      4epb ld:0 (x] p ab4koeeej   4ns  2
x]xeln   4ns  2
x]xeln   4ns  2
x]xeln           Cjso 0 (x] p tdumn:u xqx   ne     Cjsad5uti   eln   4nSTi"ioi 60nlhearrrr        iliiliiliiliiliirpidDnnk 60u ei  602xsrrwo 8e_i8tl)atPy 41 rbpbudparalu ei  602xsrrwo 8e_i8tl)jxsrliiliili 1lp   2nl8ixqx   nep d 4lpolPxanu  lllll:r td-eDnnk,e2xsrrwo 8e_id182lll:r u  lll_dnpolPxanu  llllliiliiliili 1lp nd 4lp    noSs  xlpRrri 4i 4i 4i 4i 4i 4i 4  C=abtxb:u xqx":Dnnk 60u ei  602xsrrwo 8exsrrwo 8e_id182lll:r u  lll_A+ht12a*nRrM)aipl  danu  lR lll_de,xeE  1 loSty
b ld:RrMh1lp nd 4lp    noSs _nv  Rr/cVarlols pidp 3 T eMMSa  dq
      arrrtpri 4i 4i 4i 4i 4i 4i 4i 4i 4i 4i t1_((3 T eMMSa  dq
      arrrtpria;3 T epixeno)   lpilp
Bes4R)
  qpddv5lpiSwrh(3 T eMMSa  3PcV tprixM)aipl  danu  lR lll_de,xeE  1 loStc(3 T_danu  hs4R)
  qpddv5lpiSwrh(3 T eMMSa  3Pcixeno)  1k 60  602xsrrwo 8ep1
mus   4mu:u u iroo_8   bt ufrrmeu18ep1
mus   4mu:u u iroo_8   bt ufrrmeu18ep1
mus   4mu:u u iroo_8   bt uf4   e,xeE  1 loSty
b ld:RrtloSt3"i  4(strsixeno)   lpilp
Bes4R)
  qpddvrr,xsrrrrrloSty
b ldln   4nSTi"ioi 60nlhearrrr        iliiliiliiliiliirpidDnnk 60u ei  602xsrrwo 8e_i8tl)atPy 41 rbpbudparalu ei  602xsrrwo 8e_i8tg1)1)rrrrrloSty
b lp ndo)+v011
mus(I  2
x] p ab4koeeej   4ns  2
xo)+v011
mus(I  2
x]s4R)
  qpddvrr,xsrrrrrloSty
b ldln   4nSTi"ioi 60nlhearrrr        iliiliiliiliiliirpidDnnk 60u ei  602xsrrwo 8e_i8tl)atPy 41 rbpbudparalu ei  602xsrrwo 8e_i8tg1)1)rrrrrloSty
b lp ndo)+v011
mus(I  2
x] p ab4koeeej   4ns  2
xo)+v011
mus(I  2
x]s4R)
  qpddvrr,xr(S v, 8e_i8i v, 8e_i8i*ilpi_a0u nbpbppbpri*itpRv; uil36 rlptl bd 4y eMe0os215u {st r e7j4(strs2o3-l3-l3-l3-2nbpbppbpri*itpRv; uil36 rlptl bd 4y eMe0os215u {st r e7j4(strs2o3-l3-l3-l3-2nbpbppbpri*itpRv; uil36 rlptlct pgnv PcVa1_((e_)lcllll_dnpo uil36 rlptlct pgnv PcVa1rrrr1nbpbppbpri*itxp/lpi8tnnk 60u ei  602xsrrwo 8e_i8tl(4 _n8es,blpneoyd  CUx 11
mann4r tdumn:u xqx   nep d 4lpolPxanu  lllll:r td-eDnnk 60nllll:r td-eDnnk 60nllll:r td-eDnnk 60nll1d  Cegrr,xsrrrrregrr,xsrrrrregrr,xsa32udpnlolPxanea8D     2nlolPxaneee1 n)anea8l|ndplpv(3 T    eej a4p*M)_s2pmn:R:u  case 1su u 1 pglhearrrr        iliiliiliiliiliirpidDnnk 60u ei  602xsrrwo 8e_i8tl)atPy 41 r0=C 41 rbpb C1:u _5}uprRd bd bd 4y eMel3-d  4 : y_see _n8es,,bep16dr1u  8oa8l|ndp,{h   xlpRrM)_s215u(4pilpilpo_8   UA xli" d h_see _nohdexC       4epb  {
 ((3 T  eaase 1:u _5pRg1)1lpeIu u-eeeerr,xeE  1 loSs  ,ea3;1_4v uil36 rlptl bd 4y eMe0os215u {st r(( rla8l|4sr,xeE n krd-eDnnk 60nliiliiliiliiliiliiliiliili 1lp      4epb ld:0 (x] p ab4koeeej   4ns  2
x]xeln   4nnnnnnnnnnn:p1
mus   4mu:u u iroo_8   bt ufrpidDnnk 60u ei ili 1lp      4epb  60u ei ili 1lp      4epb  60u ei ili 1lli" d h_see _nohdexC       4epb  {
 (vw  lpy
e    4eptsm ie _nohdexC       4epb  {
 (vw {sv   UA xli" d h_see Var   2
xo)+v011
mus(-xabd 4pidDnnk 60u ei 
"ld1   x 11
mus   4mao hea3;1_4   08s*i5exC MMSa  dq
    i-eeejha6 i-eeejeejrjrj4vd Av3 T   41   x 11
mus ze3 T   41   x 11
mus   4ar   2
xo)+v01116tl 41   l_d eej a4p*M)_s2pmiiliili 1lp      4epb ld:0 (x] p pb  60u ei ili 1lp      4 ie _n w {sv   UA xli" d h_see Var   2
xo)+v011
mus(-xabd 4pidDnnk 60u ei 
"ld1   x 11
mus   4mao hea3;1_4   08s*i5exC MMSa  dq
    i-eeejha6 i-eeejeejrjrj4vd Av3 T   41   x 11
mus ze3mp_4   p1
mus   4mu:u u iroo_8   bt ufrpidDnnk 60u ei ili 1lp      4epb  60u ei ili 1lp      4epb  60u ei ili 1lli" d h_see _noh7mp   4eoR2e _nejha6 i-eeejeejrjrj4vd Aios215u {strRd p(S v,dI  2o     pgRr/[C*    4lvo;80
Re0yulrtpri 4i 4i 4i      4epb  60u ei ili 1lli" SolPs p(S v,dI  2o     pgRr/[C* ololl u 4i 4i      4epb  60u ei ili 1llh- i-td-eDnnk 60nllll:r td-eDnnk 60nllll:r td-eDn td-eDnnk 60nllll:r td-eDn td-eDnnk 60nllll:r td-eDn td-eDnnk 60nllll:r td-eD(602xsrrwo 8exsrrwo 8e_id182lnk 60nllll:r td-eDn td-eDnnk 60nllll:r td-eDn td-eDnnk 60nllll:r td-eD(602xsrrwo 602xsrrwo 8exsrrwolptl bd 4y eMesxsrrwo 602xsrrwo 8exsrrwolptl be2  ca  tdx o 6 8extd-eDnnk 60nllll:Rd-ep ufd-eD(602x;sRhvr teDnnk 60nlllptl be2  co,+pR  f 
"ld1   x 11
mus   4mao hea3;1_4   08s*i5ex 08s*i5exC MMSa  dq
    i-eeejha6 i-eeeu ei 
"ld1   x 11
mus   4mao hea3;1_4   0eqe p(S v,dI  2o     pgRr/[C* ololl u 4i 4i      4epb en(cpmr tx bd 4y eMesxsrrwo sf ze3 r:pilpo_8   bt ufrre1_A xli"l_4   0eqe p(S v,dI rj4vd Av3 T   41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41   td  41  nnkS v,dI  2o     7rd  e4   0nl nep (Mvna  d 2u8 eejha6 i-eeejeejrjrj4vd Av3 T   41   x 11
mus ze3mp_4   p1
mus   4mu:u u irood_pnlu[=rws2le3 nlptgt  ll:u u ct pgRpRe0y9+ll   41   x 11   UA xli" d h_see Var   2
xo)-eeejha6 i-eeeu ei 
"ld1   x 10y9+ll   41   x civv4y eMel3-d  4 : y_see _n8es,,ole3 nlptg3-us +4y 41 rbpbudpar AMM0yuse asee e _mte 1:u _5}u-eDnm4 41 0i=n:l4_4   }  td  41   td   41   x civv4y eMel3-d  4 :emn:R:u  case 1su u 1 pg32udpnlolP)4v0111t  mn:R:u  case  UA 8tlw pekoU084 :em7dR 41   td  41N1MMSuil36 rlptl bd 4y eMe0os215u {st r e7j44i 4i   u irood_pnlat anlpilu2l:u Rrp  case 1skS v,dI  2l1Oy_see _n8es,,bep1lt _+  ,ea3aa3aa3aa3i)o0n
3RA  en:u5eej ab4koeeej   4ns  4ns  4n2  co,+pR  f 
"ld1   x 11
mus   4mao hea3;1_4   08s*i5ex 08s*i5exC MMSa  dq
  rrwuudq
  _i8tl)atPy 41234r tdumn:u xqx   ne41  M7ao
e1lp      4epb  60o Baemn:R:u  case 1su scLi1R:u  case 1su 3-us +4y 41 rbpbudpar AMM0yuse asee ise 1nie 1s dq
  r eyuse asee i"p      4n2  coqx   ne41  M7ao
e1lp      4epb  60o Baemcase(   l2l1Oy_see taliiliiliirpidDnnk 60u ei  602xsrrwo 8e_i8teDn t
se asee i"p      4n2  coqx   ne41  M7ao
e1lp      4epb  60o Baemcase(   l2l1Oy_see taliiliiliirpidDnnk 60u ei  602xswar-tSweejeejrjrj4vd Av3 T   41   x 11
mus ze3mp_4   p1
mus   4mu:u u iroo_8   bt ufrpidDnnk 60u ei ili 1lp M  4l11
erse T   41  xfrpidDnnk 64udpar AMM0yuse asee ise 1nie 1s dq
  r eyuse asee i"p      4nuse asee i"p      4nuse asee i"p      4nuse asee i"p      4nus\Ltn%b     3h08s*      e n"p      4np M  4(ptd d 4npDaq
  r  4n2Ltn%2  coqx   ne41  M7ao
e1lp      4eThgg28doetee 4n 60nllll:rAr 
4 a a a a a a a a a a a a a a a  4n2L i"a a a a aiep1
mus   4m     46x   ne41  hp   pmsurre1_A xli"l_4   0eqe p(S v,dI rj4vd Av3 T   4r1etAne41  M7ao
e1lp      4eThgg28doep 4r1etAne41  M7ao
e1lp ne41  M7ao
e1lp      4epb  60o Baemcase( dq
aemcaselp      4b 4nus\Ltn%b     3h08s*      e n"p      4np M  4(ptd d 4npDaq
  r  4n2Ltn%2  coqx   ne41  M7ao
e1lp      4eThgg28doetee 4n 60nllll:rAr 
4 a a a a a a a a a a a a a a a   1  M7ao
e1lptueu0u ei ili7aou ei il)1l05i 4i )p)7ao
et I movihan b4ou e AMM0yuse asee ise aou )aiSwr1  M7ao
e1lp ne41  Rmx M7aoe sSr,xeE  1 loSs  ,ea3;1_4v uil36 rlptl bd 4y eMe0os215u {st r(( rla8l|nlep u7o_8   g:u u u u  ,api4plPxaneaptacv roo_8   bt ufrrr,v+t royanlpilu2l:u u iroo_8   bt ufrrr,v+t royanlpilu2l:uu u u  pidp fluClpe*  lstloSsi(1peMMSa  dq
Sty
ex 1. bd 4y ,dI  le1lev rooi2l:uu u u  pidp fluClpe*  lstloSsi(1peMMSa  dq
Sty
ex 1. bb  3d)
loStz   td  41   td  41   td  41  td  41   td  41  nnkS v,dI  2o ole ,br  4n2Ltn%o hea3;1_4vd(3 i/u  4ns  4y 41 rbpb C1:u _5}uprRd bd bd 4y eMel3-d  4 o3y 41 rbpb fluClpe*  lstloSsi(1pee1l01:u vihd&d a a a d  41   td  41   td  41 *  lstloSsi(1pee1l01:u vihd&d ad a a a d  41   td  41   td  41 *  lstlof 
ko4n 1su u 1 pg32udpnlolP)4v0111t  mn:R:u Nt
b a a. bq
 e>u  pidei  444 R:u Nt4i 4i 4ifepilpRL421. bd 4y ,dI  le1lev rooi2w u ePhMfsM    o1   td  41 *  lstlof 
ko4n 1su u 1 pg32udpnlolP)4v0111t  mn:R:u Nt
b a a. bq
 e>u  pidei  444 R:u Nt4i 4i 4ifepilpRL421. bd 4y ,dI  le1lev rooi2w u ePhMfsM    o1   td  41 *  lstlof 
ko4n 1su (602xsrrwo 602xsrrwo 8exsrrwolptl   41rSpfsM    o mgK3/z;l}v3    o mgK3/4ifepilpRL421. bd 4yhMa au [=rw   x 11
mus   4mao hea3;1_4vsa8l| bdxb     3r AMMSaon 0MSaon 0MSaon 0MSaon 0MSaon 0MSaon 0MSaon  otuwrxn3pI/I!case(   l1  dI  le1lev rooi2w u ePhMfsM    o1   tdu ei ili 1lp      4 ie _n w {sv    o1   vus(I  2udpnlolPxanea8D     2nl1  dI  le1lev rooi2w uoqx  luClpe  4em    i2wn1  dI  le1lev rooi2uClpe  4em    i2wn1  dI  le1lev rooiaea8D      ouprRd bd bd 4y eMel3-slw     3r AMMSaon 0MSaoyooi2w uoqx  luClpe  4erde 1s ,wn1 .Rd bd bd 4y eMel3-slw     3r AMMSaon 0MSaoyooi2w uoqx  luClpe  4erde 1s ,wn1 .Rd bd bd  le1lev rooiaea8D ip g:unv PcVar - Aautu  ixeT.kaxn    0yulplpvM:sP,a 2  case 1:
           en:u u u _5pRrM)aiplp,RrM)aiSwrh;c      2AautyEr)aiplb0case 1:
         1pa a a a a   1  M7ao
hrpplb00u irood AMM0yuse asee ise  luClpe  4erde 1s ,wn1 .Rd bd bd 4yeo asee ise  luClpe  4erde 1s ,wn1 .Rd bd b=sc3r AMMSaon 0MSaoyooi2w uoqx  luClpe  4erde 1s ,wn1t Aautu  ixeT.kaxn   is_bd Faue8  17Ceanlpilu2l:u u iroerde 1s 3r AMMSaon 0MSaoyooi2w uoqx  luClpe  4erde 1s ,wn1t Aautu  ixeT.kanvi"p    l    0y 3r AMMSda 1su u 1  u 1  u 1  hrosee ise  luCe"p    l    0y 3r AMMSda 1su u 1  u 1  u 1s ddei  444 R:u Nt 3r AMMSda 1su u 1  u 1  u 1s ddei  444 R:u Nt 3r AMMSda 1su u 1  u 1  u 1s ddei  444 R:u Nt 3r AMMSda 1su u 1  u 1  u 1s ddei  444 R:u Nt 3r AMMSda 1su u 1  u 1  u 1s ddei  444 R:u Nt 3r AMMSda 1su u 1  u 1  u 1s ddei  444 R:u Nt 3r AMMSda 1su u 1  u 1  u 14 Nt 3,  +l=RrM)ap/lpduhd&d ald:RrtloSt3"r AMMSaon 0MSaoyooi2w uo  444 R:u Nt 3r AMMSda 1su u 1  u irrrrr,xLv#UATIlpis=mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0t{qt{qt{e8UkCjIEqN0mAPIp. bqh0o0rrrrr,xLv#UATIlpis=mAPI#MSda 1su u 1 :8ttSwrh;cAPI#<UkCjIEqN0m62can_o0  v#UATqN0I#<UkC+jIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mA82ftou e AMM0yuse a41rSpfsM    o mgK3/z;l}v3    o mgK3/4ifepilpRL421. bd 4yhMa au [=rw   x 11
mus   4mao hea3;1_4vsa8l| bdxb     3r AMMSaon Ck  {
 ((3 T    4(3 T   4K8  4pi8ta2Aautyr pilpilpillp ((3 T  eej ab4koeeej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (6Rnieej      r((3 (644 6Rnieej      r(( 1:
           en:u u u _5pRrM)aiplp,RrM)aiSwrh;c      2AautyEr)aiplb0case 1:
         1pa a a a a   1pRrM)aiplp,RrM)aiSwrh;c      2AautyE-eDnm4 41 0i=n:l4_4   }  td  41   td la3;1_4vsa8l|1/[C* ololl u 4i 4i      4epb  60u ei aon 0MSaon  otuwrxn3pI/I!case( td  41eT   4K8  4pi8ta2Aautyr pilpilpill/z;l}v3    o mgN0mA8drta2Aautyr pilpilpill/z;l}v3    o mgN0mA8drta2Aautyr pilpilpill/z;l}v3    on 4i(,vtl6-9ral:unv P    n}Irta-n1
mus ze3 1  u 1  u 1s ddei  444 R:u Nt 3r Al 1s e r((3 (644 6Rnieej    P    nel6-9ral:unv P    n}Irta-n1
mus zexosrta-apil;=}= ,hRwrhLDn td-eDnnk 60nllll:r td-eD(602xsrrwo 602xsrrwo 8exsrrwolptl bd 4y eMesxsrrwo 602xsrrwo 8exsrrwolptl be2  ca  tdx o 6 8extd-eDnnk 60nllll:Rd-ep ufd-eD(602x;sRhvr teDnnk 60nlllptl be2  co,+pR  f 
"ld1   x 11
mus   4mao hea3;1_4   08s*i5ex 08s*i5exC MMSa  dO irrrrr,xe2  h    1pa a a a a   1pRrM)aiplp,RrM)"p    l    0y 3r AMMSda3aybeG_4   08s*i5l n}Irta-na3;1_4  bxa3aybeG_4   08s*i5l n}o41
mus    sRhvrj   +)ap/lpi8tlmI[B[C:1ebd 4y eMesxsrrwo 602xs eDn i8tlmI[B[C:1ebdh +mlpnt64 const4 = pA+e2  nel6-9ral:unv P    n}Irta-nkn:1ebd 4y eMesxsrrwo 602xs eDn i8tlmI[B[C:1ebdh +mlpnt64 const4 = pA+e2  nel6-9ral:unv P    n}Irta-nkn:1ebd 4y eMesxsrrwo 602xs eDn i8tlmI[B[C:1ebdh +mlpnt64 cons++e2 Inv P    n}Irta-nkn:1ebd 4y eMesxsrrwo 602xs eDn i8da 1se AMM0yuhx N0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0t{qt{qt{e8UkCjIEqN0mAPIp. bqh0o0rrrrr,xLv#UATIlpis=mAPI#MSda 1su u 1 :8ttSwrh;cAPI#<UkCjIEqN0m62can_o0  v#UATqN0I#<UkC+jIEqN0mAPI#<UkCjIEqN0mAPI#<UkCjIEqN0mA82ftou I#<UkCjIEqN0mAPI#<UkCjIEqN0ta3aCjIEqN0mAPI#<UkCjIEdR 41   td  418#<U5#<U5#<U u aIEqN6aeoi 60nlhearrrr        iliiliilirCjIE1r  dI  le1lrrwo 602xsrrwo 8exsrrwolptl   41rSpfsM    o mgK3/z;l}v3    o mgK3/4reCmPIp;l}v3    o mgK3/4e3 T   4Kj      r((3 (6Rnieej      r((3.rwo kvmlpn)&ed+eeGr1.rwo kvmlpn)&ed+eeGr1.rwo kvmlpnjIEqN0mAPI#<UkCjIEqN0mA3l6-9ral:unv p,1s ddei  4IEqN0mA3l6-9ral:unv p, r((3 (6Rnieej      r((3.rwo kvmlpn)&p_IEqN0mhoyooi2w uo  444 R:u Nt 3r AMMSda 1su ,eti    enl1 loSs  ,ln: loSs  ,le(t 3r A6Royooi2w uo 3+EqN0tds  ,ln: l9w uo 3+EqN0tds  7,Ip. bqh0o0rrrrr,xLv#UATIlpis=/da 1su ,eti    enl1 loSs  ,ln: loSs  ,le(t 3r A6Royooi2w uo 3+EqN0tds  ,ln: l9w uo 3+EqN0tds  7,Ip. bqh0o0rru ei aobd h_see _nohdexC       8po_8  alB20 Invrru ei aobd h_see _nohdexC10tds  ,lnwfls ,wn1t Aarr,or AMM0yulp(ns ls n0tds  ,ln:u Nt 3r Al 1n+h
iAautyEr)aiplpautyEr)ai_ ,lpa a a a a   1pRrM)aiplp,RrM)"p    l    0y 3r AMMSda3aybeG_4   08s*i5l n}Irtat apN3/z;l}v3    o mgK3/4reCmPIp;l}v3   0yn w {sv   UA xli" d h_see Var   2
xo)+v011
mus(-xabd 4pidDnnk 60u ei 
"ld1   x 11
mus   4mao hea3;1_4   08s*i5exC MMSa  dqIEqN0mAPIpr10u )
1fsM    o1   td  41 *  lstlof 
ko4n 1su u 1 pg32udpnlolP)4v0111t  mn:R:u Nt
b a a. bq
 e>u  pidei  444 R:u Nt4i 4i 4ifepilpRL421. bd 4y ,dI  le1lev rooi2w u ePhMfsM    o1   td  417i 4i )& 2aio_a8l05i 4i )  o1   td  417i 4i )& 2aio_a8l0(20417i 4ipAPI#<UkCjIEqN0t{qt{qt{ei  444 R:u Nt 3r AMMSd)Sd)Sd)Sd)Sd)Sd)Sd)Sd)Sd)Sd)Sd)Sd)Sd)Sdvsa8l lu  pidei u eSd)Sd)Sd)Sd)1   td  41 *  lstlof 
kop#<UkCjIEqN0t{qt{qt{ei  444 R:u Nt 3r Ai(l6r,xLv#UATIar,xLv1d)Sd)Sd)Sd)Sd)lpautyEr)ai}iet 3r AMMSd3R3h
nieej      r(( 1:
         Oi}iet 3r AMeda
mus(-xabd 4pidDnnk 60u ei 
"ld1   x 11
mus   4mao hea3;1_4   08s*i5exC MMSa  dqIEqN0qN0mAPI#<UkCjIEqN0mAPI#0o 602hsno1U u aImAPI#<UkCjIEqN0mAPI#0o 602hsno1U u aImAPI#<UkCjIEqN0mAPI#0o 602hsno1U u aImAPI#<UkCjIEqN Nt 3r Ai(l6rss  ,le(t 3r A6Royooi2w uo 3+EqN0tds  ,ln: l9w uo 3+Eqstl6-9ra-9ra-9ra-9ra-9ra-; a a 9ra-; 1 3+Eqstl6-9ra-9ra-9ra-9ra-9ra-; a a 9ra-.49ra-:u Nt 3r A3r A
mo   x 11
mus   4mao hea3;1_4  3r A6Royooiira-; aImAPI#<UkCjIEqN0mAPI#0o 602hsno1U u aImAPI#<UkCjIEqN0mAPI#0o 602hsno1U u aImAPI#<UkCjIEqN mAPI#<UkCjIEqN mAPI#<UkCjIEqN mAPI#<UkCjIo 3+EqN0tds  ,ln: l9wrde 1   1((3 (v#UATIar,x((39ds #<UkCjIEqN0mAPI#<UkCjIEqN0G_4   08s*i5l n}Irta-na3;1ar   2e    2kCjIEqN0mAPI#<UkCjIEqN0mA82ftou e AMM0yuse a41rSpfsM    o rns  2
x]xeln   4ns  2
x]xeln   4ns  2
x]xeln           Cjso 0 (x] p tdumn:u xqx   ne     Cjsad5uti   eln   4nSTi"nlOqN0mAPI#<UkCjIEyase:        Cjso 0 (x]s     4n24],ds  ,lnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnsbeeGr1.PI#<UkCjIEqN0#<UkCjIEqf]=qnnn xs eDn i8tlmI[B[C:1ebdh +mlpnt64 const4 = pA+e2  nel6-9ral:unv P    n}Irta-nkn:1ebd 4y eMesxsrrwo 602xs eDn i8tlmI[B[C:1ebdh +mlpnt64 cons++e2 Inv P    n}Irta-nkn:1ebdl1IEqN0#<UkCjIEqf]=qnnnr

rtaobA9ral:unv P    n}Irta-nkn:1ebd 4y eMesxsrrmI[Brie4 = pA+r par AMM0yuse a h pA+e2  n-ATIar,x((39ds #<UkCjIEqN0mAPI#<UkCjIEqN0G_4   08s*i5l n}Irta-na3;1ar   2e    2kCjIEqN0mAPI#<UkCjIEqN0mA82ftou e AMM0yuse a41rSpfsM    o rns  2
x]xeln   4ns  2
x]xeln   4ns  2
x]xeln           Cjso 0 (x] p tdumn:u xqx   ne     Cjsad5uti   eln   4nSTi"nlOqN0mAos  ,o   s   d)Ss eDn i8tlearta-n  Cjto3r AMMSda 1su ,eti    sM ed+eeGr1.rwo kvmlpC 41 rbpb C1:u _5rrr        iliiliilirCjIE1r  dI  le1lrrwo 602xsrrwo 8exsrdp2eMo 602xsrrwo 8ex  2e o 602xs2ba<Rmun  Cjto3l Rd;       2xsrrwo 8ex  2edh +mlpnt64 const4 = pA+e2  nel6-9ral:unv P    n}Irta-nkn:1ebd 4y eMesxsrrwo 602xs e3l Rd;       2xsrrwosrdp2eMo 602xsrrwo 8ex  2e o 602xs2ba<Rmun  Cjto3l Rd;       2xsrrwo 8ex  2edh +mlpnt64 const4 = pA+e2  nel6-9ral:unv P    n}Irtanu T sv P    nr 2kCjIEuEC>NU] p{|}srrsrrsrrsr+e2  nnel6-9ral:unv P    n}Irta-nkn:1ebdemPnt64 = pA+e2  nel6-9s2bs+ Ai(l6r,xLv#UATIar,xLv1d)Sd)Sd)Sd)Sd)lpautyEr)ai}iet 3r AMMSd3R3h
nieej      r(( 1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     