/* ----------------------------------------------------------------------- *
 *
 *   Copyright 2006 Erwan Velu - All Rights Reserved
 *
 *   Permission is hereby granted, free of charge, to any person
 *   obtaining a copy of this software and associated documentation
 *   files (the "Software"), to deal in the Software without
 *   restriction, including without limitation the rights to use,
 *   copy, modify, merge, publish, distribute, sublicense, and/or
 *   sell copies of the Software, and to permit persons to whom
 *   the Software is furnished to do so, subject to the following
 *   conditions:
 *
 *   The above copyright notice and this permission notice shall
 *   be included in all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 *   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 *   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 *   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *   OTHER DEALINGS IN THE SOFTWARE.
 *
 * -----------------------------------------------------------------------
*/

#include <stdio.h>
#include <string.h>
#include "dmi/dmi.h"

const char *out_of_spec = "<OUT OF SPEC>";
const char *bad_index = "<BAD INDEX>";

/*
 * Misc. util stuff
 */

/*
 * 3.3.11 On Board Devices Information (Type 10)
 */

static const char *dmi_on_board_devices_type(uint8_t code)
{
    /* 3.3.11.1 */
    static const char *type[] = {
	"Other",		/* 0x01 */
	"Unknown",
	"Video",
	"SCSI Controller",
	"Ethernet",
	"Token Ring",
	"Sound",
	"PATA Controller",
	"SATA Controller",
	"SAS Controller"	/* 0x0A */
    };

    if (code >= 0x01 && code <= 0x0A)
	return type[code - 0x01];
    return out_of_spec;
}

static void dmi_on_board_devices(struct dmi_header *h, s_dmi * dmi)
{
    uint8_t *p = h->data + 4;
    uint8_t count = (h->length - 0x04) / 2;
    unsigned int i;

    for (i = 0;
	 i < count
	 && i <
	 sizeof dmi->base_board.devices_information /
	 sizeof *dmi->base_board.devices_information; i++) {
	strlcpy(dmi->base_board.devices_information[i].type,
		dmi_on_board_devices_type(p[2 * i] & 0x7F),
		sizeof dmi->base_board.devices_information[i].type);
	dmi->base_board.devices_information[i].status = p[2 * i] & 0x80;
	strlcpy(dmi->base_board.devices_information[i].description,
		dmi_string(h, p[2 * i + 1]),
		sizeof dmi->base_board.devices_information[i].description);
    }
}

/*
 * 3.3.24 System Reset (Type 23)
 */

static const char *dmi_system_reset_boot_option(uint8_t code)
{
    static const char *option[] = {
	"Operating System",	/* 0x1 */
	"System Utilities",
	"Do Not Reboot"		/* 0x3 */
    };

    if (code >= 0x1)
	return option[code - 0x1];
    return out_of_spec;
}

static void dmi_system_reset_count(uint16_t code, char *array)
{
    if (code == 0xFFFF)
	strlcpy(array, "Unknown", sizeof array);
    else
	snprintf(array, sizeof array, "%u", code);
}

static void dmi_system_reset_timer(uint16_t code, char *array)
{
    if (code == 0xFFFF)
	strlcpy(array, "Unknown", sizeof array);
    else
	snprintf(array, sizeof array, "%u min", code);
}

/*
 * 3.3.25 Hardware Security (Type 24)
 */

static const char *dmi_hardware_security_status(uint8_t code)
{
    static const char *status[] = {
	"Disabled",		/* 0x00 */
	"Enabled",
	"Not Implemented",
	"Unknown"		/* 0x03 */
    };

    return status[code];
}

/*
 * 3.3.12 OEM Strings (Type 11)
 */

static void dmi_oem_strings(struct dmi_header *h, const char *prefix,
			    s_dmi * dmi)
{
    uint8_t *p = h->data + 4;
    uint8_t count = p[0x00];
    int i;

    for (i = 1; i <= count; i++)
	snprintf(dmi->oem_strings, OEM_STRINGS_SIZE, "%s %s %s\n",
		 dmi->oem_strings, prefix, dmi_string(h, i));
}

/*
 * 3.3.13 System Configuration Options (Type 12)
 */
static void dmi_system_configuration_options(struct dmi_header *h,
					     const char *prefix, s_dmi * dmi)
{
    uint8_t *p = h->data + 4;
    uint8_t count = p[0x00];
    int i;

    for (i = 1; i <= count; i++)
	snprintf(dmi->system.configuration_options,
		 SYSTEM_CONFIGURATION_OPTIONS_SIZE, "%s %s %s\n",
		 dmi->system.configuration_options, prefix, dmi_string(h, i));
}

static void dmi_system_boot_status(uint8_t code, char *array)
{
    static const char *status[] = {
	"No errors detected",	/* 0 */
	"No bootable media",
	"Operating system failed to load",
	"Firmware-detected hardware failure",
	"Operating system-detected hardware failure",
	"User-requested boot",
	"System security violation",
	"Previously-requested image",
	"System watchdog timer expired"	/* 8 */
    };

    if (code <= 8)
	strlcpy(array,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                