#-*- coding: utf-8 -*-

# Copyright 2008-2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os
import sys
from os import path
from calculate.lib.datavars import (Variable,VariableError,ReadonlyVariable,
                                    ActionVariable)

from calculate.lib.cl_lang import setLocalTranslate
setLocalTranslate('cl_client3',sys.modules[__name__])

class VariableAcClientMerge(ActionVariable):
    """
    Action variable which has value "up" for package install and
    install this package
    """
    nonchroot = True

    def action(self,cl_action):
        if cl_action in ("merge","domain","undomain"):
            ret = "on"
        return "off"

class VariableAcClientDomain(ActionVariable):
    """
    Action variable which has value "on" for domain action
    """
    nonchroot = True

    def action(self,cl_action):
        remoteHost = self.Get("cl_remote_host")
        remoteAuth = self.Get("os_remote_auth")
        if cl_action == "domain":
            return "on"
        elif cl_action == "merge" and \
            remoteHost and remoteAuth:
            return "on"
        return "off"

class VariableAcClientUndomain(ActionVariable):
    """
    Action variable which has value "on" for undomain action
    """
    nonchroot = True

    def action(self,cl_action):
        remoteHost = self.Get("cl_remote_host")
        remoteAuth = self.Get("os_remote_auth")
        if cl_action in ("undomain",):
            return "on"
        elif cl_action in ("merge",) and \
             (not remoteHost or not remoteAuth):
            return "on"
        return "off"
