#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# setup.py --- Setup script for calculate-desktop

# Copyright 2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

__app__ = "calculate-client"
__version__ = "3.2.0_alpha1"

from distutils.core import setup, Extension
from calculate.install_data import install_data

data_files = [('/etc/init.d', [('data/client',0755)]),
              ('/usr/share/calculate/xdm/login.d',
                            ['data/login.d/10client']),
              ('/usr/share/calculate/xdm/logout.d',
                            ['data/logout.d/10client']),
              ('/usr/share/calculate/xdm/',[('data/wait_domain',0755)])]

setup(
    name = __app__,
    version = __version__,
    description = "Mounting resources and synchronize the user profile",
    author = "Calculate Ltd.",
    author_email = "support@calculate.ru",
    url = "http://calculate-linux.org",
    license = "http://www.apache.org/licenses/LICENSE-2.0",
    package_dir = {'calculate.client': "client"},
    packages = ['calculate.client','calculate.client.utils',
                'calculate.client.variables'],
    data_files = data_files,
    cmdclass={'install_data': install_data})
