#!/usr/bin/python
#-*- coding: utf-8 -*-

# Copyright 2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from PySide import QtGui, QtCore
import urllib2, sudsds

from calculate.core.client.function import switch, create_obj

from more import get_sid, ClientServiceThread, show_msg, TaskWidget, ErrorWgt,\
                 ResultLayout, get_view_params
from more import LabelWordWrap as Label
from SelectTable import SelectedTableWidget

class LabelWordWrap(Label):
    def __init__(self, name, parent = None):
        Label.__init__(self, name, parent)
        # set text selectable
        self.setTextInteractionFlags(self.textInteractionFlags() | \
                                     QtCore.Qt.TextSelectableByMouse)

class PlusButton(QtGui.QPushButton):
    def __init__(self, parent, ClientObj, method):
        QtGui.QPushButton.__init__(self, parent)
        try:
            self.setIcon(QtGui.QIcon.fromTheme('list-add'))
        except:
            self.setText('+')
        self._parent = parent
        self.ClientObj = ClientObj
        self.method = method
        self.setFixedWidth(30)
        self.clicked.connect(self.call_method)

    def call_method(self):
        # Call server method
        if hasattr (self, 'get_Frame_thread'):
            if self.get_Frame_thread.isRunning():
                return 1
        sid = int(self.ClientObj.sid)
        view_params = get_view_params(self.ClientObj.client, \
                           self.method + '_view')
        self.get_Frame_thread = ClientServiceThread(self.ClientObj,\
                                self.method + '_view', sid, view_params)
        self.get_Frame_thread.signal.connect(self.after_call)
        self.get_Frame_thread.start()

    def after_call(self, view):
        if self.ClientObj.method_names.has_key(self.method):
            view_method = self._parent.ClientObj.method_names \
                                                    [self.method]
        else:
            view_method = self.method
        self._parent.ClientObj._parent.setWindowTitle(view_method + \
                    ' - ' + self.ClientObj.Name)
        self._parent._parent.main_frame_view(view, self.method)

class MainFrameRes(QtGui.QWidget):
    valSignal = QtCore.Signal()
    def __init__(self, parent, ClientObj, method_name, meth_result, \
                 change_offset = False):
#        super(MainFrameRes, self).__init__(self, parent)
        QtGui.QWidget.__init__(self, parent)
        self._parent = parent
        self.ClientObj = ClientObj
        self.method_name = method_name
        self.meth_result = meth_result
        self.client = ClientObj.client
        self.cur_pid = 0
        self.change_offset = change_offset

        if self.meth_result.type == "pid":
            self.cur_pid = self.meth_result.message

        self.work_layout = ResultLayout(self)
        self.work_layout.kill_process_button.clicked.connect \
                                            (self.kill_process(self.cur_pid))
        self.valSignal.connect(ClientObj.MainWidget.setScrollBarVal)

        self.progress_list = []
        self.task_list = []

        self._parent.methodname_wgt.show()
        self._parent.control_button.show()
        self._parent.control_button.del_button()
        if self.ClientObj.method_names.has_key(self.method_name):
            self._parent.methodname_wgt.setMethodName \
                    (self.ClientObj.method_names[self.method_name])
        else:
            self._parent.methodname_wgt.setMethodName(method_name)
        parent.main_frame.viewport().setObjectName('main_frame')
        parent.main_frame.viewport().setStyleSheet("#main_frame "
                                            "{background-color: #E4E1E0;}")
        self.setObjectName('Frame_Res')
        self.setStyleSheet("#Frame_Res {background-color: transparent;}")
#                           "QWidget {border: 1px solid red;}")

    def initUI(self):
        self.updateGeometry()

################# API FUNCTION ###############################
    def show_view(self, view):
        pass

    def show_table(self, table, item):
        # method to display tables
        add_offset_flag = False

        if not table.body:
            table.body = [[]]
        self.show_normal(item)

        if self.method_name in self.ClientObj.param_objects:
            if len(table.body[0]) >= self.ClientObj.count_row_res_table or \
                    self.ClientObj.param_objects[self.method_name]['offset']:

                if table.onClick:
                    self.add_offset_buttons(len(table.body[0]),table.addAction)
                    add_offset_flag = True

        if table.addAction and not add_offset_flag:
            self.work_layout._addWidget(PlusButton(self, self.ClientObj, \
                                        table.addAction))
        if table.onClick:
            self.mytable = SelectedTableWidget(len(table.body[0]), \
                                               len(table.head[0]), self)

        if not hasattr (self, 'mytable'):
            if table.body:
                len_body = len(table.body[0])
            else:
                len_body = 1
            if table.head:
                len_head = len(table.head[0])
            else:
                len_head = 1
            self.mytable = SelectedTableWidget(len_body, len_head, self,
                                                   readonly = True)
        list_head = table.head[0]
        self.mytable.setHorizontalHeaderLabels(list_head)
        for line in range(len(table.body[0])):
            for i in range(len(table.body[0][line][0])):
                tablewidgetitem = QtGui.QTableWidgetItem \
                                                    (table.body[0][line][0][i])
                self.mytable.setItem(line, i, tablewidgetitem)
#         set writeonly
        self.mytable.setEditTriggers(QtGui.QAbstractItemView.NoEditTriggers)

        if table.onClick:
            self.mytable.itemClicked.connect(self.row_activate(table))

        self.mytable.setColor()
        minimum = QtGui.QSizePolicy.Minimum
        self.mytable.setSizePolicy(minimum, minimum)
        self.mytable.verticalHeader().hide()
        self.mytable.horizontalHeader().resizeSections \
                                (QtGui.QHeaderView.ResizeMode.ResizeToContents)
        self.work_layout._addWidget(self.mytable)
        self.ClientObj.app.processEvents()

        self.initUI()

    def row_activate(self, table):
        def wrapper(item):
            param_object = create_obj(self.client, table.onClick)
            for field in table.fields.string:
                if field:
                    if hasattr (param_object, field):
                        param_object[field] = self.mytable.item(item.row(),0).\
                                              text()
            # Calling method
            sid = int(self.ClientObj.sid)
            self.client.service[0][table.onClick](sid, param_object)

            # Calling View
            try:
                view_params = get_view_params(self.client, \
                                       table.onClick + '_view', step = 0)
                view = self.client.service[0][table.onClick + '_view'] \
                                    (sid, view_params)
            except sudsds.MethodNotFound, e:
                _print(e)
                return
            if self._parent.ClientObj.method_names.has_key(table.onClick):
                view_method = self._parent.ClientObj.method_names \
                                                        [table.onClick]
            else:
                view_method = table.onClick
            self._parent.ClientObj._parent.setWindowTitle(view_method + \
                        ' - ' + self.ClientObj.Name)
            self.ClientObj.param_objects[self.method_name]['offset'] = 0
            self._parent.main_frame_view(view, table.onClick)
        return wrapper

    def add_offset_buttons(self, len_body, addAction):
        offset_buttons = QtGui.QWidget()
        layout = QtGui.QHBoxLayout(offset_buttons)
        layout.setAlignment(QtCore.Qt.AlignLeft)

        minus_offset = QtGui.QPushButton(offset_buttons)
        minus_offset.setIcon(QtGui.QIcon.fromTheme('go-previous'))
        minus_offset.setToolTip('Previous page')
        minus_offset.clicked.connect(self.call_method_with_offset \
                    (-1*int(self.ClientObj.count_row_res_table)))
        minus_offset.setFixedWidth(30)

        if not self.ClientObj.param_objects[self.method_name]['offset']:
            minus_offset.setDisabled(True)

        layout.addWidget(minus_offset)

        plus_offset = QtGui.QPushButton(offset_buttons)
        plus_offset.setIcon(QtGui.QIcon.fromTheme('go-next'))
        plus_offset.setToolTip('Next page')
        plus_offset.clicked.connect(self.call_method_with_offset \
                                    (int(self.ClientObj.count_row_res_table)))
        plus_offset.setFixedWidth(30)        

        if len_body < self.ClientObj.count_row_res_table:
            plus_offset.setDisabled(True)
        layout.addWidget(plus_offset)
        if addAction:
            layout.addWidget(PlusButton(self, self.ClientObj, addAction))

        self.work_layout._addWidget(offset_buttons)

    def call_method_with_offset(self, offset):
        def wrapper():
            self.ClientObj.param_objects[self.method_name]['offset'] += offset
            if self.ClientObj.param_objects[self.method_name]['offset'] < 0:
                self.ClientObj.param_objects[self.method_name]['offset'] = 0

            # Calling View
            sid = int(self.ClientObj.sid)
            try:
                view_params = get_view_params(self.client, \
                                       self.method_name + '_view', step = 0)
                view = self.client.service[0][self.method_name + '_view'] \
                                                    (sid, view_params)
            except sudsds.MethodNotFound:
                return
            if self._parent.ClientObj.method_names.has_key(self.method_name):
                view_method = self._parent.ClientObj.method_names \
                                                        [self.method_name]
            else:
                view_method = self.method_name
            self._parent.ClientObj._parent.setWindowTitle(view_method + \
                        ' - ' + self.ClientObj.Name)
            self._parent.main_frame_view(view, view_method, \
                                         change_offset = True)
        return wrapper

    def show_normal(self, item):
        if not hasattr (item, 'message'):
            return
        if item.message:
            # add normal message label
            lbl_temp = LabelWordWrap(item.message, self)

            lbl_temp.setMinimumHeight(lbl_temp.sizeHint().height())
            self.work_layout._addWidget(lbl_temp)
            self.initUI()

    def show_error(self, message):
        # add error message label
        self.set_result_task(True)
        if self.progress_list:
            self.progress_list[len(self.progress_list)-1].hide()
        if message:
            lbl_temp = ErrorWgt(message, self)
            lbl_temp.set_error()
            lbl_temp.setMinimumHeight(lbl_temp.sizeHint().height())
            self.work_layout._addWidget(lbl_temp)

        self.initUI()

    def show_warning(self, item):
        # add warning message label
        if item.message:
            lbl_temp = ErrorWgt(item.message, self)
            lbl_temp.set_warning()
            self.work_layout._addWidget(lbl_temp)
        self.initUI()
        
    def show_group(self, item):
        pass
    
    def show_result(self, result):
        # add normal message label
        lbl_temp = LabelWordWrap(result.message, self)

        lbl_temp.setMinimumHeight(lbl_temp.sizeHint().height())
        self.work_layout._addWidget(lbl_temp)
        
        self.initUI()
        
    def startTask(self, item):
        if self.progress_list:
            self.progress_list[len(self.progress_list)-1].hide()
        task_widget = TaskWidget(item.message, self)

        self.task_list.append(task_widget)
        self.work_layout._addWidget(task_widget)
        self.initUI()

    def endTask(self, item, set_res = True):
        if set_res:
            self.set_result_task()
        message = item.message if item.message else ''
        if message:
            lbl_temp = LabelWordWrap(message, self)

            lbl_temp.setMinimumHeight(lbl_temp.sizeHint().height())
            self.work_layout._addWidget(lbl_temp)
        self.initUI()

    def set_result_task(self, error = False):
        if not len(self.task_list):
            return
        if error:
            self.task_list[len(self.task_list) - 1].set_error()
        else:
            self.task_list[len(self.task_list) - 1].set_ok()

    def beginFrame(self, item):
        pass

    def endFrame(self, item):
        if self.progress_list:
            self.progress_list[len(self.progress_list)-1].hide()
        self.endTask(item)

        self.initUI()
        self.work_layout.hide_kill_button()
        self.close_all_thread()
        if self.change_offset:
            self._parent.delete_MainFrameWgt()
            self._parent.MainFrameWgt = self
            self._parent.main_frame.setWidget (self._parent.MainFrameWgt)
            self._parent.main_frame.setWidgetResizable(True)
            self._parent.methodname_wgt.show()
            self._parent.control_button.show()
            self._parent.control_button.add_clear_cache_button(self.cur_pid)
            self.initUI()
            return 0

        if hasattr (self, "mytable"):
            if not self.mytable.readonly:
                self.initUI()
                return 0

        self._parent.control_button.add_clear_cache_button(self.cur_pid)
        self.initUI()

#    def clear_pid_cache(self):
#        self.clear_proc_cache_button.setDisabled(True)
#        sid = int(self.ClientObj.sid)
#        res = self.client.service.clear_pid_cache(sid, self.cur_pid)
#        if res:
#            _print (_('Error closing the process'))
#        self._parent.back()

    def startGroup(self, item):
        pass

    def endGroup(self, item):
        pass

    def callView(self, item, sid):
        return 0

    def kill_process(self, pid):
        def wrapper():
            sid = int(self.ClientObj.sid)

            # Call server method
            if hasattr (self, 'kill_process_thread'):
                if self.kill_process_thread.isRunning():
                    return 1
            self.kill_process_thread = ClientServiceThread(self.ClientObj,\
                                    'pid_kill', pid, sid)
            self.kill_process_thread.signal.connect(self.kill_process_after)
            self.kill_process_thread.start()
        return wrapper

    def kill_process_after(self, result):
        if result in [0,2]:
            return 0
        elif result == -1:
            msg = _("Certificate not found in the server!")
        elif result == -2:
            msg = _("Session not matching your certificate!")
        elif result == 1:
            msg = _("Failed to kill the process!")
        else:
            msg = 'error'

        show_msg(msg)

###############################################################################

    def analysis(self, meth_result):
            """ analysis of the bounced message method """
    #    for mess in meth_result:
            self.ClientObj.app.processEvents()
            mess = meth_result
            if mess.type == 'pid':
                self.get_messages(self.ClientObj.sid, mess.message)
            if mess.type == 'error':
                try:
                    self.show_error(self, mess.message)
                except:
                    pass
            if mess.type == 'warning':
                try:
                    self.show_warning(self, mess)
                except:
                    pass

    def get_message(self, item, sid, pid):
        try:
            if self.cur_pid != pid:
                return 1
        except:
            return 1
        """ get one message by its type """
        for case in switch(item.type):
            if case('normal'):
                 self.show_normal(item)
                 return 1
            if case('plain'):
                 self.show_normal(item)
                 return 1
            if case('progress'):
                 self.get_Progress(sid, pid, item.id)
                 return 1
            if case('error'):
    #            for i in range(20):
                self.show_error(item.message)
                if item.message == "403 Forbidden":
    #             show_msg(item.message, 'Access Denied')
                    return 0
                return 1
            if case('warning'):
                self.show_warning(item)
                return 1
            if case('table'):
                self.get_Table(sid, pid, item)
                return 1
            if case('group'):
                self.show_group(sid, pid, item)
                return 1
            if case('question'):
                self.send_Message(sid, pid, item)
                return 1
            if case('password'):
                self.send_Password(sid, pid, item)
                return 1
            if case('startTask'):
                self.startTask(item)
                return 1
            if case('taskNumber'):
#                self.startTask(item)
                return 1
            if case('endTask'):
                self.endTask(item)
                return 1
            if case('beginFrame'):
                self.beginFrame(item)
                return 1
            if case('endFrame'):
                self.endFrame(item)
                self.resize(self.sizeHint())
                return 0
            if case('startGroup'):
                self.startGroup(item)
                return 1
            if case('endGroup'):
                self.endGroup(item)
                return 1
            if case('briefParams'):
                self.callView(item, sid)
            if case(): # default, could also just omit condition or 'if True'
                return 1

    def get_messages(self, sid, pid):
        """ get frame in a separate thread """
        #thread_messages = threading.Thread(target=get_Frame,\
                        #args = (client, sid, pid))
        #thread_messages.start()
        self.get_Frame(sid, pid)
    
    def get_Frame(self, sid, pid, def_end_frame = 1):
        """ get all messages, until type is not endFrame (or Error) """
        self.not_end_frame = def_end_frame
        
        if self.not_end_frame:
            # Call server method
            if hasattr (self, 'get_Frame_thread'):
                if self.get_Frame_thread.isRunning():
                    self.get_Frame_thread.wait()
            self.get_Frame_thread = ClientServiceThread(self.ClientObj,\
                           'get_frame', sid, pid, return_except = True, \
                           through_object = (sid, pid))
            self.get_Frame_thread.signal_extended.connect(self.get_Frame_cycle)
            self.get_Frame_thread.start()
            
    def get_Frame_cycle(self, current_frame, through_object):
        if type(current_frame) == Exception:
            _print (_("Failed to get a frame from the server."))
            show_msg(_("Failed to get a frame from the server.") +'\n'+ \
                     _('Try resfeshing this page later.'),'get frame error')
            return 1
        sid, pid = through_object
        if current_frame in [None, [], ""]:
            try:
                if  self.cur_pid != pid:
                    return 1
            except:
                return 1
        else:
            self.get_Frame_after(current_frame, sid, pid)
        if self.not_end_frame:
            # Call server method
            if hasattr (self, 'get_Frame_thread'):
                if self.get_Frame_thread.isRunning():
                    self.get_Frame_thread.wait()
            self.get_Frame_thread = ClientServiceThread(self.ClientObj,\
                          'get_frame', sid, pid, return_except = True, \
                          sleeptime = int(self.ClientObj.client.frame_period),\
                          through_object = (sid, pid))
            self.get_Frame_thread.signal_extended.connect(self.get_Frame_cycle)
            self.get_Frame_thread.start()

    def get_Frame_after(self, current_frame, sid, pid):
            for item in range(len(current_frame[0])):
                self.not_end_frame = self.get_message(current_frame[0][item], \
                                                                    sid, pid)
                try:
                    if  self.cur_pid != pid:
                        return 1
                except:
                    return 1
                if len (current_frame[0]) > 3:
                    if not item % 10:
                        self.ClientObj.app.processEvents()
                else:
                    self.ClientObj.app.processEvents()
                    self.valSignal.emit()

    def get_entire_frame(self, pid = None):
        """ get entire frame, from beginning (if client disconnected) """
        self.ClientObj.app.processEvents()
    
        sid = get_sid(self.ClientObj.client)
        if not pid:
            try:
                list_pid = self.ClientObj.client.service.list_pid(sid = sid)
            except urllib2.URLError, e:
                _print ('get_entire_frame in MainFrameResult Exception')
                show_msg (e, _("Not connected!"))
                return 1
        else:
            list_pid = {}
            list_pid[0] = [pid]
        
        if list_pid[0] == [0]:
            return 0
        pid = list_pid[0][0]
        
        
        # Call server method
        if hasattr (self, 'get_Frame_thread'):
            if self.get_Frame_thread.isRunning():
                self.get_Frame_thread.wait()
        self.get_Frame_thread = ClientServiceThread(self.ClientObj,\
                       'get_entire_frame', sid, pid, return_except = True, \
                       through_object = (sid, pid))
        self.get_Frame_thread.signal_extended.connect \
                                                (self.get_entire_frame_after)
        self.get_Frame_thread.start()

    def get_entire_frame_after(self, current_frame, through_object):
        if type(current_frame) == Exception:
            _print (_('Failed to get the complete frame from the server.'))
#            show_msg(_("Failed to get a frame from the server.") +'\n'+ \
#                     _('Try resfeshing this page later.'),'get frame error')
            return 1
        sid, pid = through_object
        end_frame = 1
        if not current_frame in [None, [], ""]:
#                for i in range (10):
            for item in range(len(current_frame[0])):
                end_frame = self.get_message(current_frame[0][item], sid, pid)
                try:
                    if self.cur_pid != pid:
                        return 1
                except:
                    return 1
                if len (current_frame[0]) > 3:
                    if not item % 10:
                        self.ClientObj.app.processEvents()
                else:
                    self.ClientObj.app.processEvents()

        self.get_Frame(sid, pid, def_end_frame = end_frame)

    def get_Progress(self, sid, pid, id):
        """ get progress for the current job """
        
        progressBar = QtGui.QProgressBar()
        progressBar.setMinimumHeight(progressBar.sizeHint().height())
        progressBar.setTextVisible(True)
        self.progress_list.append(progressBar)
        self.work_layout._addWidget(progressBar)

        progressBar.setMinimum(0)
        progressBar.setMaximum(0)
        self.initUI()
        temp_progress = -1
        # Call server method
        if hasattr (self, 'get_Progress_thread'):
            if self.get_Progress_thread.isRunning():
                self.get_Progress_thread.wait()
        self.get_Progress_thread = ClientServiceThread(self.ClientObj,\
                       'get_progress', sid, pid, id, return_except = True, \
                       through_object = (sid, pid, id, temp_progress, \
                       progressBar))
        self.get_Progress_thread.signal_extended.connect \
                                                (self.get_Progress_cycle)
        self.get_Progress_thread.start()

    def get_Progress_cycle(self, returnProgr, through_object):
        if type(returnProgr) == Exception:
            _print (_('Failed to get the progress status from the server'))
#            show_msg(_('Failed to get the progress status from the server') + \
#                    '\n'+ \
#                   _('Try resfeshing this page later.'),'get progress error')
            return 1
        sid, pid, id, temp_progress, progressBar = through_object
########################################
        try:
            percent = returnProgr.percent
        except AttributeError:
            if type(returnProgr) in [str,unicode]:
                _print ('Server return:', returnProgr)
            percent = temp_progress
        if percent <= 100 and percent >= 0 :
            if temp_progress != percent:
                if percent:
#                    progressBar.setProperty("value", 100)
                    progressBar.setMaximum(100)
#                    progressBar.setValue(percent)
                    self.set_progress_value(progressBar, returnProgr)
                if percent == 100:
                    return 0
                self.initUI()
                temp_progress = percent
            try:
                if  self.cur_pid != pid:
                    return 1
            except:
                return 1

            # Call server method
            if hasattr (self, 'get_Progress_thread'):
                if self.get_Progress_thread.isRunning():
                    self.get_Progress_thread.wait()
            self.get_Progress_thread = ClientServiceThread(self.ClientObj,\
                           'get_progress', sid, pid, id, return_except = True,\
                           sleeptime = 1, through_object = \
                           (sid, pid, id, temp_progress, progressBar))
            self.get_Progress_thread.signal_extended.connect \
                                                    (self.get_Progress_cycle)
            self.get_Progress_thread.start()

        if percent < 0:
            progressBar.setMaximum(100)
            returnProgr.percent = 0 - percent
            self.set_progress_value(progressBar, returnProgr)
            self.ClientObj.app.processEvents()
            self.initUI()

    def set_progress_value(self, progressBar, returnProgr):
        if returnProgr.long_message:
            if progressBar.fontMetrics().width(returnProgr.long_message) + \
                                   progressBar.fontMetrics().width(' 000%') \
                                                        < progressBar.width():
                progressBar.setFormat('%s %d%%' %(returnProgr.long_message, \
                                                  returnProgr.percent))
                progressBar.setValue(returnProgr.percent)
                self.ClientObj.app.processEvents()
                return 0
        if returnProgr.short_message:
            progressBar.setFormat('%s %d%%' %(returnProgr.short_message, \
                                                  returnProgr.percent))
            progressBar.setValue(returnProgr.percent)
            self.ClientObj.app.processEvents()
            return 0
        progressBar.setFormat('%d%%' %returnProgr.percent)
        progressBar.setValue(returnProgr.percent)
        self.ClientObj.app.processEvents()

    def get_Table(self, sid, pid, item):
        try:
            table = self.ClientObj.client.service.get_table(sid, pid, item.id)
        except urllib2.URLError:
            self.show_error('Error get table from server')
            return 1

        self.show_table(table, item)
        self.ClientObj.app.processEvents()
        # Resize table
        h = self.mytable.horizontalHeader().height() + \
            2 * self.mytable.frameWidth()
        h += self.mytable.horizontalScrollBar().sizeHint().height()
        for row_in_table in range (self.mytable.rowCount()):
            h += self.mytable.rowHeight(row_in_table)
        self.mytable.setFixedHeight(h)

    def send_Message(self, sid, pid, item):
        """ send answer to the question """
        self.message = MessageDialog(self, item, sid, pid)
        self.message.show()

    def send_Password(self, sid, pid, item):
        """ send password """
        self.passwd = MessageDialog(self, item, sid, pid, True)
        self.passwd.show()

    def close_all_thread(self):
        if hasattr (self, 'get_Frame_thread'):
            if self.get_Frame_thread.isRunning():
                self.get_Frame_thread.close()
                self.get_Frame_thread.wait()

        if hasattr (self, 'get_Progress_thread'):
            if self.get_Progress_thread.isRunning():
                self.get_Progress_thread.close()
                self.get_Progress_thread.wait()

        if hasattr (self, 'send_password_thread'):
            if self.send_password_thread.isRunning():
                self.send_password_thread.close()
                self.send_password_thread.wait()

    def closeEvent(self, event):
        self.cur_pid = 'no'
        self.close_all_thread()
        self._parent.methodname_wgt._hide()
        self._parent.control_button._hide()
        event.accept()

class MessageDialog(QtGui.QWidget):
    # answer to the server question
    def __init__(self, parent, item, sid, pid, isPassword = False):
        super(MessageDialog, self).__init__()
        self._parent = parent
#        self.item = item
        self.sid = sid
        self.pid = pid
        self.layout = QtGui.QGridLayout(self)

        self.label = LabelWordWrap(item.message, self)

        self.pass_edit = QtGui.QLineEdit(self)
        self.layout.addWidget(self.label,0,0)
        self.layout.addWidget(self.pass_edit,0,1)

        x = 1
        if isPassword:
            self.pass_edit.setEchoMode(self.pass_edit.Password)
            if item.id == 2:        
                if hasattr(self,'pass_edit2'):
                    self.pass_edit2 = QtGui.QLineEdit(self)
                    self.pass_edit2.setEchoMode(self.pass_edit2.Password)
                
                self.layout.addWidget(LabelWordWrap(_('Repeat'), self), x, 0)
                self.layout.addWidget(self.pass_edit2, x, 1)
                x += 1
                self.pass_edit.textChanged.connect(self.check_passwd)
                if hasattr(self,'pass_edit2'):
                    self.pass_edit2.textChanged.connect(self.check_passwd)

        self.send_button = QtGui.QPushButton(_('Send'), self)
        self.send_button.setShortcut(QtGui.QKeySequence(QtCore.Qt.Key_Return))
        self.send_button.clicked.connect(self.send_password)
        
        self.layout.addWidget(self.send_button,x,1)
                          
        self.move(parent.ClientObj._parent.geometry().x() + \
                  parent.ClientObj._parent.geometry().width() / 2 \
                  - self.sizeHint().width() / 2, \
                  parent.ClientObj._parent.geometry().y() + \
                  parent.ClientObj._parent.geometry().height() / 2 \
                  - self.sizeHint().height() / 2)
        self.setWindowFlags (QtCore.Qt.WindowMinimizeButtonHint)
#        self.setAttribute(QtCore.Qt.WA_ShowModal)
        
    def send_password(self):
        answer = self.pass_edit.text()
        if not hasattr(self,"pass_edit2") or \
            answer == self.pass_edit2.text():
            
            # Call server method
            if hasattr (self, 'send_password_thread'):
                if self.send_password_thread.isRunning():
                    return 1
            self.send_password_thread = ClientServiceThread(\
                            self._parent.ClientObj, 'send_message', self.sid, \
                            self.pid, answer, return_except = True)
            self.send_password_thread.signal.connect(self.send_password_after)
            self.send_password_thread.start()            
        else:
            self.send_button.setDisabled(True)

    def send_password_after(self, result):
        if type(result) == Exception:
            show_msg(_('Failed to send the message (password) to the server'))
            self.close()
            return 1
        self._parent.show_result(result)
        self.close()

    def check_passwd(self):
        if self.pass_edit.text() != self.pass_edit2.text():
            self.send_button.setDisabled(True)
        else:
            self.send_button.setEnabled(True)
