#-*- coding: utf-8 -*-

# Copyright 2012-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from function import get_sid
from calculate.lib.cl_lang import setLocalTranslate
setLocalTranslate('cl_console3',sys.modules[__name__])

def client_del_sid(client):
    """ delete this session """
    sid = get_sid(client.SID_FILE)
    try:
        s = client.service.del_sid(sid)

        if s[0][0] == "-1":
            print _("No access to the file!")
            return -1
        if s[0][0] == "1":
            print _("Failed to obtain certificate data!")
            return -2
        if s[0][0] == "Permission denied":
            _print (_("%s: permission denied") % s[1][1])
            return -3

        if s[0][0] == '0':
            fi = open(client.SID_FILE, 'w')
            fi.write('0')
            fi.close()
            print _("SID deleted!")
    except:
        print _("SID deletion error on the server")
        return 1
    return 0

def sid_inf(client, sid):
    red = '\033[31m * \033[0m'
    green = '\033[32m * \033[0m'
    """ get information about selected session """
    s = client.service.sid_info(sid)
    if s[0][0] == "-1":
        print red + _("Session non registered on the server!")
        return -1
    if s[0][0] == "-2":
        print red + _("Failed to obtain certificate data!")
        return -2
    if s[0][0] == "Permission denied":
        print red + _("%s: permission denied") % s[0][1]
        return -3

    print _('Session information: ')
    print green + _(u"Session number: %s") %sid
    print green + _(u"Certificate number: %s") %s[0][0]
    _print (green + _(u"Certificate issued on %s") %s[0][1])
    print green + "ip - %s" %s[0][2]
    print green + "MAC - %s\n" %s[0][3]
    return 0

def client_session_info(client, sid = None):
    """ select session for get information """
    try:
        select_sid = sid if sid else client.sid
        sid_inf(client, select_sid)
    except Exception, e:
        if type (e.message) == tuple and len(e.message) == 2 \
                                    and e.message[1] == 'Forbidden':
            print _("Access forbidden!")
        else:
            print e
        return 1

def client_session_list(client):
    red = '\033[31m * \033[0m'
    green = '\033[32m * \033[0m'
    try:
        res = client.service.get_sessions(client.sid)
    except Exception, e:
        if type (e.message) == tuple and len(e.message) == 2 \
                                    and e.message[1] == 'Forbidden':
            print _("Access forbidden!")
        else:
            print e
        return 1
    if hasattr (res, 'string'):
        if res.string:
            print _('Active sessions on the server: ')
            for session_id in res.string:
                print green + session_id
            print
            return 0
    print red + _('No active sessions on the server')

def session_clean(client):
    try:
        res = client.service.clear_session_cache(client.sid)
    except Exception, e:
        if type (e.message) == tuple and len(e.message) == 2 \
                                    and e.message[1] == 'Forbidden':
            print _("Access forbidden!")
        else:
            print e
    if res:
        print _('Error clearing the session cache')
    else:
        print _('Session cache cleared')
