# -*- coding: utf-8 -*-

# Copyright 2017 Mir Calculate. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
import sys
from calculate.lib.utils.files import grepFile
from os import path

_ = lambda x: x
from calculate.lib.cl_lang import setLocalTranslate

setLocalTranslate('cl_lib3', sys.modules[__name__])


class SystemType(object):
    """
    Тип контейнера текущей системы
    """
    Uml = "uml"
    VServer = "vserver"
    OpenVZ = "openvz"
    LXC = "lxc"
    Docker = "docker"
    Xen0 = "xen0"
    XenU = "xenU"
    Rkt = "rkt"
    SystemdNSpawn = "systemd-nspawn"
    NotDetected = ""

    @classmethod
    def detect_container(cls):
        if grepFile("/proc/cpuinfo", "UML"):
            return cls.Uml
        elif grepFile("/proc/self/status",
                "(s_context|VxID):\s*[1-9]"):
            return cls.VServer
        elif (path.exists("/proc/vz/veinfo")
              and not path.exists("/proc/vz/version")):
            return cls.OpenVZ
        elif grepFile("/proc/self/status", "envID:\s*[1-9]"):
            return cls.OpenVZ #old test
        elif grepFile("/proc/1/environ", "container=lxc"):
            return cls.LXC
        elif grepFile("/proc/1/environ", "container=rkt"):
            return cls.Rkt
        elif grepFile("/proc/1/environ", "container=systemd-nspawn"):
            return cls.SystemdNSpawn
        elif path.exists("/.dockerenv"):
            return cls.Docker
        elif grepFile("/proc/1/environ", "container=docker"):
            return cls.Docker
        return cls.NotDetected

    @classmethod
    def detect_vm(cls):
        if path.exists("/proc/xen"):
            if grepFile("/proc/xen/capabilities", "control_d"):
                return cls.Xen0
            return cls.XenU
        return cls.NotDetected

    @classmethod
    def detect(cls):
        return cls.detect_container() or cls.detect_vm()
