#-*- coding: utf-8 -*-

# Copyright 2010-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from calculate.core.server.func import Action
from calculate.lib.cl_lang import setLocalTranslate,getLazyLocalTranslate
from calculate.lib.utils.files import FilesError
from calculate.install.install import (MigrationError, TemplatesError,
                                  InstallError)

setLocalTranslate('cl_update3',sys.modules[__name__])
__ = getLazyLocalTranslate(_)

class ClUpdateAction(Action):
    """
    Действие обновление конфигурационных файлов
    """
    # ошибки, которые отображаются без подробностей
    native_error = (FilesError,)

    successMessage = __("Revision update finished!")
    failedMessage = __("Failed to update of system revision")
    interruptMessage = __("Update manually interrupted")

    # список задач для дейсвия
    tasks = [
         {'name':'dispatch',
          'method':'Install.applyTemplates(install.cl_source,cl_template_clt_set,'\
                   'True,None)',
         }]
