#-*- coding: utf-8 -*-

# Copyright 2012-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from PySide import QtGui, QtCore

class Delegate(QtGui.QStyledItemDelegate):
    def __init__(self, parent = None):
        QtGui.QStyledItemDelegate.__init__(self, parent)

    def setView(self, view):
        self.view = view

    def paint(self, painter, option, index):
        o = QtGui.QStyleOptionViewItemV4(option)
        self.initStyleOption(o, index)
        if o.state & QtGui.QStyle.State_MouseOver:
            self.view.setMouseOver(index.row())

        o.state &= ~QtGui.QStyle.State_MouseOver
        QtGui.QStyledItemDelegate.paint(self, painter, o, index)

class SelectedTableWidget(QtGui.QTableWidget):
    def __init__(self, rows, columns, parent, readonly = False, brief = False):
        QtGui.QTableWidget.__init__(self, rows, columns, parent)
        self.currHovered = -1
        self.brief = brief
        self.bFixedHeight = True

        delegate = Delegate()
        delegate.setView(self)
        self.setItemDelegate(delegate)
        self.setMouseTracking(True)

        self.readonly = readonly
        self.setSelectionMode \
                           (QtGui.QAbstractItemView.SelectionMode.NoSelection)
        self.horizontalHeader().moveSection(-1,0)
        self.horizontalHeader().setFixedHeight(24)
        self.horizontalHeader().setMinimumSectionSize(48)
        self.setFrameStyle(QtGui.QFrame.NoFrame)
        self.verticalHeader().hide()

        item_background = 'transparent' if brief else 'rgba(255,255,255,255)'
        self.background_color = 'transparent' if brief else '#FFFFFF'

        self.horizontalHeader().setStyleSheet \
                         ("QHeaderView {background-color: transparent;"
                          "border: none; }"
                          'QHeaderView::section {background-color: %s;' \
                          %item_background + \
                          'border: 1px solid #B3ABA7; border-radius: 1px;}')
        self.unsetErrorBorder()

    def setColor(self, row = -1):
        if self.brief:
            return
        if row == -1:
            for row in range (0, self.rowCount()):
                for col in range (0, self.columnCount()):
                    item = self.item(row, col)
                    if not item:
                        continue
                    item.setBackground(QtGui.QBrush(QtGui.QColor('white')))

    def mousePressEvent(self, event):
        if self.readonly:
            event.ignore()
            return
        if event.button() != QtCore.Qt.MouseButton.LeftButton:
            event.ignore()
        else:
            QtGui.QTableWidget.mousePressEvent(self, event)
            event.accept()

    def setMouseOver(self, row):
        if row == self.currHovered or self.readonly:
            return
        for col in range (0, self.columnCount()):
            item = self.item(row, col)
            if not item:
                continue
            item.setBackground(QtGui.QBrush(QtGui.QColor(220,220,220,255)))

        if self.currHovered != -1:
            self.disableMouseOver()
        self.currHovered = row
#        self.setCursor(QtCore.Qt.CursorShape.PointingHandCursor)

    def disableMouseOver(self):
        if self.readonly:
            return
#        self.setCursor(QtCore.Qt.CursorShape.ArrowCursor)
        for col in range (0, self.columnCount()):
            item = self.item(self.currHovered, col)
            if not item:
                continue
            item.setBackground(QtGui.QBrush(QtGui.QColor("white")))

    def mouseMoveEvent(self, event):
        QtGui.QTableView.mouseMoveEvent(self, event)

    def leaveEvent(self, event):
        if self.readonly:
            return
        self.disableMouseOver()
        self.currHovered = -1

    def unsetErrorBorder(self):
        self.setStyleSheet("QTableWidget {"
                         "border: none;"
                         "gridline-color: #B3ABA7;"
                         "background-color: %s;}" %
                         self.background_color +\
                         "QTableWidget::item {padding: 0px;"
                         "border-left: 1px solid #B3ABA7;"
                         "background-color: %s;}" %
                         self.background_color)

    def setErrorBorder(self):
        self.setStyleSheet("QTableWidget {"
                         "border: 1px solid red;"
                         "background-color: #FFFFFF;}"
                         "QTableWidget::item {padding: 0px;"
                         "border-left: 1px solid #B3ABA7;"
                         "background-color: rgba(255,255,255,255);}")
