#!/usr/bin/python
#-*- coding: utf-8 -*-

# Copyright 2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from methods_func import get_method_argparser, collect_object, \
                         check_result_msg, get_param_pwd, _print
from api_types import ViewInfo
from calculate.core.client.progressbar import Bar,Percentage,ETA,ProgressBar
from cert_cmd import parse
import sys, termios
from fcntl import ioctl
from array import array
from calculate.lib.cl_print import color_print
from calculate.lib.datavars import VariableError
from calculate.lib.cl_lang import setLocalTranslate
setLocalTranslate('cl_core',sys.modules[__name__])

class replaceClass():
    def startprocess (self, sid, target=None, method=None, method_name=None, \
                      auto_delete=False, args_proc = {}):
        """ start process """
        com = target(self.no_progress)
        if hasattr (com.__class__.__bases__[1], '__init__'):
            com.__class__.__bases__[1].__init__(com)
        getattr(com, method)(*args_proc)
        return 0

    class Common:
        """ class to interact with the processes """
        def __init__(self, no_progress):
            self.pid = 0
            self.Num = 100000
            self.color_print = color_print()

            self.no_progress = no_progress
            self.progress = None
            self.progressbar = None
            self.last_progress_msg = ''

        def writeFile(self):
            pass

        def setProgress(self, perc, short_message = None, long_message = None):
            if self.no_progress:
                self.progress = perc
                return
            if perc >= 100 or perc < 0:
                if self.progressbar:
                    self.progressbar.finish()
                return
            self.last_progress_msg = self.print_progressbar(perc,
                                            short_message, long_message,
                                            last_msg = self.last_progress_msg)

        def print_progressbar(self, percent, short_message, long_message,
                              last_msg = None, error = False):
            if long_message:
                if last_msg != long_message:
                    cout_progress()
                    for line in long_message.splitlines():
                        self.color_print.printSUCCESS(line)
                self.progressbar.update(percent)
                return long_message
            elif short_message:
                if last_msg != short_message:
                    cout_progress()
                    for line in short_message.splitlines():
                        self.color_print.printSUCCESS(line)
                self.progressbar.update(percent)
                return short_message
            else:
                self.progressbar.update(percent)
                return last_msg

        def setStatus(self, stat):
            pass

        def setData(self, dat):
            self.data_list = dat

        def getStatus(self):
            pass

        def getProgress(self):
            if self.no_progress:
                return self.progress
            if self.progressbar:
                return self.progressbar.currval
            return 100

        def addProgress(self):
            if self.no_progress:
                self.progress = 0
                return
            widgets = ['','', Bar(), '', Percentage(),' ', ETA()]
            self.progressbar = ProgressBar(widgets=widgets, maxval=100)
            self.progressbar.start()
            self.progress = 0
            self.addMessage(type = 'progress', id = id)

        def printTable(self, table_name, head, body, fields = None,\
                        onClick = None, addAction = None):
            self.printSUCCESS(message = table_name)
            print printTable(body, head)

        def addMessage(self, type = 'normal', message = None, id = None):
            self.printSUCCESS(message)

        def printSUCCESS(self, message = '', type = None, id = None):
            if message:
                if self.progressbar:
                    if not self.progressbar.finished:
                        cout_progress()
                        for line in message.splitlines():
                            self.color_print.printSUCCESS(line)
                        return
                if message:
                    for line in message.splitlines():
                        self.color_print.printSUCCESS(line)

        def printWARNING(self, message):
            if self.progressbar and not self.no_progress:
                if not self.progressbar.finished:
                    cout_progress()
                    for line in message.splitlines():
                        self.color_print.printWARNING(line)
                    return
            if message:
                for line in message.splitlines():
                    self.color_print.printWARNING(line)

        def printERROR(self, message = ''):
            perc = self.getProgress()
            if perc == 0:
                self.setProgress(100)
            elif self.getProgress() > 0:
                # finish progress
                self.setProgress(0 - self.getProgress())
            else:
                #self.setProgress(-100)
                self.setProgress(perc)
            if message:
                for line in message.splitlines():
                    self.color_print.printERROR(line)

        def startTask(self, message, progress = False, num = 1):
            self.printSUCCESS(message = message)
            if progress:
                self.addProgress()

        def setTaskNumber(self, number = None):
            pass

        def endTask(self, result = None, progress_message = None):
            if result:
                self.color_print.printOK(result)
            self.setProgress(100, progress_message)

        def askQuestion(self, message):
            return raw_input(message)

        def askPassword(self, message, twice = False):
            from calculate.lib.utils.common import getpass
            text1 = message
            if not twice:
                return getpass.getpass(text1)
            if twice:
                text2 = _('Repeat: ')
                pass1 = 'password'
                pass2 = 'repeat'
            try:
                while pass1 != pass2:
                    pass1 = getpass.getpass(text1)
                    pass2 = getpass.getpass(text2)
                    if pass1 != pass2:
                        print _('Passwords do not match')
            except KeyboardInterrupt:
                return None
            passwd = pass1 if (pass1 and pass1 == pass2) else None
            return passwd

        def beginFrame(self, message = None):
            self.printSUCCESS(message = message)

        def endFrame(self):
            self.printSUCCESS(type = 'endFrame')

        def startGroup(self, message):
            self.printSUCCESS(type = 'startGroup', message = message)

        def endGruop(self):
            pass

        def briefParams(self, view_name):
            pass

def cout_progress(string = None):
    try:
        h,w=array('h', ioctl(sys.stderr,termios.TIOCGWINSZ,'\0'*8))[:2]
    except IOError:
        return
    sys.stdout.write('\r' + (' '*(w)))
    if string:
        sys.stdout.write('\r' + string)
    else:
        sys.stdout.write('\r')
    sys.stdout.flush()

def local_method(metaclass, args):
    """
    Call method from metaclass, check method existing.

    Generate help, for method, run method by 'call_method'.
    """
    import os
    sym_link = os.path.basename(sys.argv[0])
    if sym_link != 'cl-core':
        if sym_link in metaclass.Dec.conMethods.keys():
            args.method = metaclass.Dec.conMethods[sym_link][0]
        else:
            _print (_('Method for %s not found') %sym_link)
            sys.exit(1)

    if args.list_methods:
        keys = metaclass.Dec.conMethods.keys()
        keys.sort()
        for key in keys:
            print metaclass.Dec.conMethods[key][0], ' - ', \
                  metaclass.Dec.conMethods[key][1]
        return 0

    colorPrint = color_print()
    metaObject = metaclass()
    method_name = args.method
    method_view_name = method_name + '_view'
    if args.method and args.help:
        view_obj = ViewInfo()
        view_obj.step = None
        view_obj.expert = True
        view_obj.brief = None
        try:
            view = getattr(metaObject, method_view_name)(0, view_obj)
        except AttributeError:
            colorPrint.printERROR (_('Method not found: '), method_view_name)

        try:
            method_parser = get_method_argparser(view, args, cl_core = True)
        except Exception as e:
            metaObject.clear_cache(0, method_name)
            return  1
        method_parser.print_help()
    else:
        try:
            call_method(metaObject, args, colorPrint)
        except (KeyboardInterrupt, EOFError):
            colorPrint.printERROR(_('Interrupted by the user'))
        except Exception:
            pass
#            print 'Error: ', e
    metaObject.clear_cache(0, method_name)

def call_method(metaObject, args, colorPrint):
    """
    Function for call method through metaObject and args
    """
    method_name = args.method
    stdin_passwd = args.stdin_passwd
    method_view_name = method_name + '_view'
    metaObject.no_progress = args.no_progress
    view_obj = ViewInfo()
    view_obj.step = None
    view_obj.expert = True
    view_obj.brief = None

    no_questions = args.no_questions
    try:
        view = getattr(metaObject, method_view_name)(0, view_obj)
    except AttributeError:
        colorPrint.printERROR (_('Method not found: ') + method_name)
        return None
    method_parser = get_method_argparser(view, args, cl_core = True)
    param_object = create_param_object(view)
    try:
        args, unknown_args = method_parser.parse_known_args()
    except SystemExit:
        return 1
    for i in unknown_args:
        if i.startswith('-'):
            if i in parse().parse_known_args()[1]:
                _print (_('Unknown parameter'), i)
                return 1

    param_object, steps = collect_object(None, param_object, view, args,
                                         stdin_passwd=stdin_passwd)
    if view.has_brief:
        setattr(param_object, 'CheckOnly', True)
        check_res = {}
        while True:
            method_result = getattr(metaObject, method_name)(0, param_object)
            if not method_result:
                print _('Method not available')
                return None

            if method_result[0].type and method_result[0].type != "pid":
                check_res = check_result_msg(method_result, view, check_res)
                if not check_res:
                    return None
                else:
                    param_object = get_param_pwd(check_res, view,
                                                 param_object,
                                                 stdin_passwd=stdin_passwd)
            else:
                break

        view_obj = ViewInfo()
        view_obj.step = None
        view_obj.expert = True
        view_obj.brief = True
        try:
            view = getattr(metaObject, method_view_name)(0, view_obj)
        except AttributeError:
            colorPrint.printERROR (_('Method not found: ') + method_name)

        print_brief(view, steps.label)
        if not no_questions:
            while True:
                try:
                    ask = raw_input('\n' + _('Run process? (yes/no): '))
                except KeyboardInterrupt:
                    ask = 'no'
                    print
                if ask.lower() in ['n', 'no']:
                    colorPrint.printERROR(_('Interrupted by the user'))
                    return None
                if ask.lower() in ['y', 'yes']:
                    break

    setattr(param_object, 'CheckOnly', False)
    try:
        method_result = getattr(metaObject, method_name)(0, param_object)
    except VariableError, e:
        _print (e)
        return None
    if not method_result:
        colorPrint.printERROR (_('method unavailable'))
        return None
    for ReturnedMessage in method_result:
        if ReturnedMessage.type and ReturnedMessage.type != "pid":
            params_text = ''
            for Group in view.groups:
                for field in Group.fields:
                    if field.name == ReturnedMessage.field:
                        if field.opt.shortopt or field.opt.longopt:
                            params_text += _('Error in parameter ')
                            params_text += ', '.join(filter(None,
                                [field.opt.shortopt, field.opt.longopt]))+'. '
            colorPrint.printERROR('\r' + params_text + \
                                         ReturnedMessage.message)
            return None
    return method_result

def create_param_object(view):
    param_object = type ('collect_object', (object,), {})
    setattr(param_object, 'CheckAll', True)
    setattr(param_object, '_type_info', {})
    for Group in view.groups:
        if not Group.fields:
            continue
        for field in Group.fields:
            setattr(param_object, field.name, None)
            param_object._type_info[field.name] = None
    return param_object

def print_brief(view, brief_label):
    for Group in view.groups:
        if Group.name:
            if not Group.fields:
                continue
        print_brief_group(Group.fields, Group.name)

def print_brief_group(Fields, group_name):
    print_group_flag = False
#    if group_name:
#        _print ('\b'+group_name)
    uncompatible_count = 0
    colorPrint = color_print()
    for field in Fields:
        if field.uncompatible:
            uncompatible_count += 1
            continue
        if field.element in ['input', 'openfile']:
            value = field.value if field.value else ''
            if not print_group_flag:
                if group_name:
                    print_group_flag = True
                    _print ('\b'+group_name)
            colorPrint.printSUCCESS('%s: %s' %(field.label, value))

        elif field.element in ['combo', 'comboEdit', 'radio', 'file']:
            if field.choice:
                if not field.choice[0]:
                    field.choice.pop(0)
            if field.comments:
                if not field.comments[0]:
                    field.comments.pop(0)
            if field.comments and field.choice:
                if not field.value in field.choice:
                    field.choice.append(field.value)
                value = map(lambda x: field.comments[x] \
                        if len(field.comments) > x else field.choice[x], 
                        map(lambda x: field.choice.index(x),
                        filter (lambda x: x in field.choice, [field.value])))
                value = ', '.join(value)
            else:
                value = field.value if field.value else ''
            if not print_group_flag:
                if group_name:
                    print_group_flag = True
                    _print ('\b'+group_name)
            colorPrint.printSUCCESS('%s: %s' %(field.label, value))

        elif field.element in ['multichoice', 'multichoice_add',\
                                 'selecttable', 'selecttable_add']:
            if field.choice:
                if not field.choice[0]:
                    field.choice.pop(0)
            if field.comments:
                if not field.comments[0]:
                    field.comments.pop(0)
            if field.listvalue:
                if not field.listvalue[0]:
                    field.listvalue.pop(0)
            if field.choice:
                value = map(lambda x: field.comments[x] \
                        if len(field.comments) > x \
                        else field.choice[x], 
                            map(lambda x: field.choice.index(x), \
                                field.listvalue))
            else:
                value = []
            value = ', '.join(value)
            if field.listvalue and not value:
                value = ', '.join(field.listvalue)
            elif not value:
                value = field.value if field.value else ''
            if not print_group_flag:
                if group_name:
                    print_group_flag = True
                    _print ('\b'+group_name)
            colorPrint.printSUCCESS('%s: %s' %(field.label, value))

#        elif field.element == 'label':
#            print field.label

        elif field.element == 'error':
            if not print_group_flag:
                if group_name:
                    print_group_flag = True
                    _print ('\b'+group_name)
            colorPrint.printERROR(field.label)

        elif field.element in ['check', 'check_tristate']:
            if field.value == 'on':
                value = _('yes')
            elif field.value == 'off':
                value = _('no')
            elif field.value == 'auto':
                value = _('auto')
            else:
                value = field.value
            if not print_group_flag:
                if group_name:
                    print_group_flag = True
                    _print ('\b'+group_name)
            colorPrint.printSUCCESS('%s: %s' %(field.label, value))

        elif field.element == 'table' and field.type != 'steps':
            head = field.tablevalue.head

            body = []
            for row in field.tablevalue.body:
                if not row[0]:
                    row.pop(0)
                body.append(row)

            # if empty table
            if not filter (None, map(lambda x: x, body)):
                body = [['']*len(head)]
                res = printTable(body, head)
                sys.stdout.flush()
                sys.stdout.write(res)
                continue
            ChoiceValue = field.tablevalue.values
            for row in xrange(len(ChoiceValue)):
                if ChoiceValue[row].typefield in ['check', 'check_tristate']:
                    for i in xrange(len(body)):
                        if body[i][row] == 'on':
                            body[i][row] = _('yes')
                        if body[i][row] == 'off':
                            body[i][row] = _('no')
                        if body[i][row] == 'auto':
                            body[i][row] = _('auto')
                if ChoiceValue[row].typefield == 'password':
                    for i in xrange(len(body)):
                        if body[i][row]:
                            body[i][row] = '***'
            data = []
            for body_row in body:
                data.append(map(lambda x: x if x else '', body_row))
            if not print_group_flag:
                if group_name:
                    print_group_flag = True
                    _print ('\b'+group_name)
            colorPrint.printSUCCESS(field.label+': ')
            res = printTable(data, head)
            sys.stdout.flush()
            sys.stdout.write(res)
        else:
            uncompatible_count += 1

#    if uncompatible_count == len (Fields) and group_name:
#        colorPrint.printSUCCESS(_('Not used'))

def printTable(data, header=None ):
    res = []
    for row in data:
        encode_row = map(lambda x: x.encode('utf-8') if x else '',row)
        res.append(encode_row)
    data = res

    if type(header) == list:
        header = map(lambda x: x.encode('utf-8'), header)

    lens = [0]*len(data[0])
    for row in data:
        for numCol, column in enumerate(row):
            cLen = len(unicode(str(column).decode('utf-8')))
            if lens[numCol] < cLen:
                lens[numCol] = cLen
    res = ""
    spacer = lambda lenList: '+' + \
                          '+'.join( '-'*(x+2) for x in lenList) + '+'
    drawRow = lambda lenList, valueList: '|' + "".join(
            ' %s ' % item + ' ' * (lenList[num] - \
            len(unicode(str(item).decode('utf-8')))) + '|'
            for num, item in enumerate(valueList) )
    if header:
        for numCol, column in enumerate(header):
            cLen = len(unicode(str(column).decode('utf-8')))
            if lens[numCol] < cLen:
                lens[numCol] = cLen
        res += spacer(lens)+ "\n"
        res += drawRow( lens, header )+ "\n"

    res+= spacer(lens) + "\n"
    for r in data:
        res += drawRow( lens, r )+ "\n"
    res+= spacer(lens)+ "\n"
    return res
