#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# setup.py --- Setup script for calculate-core

# Copyright 2011-2012 Calculate Ltd. http://www.calculate-linux.org
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os, sys
from os import path, system
from glob import glob
import distutils
from distutils.core import setup
from calculate.install_data import install_data

__version__ = "3.2.2"
__app__ = "calculate-core"


packages = [
    "calculate."+str('.'.join(root.split(os.sep)[1:]))
    for root, dirs, files in os.walk('pym/core')
    if '__init__.py' in files
]

setup(
    name = __app__,
    version = __version__,
    description = "The program for configuring WSDL server",
    author = "Calculate Ltd.",
    author_email = "support@calculate.ru",
    url = "http://calculate-linux.org",
    license = "http://www.apache.org/licenses/LICENSE-2.0",
    data_files = (
        ('/usr/sbin', [('bin/cl-core',0755)]),
        ('/etc/init.d', [('data/calculate-core',0755)]),
        ('/usr/share/man/man1',glob('man/cl-*')),
        ('/usr/share/man/ru/man1',glob('man/ru/*'))
    ),
    package_dir = {'calculate.core': "pym/core"},
    packages = packages,
    cmdclass={'install_data': install_data}
)
