#-*- coding: utf-8 -*-

# Copyright 2008-2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os
import sys
from os import path
from calculate.lib.datavars import Variable,VariableError,ReadonlyVariable

from calculate.lib.cl_lang import setLocalTranslate
setLocalTranslate('cl_install3',sys.modules[__name__])

class VariableAcInstallMerge(ReadonlyVariable):
    """
    Action variable which has value "up" by default and not flash installation
    """
    def get(self):
        actionsMap = {'merge':'up',
                      'system':'up'}
        cl_action = self.Get('cl_action')
        if cl_action == 'system' and \
            self.Get('os_install_root_type') == 'flash':
            return ""
        if self.Get('cl_live') == "on":
            return ""
        return actionsMap.get(cl_action,'')

class VariableAcInstallSystem(ReadonlyVariable):
    """
    Action variable which has value "up" for installation on hdd
    """
    def get(self):
        if self.Get('cl_action') == 'system' and \
            self.Get('os_install_root_type') != "flash" and \
            self.Get('os_install_pxe') != "on":
            return "up"
        else:
            return ""

class VariableAcInstallFlash(ReadonlyVariable):
    """
    Action variable which has value "up" for USB flash
    """
    def get(self):
        clAction = self.Get('cl_action')
        if clAction == 'system' \
            and self.Get('os_install_root_type') == 'flash':
            return "up"
        return ""

class VariableAcInstallLive(ReadonlyVariable):
    """
    Action which "up" value describe dinamic templates
    """
    def get(self):
        if self.Get('ac_install_merge') == "up" and \
            self.Get('ac_install_pxe') != "up" and \
            self.Get('cl_chroot_status') == "off"  or \
            self.Get('cl_live') == 'on':
            return "up"
        else:
            return ""

class VariableAcInstallPxe(ReadonlyVariable):
    """
    Action variable which has value "up" for PXE installation
    """
    def get(self):
        clAction = self.Get('cl_action')
        if clAction == 'system' and self.Get('os_install_pxe') == 'on':
            return "up"
        return ""

class VariableAcInstallConfigure(ReadonlyVariable):
    """
    Action variable which has value "up" for configuration
    """
    def get(self):
        clAction = self.Get('cl_action')
        clSetup = self.Get('cl_setup')
        if clAction == "merge" and clSetup:
            return "up"
        return ""
