#-*- coding: utf-8 -*-

# Copyright 2015 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from xml import xpath
import xml.dom.minidom
from calculate.lib.utils.common import _error
from calculate.lib.cl_lang import setLocalTranslate
from itertools import chain
setLocalTranslate('cl_lib3',sys.modules[__name__])

class kernel(_error):
    """Класс для объединения файлов конфигурации ядра"""
    # root нода
    rootNode = False
    # body нода
    bodyNode = False
    # Документ
    doc = False
    # Текст шаблона
    text = ""
    # Комментарий
    _comment = ("#")

    def __init__(self, text):
        self.text = text
        # Создаем пустой объект
        self.docObj = type("_empty_class", (object,), {})()
        # Названия аттрибутов для пустого объекта
        emptyMethods = ["getNodeBody","removeComment","insertBRtoBody",
                        "insertBeforeSepAreas"]
        # Добавляем необходимые аттрибуты пустому объекту
        for method in emptyMethods:
            setattr(self.docObj, method, self.emptyMethod)
        # Создаем XML документ
        self.doc = self.textToXML()

    def emptyMethod(self, *arg , **argv):
        """Пустой метод"""
        return True

    def textToXML(self):
        """Создание документа из текста self.text
        """
        class KernelConfig:
            def __init__(self):
                self.body = {}
                self.remove = []

        doc = KernelConfig()
        for line in (x for x in self.text.split('\n')
                     if x.strip() and not x.startswith(self._comment)):
            key, op, value = line.strip().partition('=')
            if key[:1] == '!':
                key = key[1:]
                doc.remove.append(key)
                if key in doc.body:
                    doc.body.pop(key)
            else:
                doc.body[key] = value
        return doc

    def join(self, xml_xfceObj):
        """Объединяем конфигурации"""
        if isinstance(xml_xfceObj, kernel):
            try:
                self.joinDoc(xml_xfceObj.doc)
            except Exception as e:
                self.setError(_("Failed to join the template"))
            return False
        return True

    def postXML(self):
        """Последующая постобработка XML"""
        pass

    def _join(self, xmlNewNode, xmlOldNode):
        """Объединение корневой ноды шаблона и корневой ноды файла"""
        for key in chain(xmlNewNode.remove,
                         xmlOldNode.remove):
            if key in xmlOldNode.body:
                xmlOldNode.body.pop(key)
        xmlOldNode.body.update(xmlNewNode.body)
        return True

    def joinDoc(self, doc):
        """Объединение документа шаблона и документа файла"""
        if not self.doc:
            self.setError(_("The text file is not XML"))
            return False
        if not doc:
            self.setError(_("The text file is not XML"))
            return False
        # объединяем документы
        if not self._join(doc, self.doc):
            return False
        return True

    def getConfig(self):
        """Получение текстового файла из XML документа"""
        return "\n".join(["%s=%s"%(key,value)
                         for key,value in self.doc.body.items()]).decode('UTF-8')
