#-*- coding: utf-8 -*-

# Copyright 2010-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from calculate.core.server.func import Action, Tasks
from calculate.lib.cl_lang import setLocalTranslate,getLazyLocalTranslate
from calculate.lib.utils.files import FilesError
from calculate.install.install import (MigrationError, TemplatesError,
                                  InstallError)
from calculate.update.update import UpdateError,GitError

setLocalTranslate('cl_update3',sys.modules[__name__])
__ = getLazyLocalTranslate(_)

class ClUpdateAction(Action):
    """
    Действие обновление конфигурационных файлов
    """
    # ошибки, которые отображаются без подробностей
    native_error = (FilesError,UpdateError,GitError)

    successMessage = None
    failedMessage = __("Update failed")
    interruptMessage = __("Update manually interrupted")

    # список задач для дейсвия
    tasks = [
         {'name':'sync_reps',
          'foreach':'cl_update_sync_rep',
          'message' : __("Syncing {eachvar} repository"),
          'method':'Update.syncRepositories(eachvar)',
          'condition':lambda Get:Get('cl_update_sync_rep')
         },
         {'name':'sync_other_reps',
          'foreach':'cl_update_other_rep_name',
          'message' : __("Syncing {eachvar} repository"),
          'method':'Update.syncLaymanRepository(eachvar)',
          'condition':lambda Get:Get('cl_update_other_set') == 'on'
         },
         {'name':'sync_reps:regen_cache',
          'foreach':'cl_update_sync_overlay_rep',
          'message' : __("Updating cache {eachvar} repository"),
          'essential':False,
          'method':'Update.regenCache(eachvar)',
          'condition':lambda Get:(Get('cl_update_outdate_set') == 'on' and
                Get('cl_update_metadata_force') != 'skip' or
                Get('cl_update_metadata_force') == 'force')
         },
         {'name':'sync_other_reps:regen_other_cache',
          'foreach':'cl_update_other_rep_name',
          'message' : __("Updating cache {eachvar} repository"),
          'method':'Update.regenCache(eachvar)',
          'essential':False,
         },
         {'name':'emerge_metadata',
          'message' : __("Metadata trasfering"),
          'method':'Update.emergeMetadata()',
          'condition':lambda Get:(Get('cl_update_outdate_set') == 'on' and
                Get('cl_update_metadata_force') != 'skip' or
                Get('cl_update_metadata_force') == 'force')
         },
         {'name':'eix_update',
          'message' : __("Updating eix cache"),
          'method':'Update.eixUpdate()',
          'condition':lambda Get:(Get('cl_update_outdate_set') == 'on' and
                Get('cl_update_eixupdate_force') != 'skip' or
                Get('cl_update_eixupdate_force') == 'force')
         },
         {'name':'dispatch',
          'method':'Update.applyTemplates(install.cl_source,cl_template_clt_set,'\
                   'True,None)',
          'condition':lambda Get:(Get('cl_update_rev_set') == 'on' or
                                  Get('cl_rebuild_world_set') == 'on')
         },
         # сообщение удачного завершения при обновлении репозиториев
         {'name':'success_syncrep',
          'message' : __("Synchronization finished!"),
          'depend': (Tasks.success() & Tasks.has_any("sync_reps",
                        "sync_other_reps","emerge_metadata",
                        "eix_update")),
         },
         # сообщение удачного завершения при обновлении ревизии
         {'name':'success_rev',
          'message' : __("Revision update finished!"),
          'condition':lambda Get:Get('cl_update_rev_set') == 'on'
         },
         # сообщение удачного завершения при пересоздании world
         {'name':'success_world',
          'message' : __("World rebuild finished!"),
          'condition':lambda Get:Get('cl_rebuild_world_set') == 'on'
         }]
