#-*- coding: utf-8 -*-

# Copyright 2010-2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys, time

from soaplib.serializers.primitive import String, Integer, Boolean
from soaplib.serializers.clazz import Array, ClassSerializer
from soaplib.service import rpc

from calculate.core.server.api_types import ReturnedMessage
from calculate.lib.cl_lang import setLocalTranslate
setLocalTranslate('cl_core',sys.modules[__name__])

class SU (ClassSerializer):
    name = String
    times = Integer
    boolvariable = Boolean
    boolvariable2 = Boolean
    radiovariable = String
    radiovariable2 = String
    combovariable = String
    combovariable2 = String
    comboEdit1 = String
    comboEdit2 = String
    multichoice_add = Array(String)
    multichoice = Array(String)
    Partition_table = Array(Array(String))
    Partition_table2 = Array(Array(String))

    Steps = Array(Array(String))
    isopath = Array(String)

    comboLang = String

    # for check parameters without call method
    CheckOnly = Boolean

class CoreWsdl:
    def system_update_meth (self) :
        try:
            results = []
            self.writeFile()
            # ask password
            self.startTask("System Update", True)

            # Учёт процесса выполнения
            perc = 0
            while self.getProgress() < 100:
                time.sleep(1.6)
                perc += 10
                # Увеличение процента выполнения процесса
                self.setProgress (perc)

            #self.printERROR ('No internet connected!')
            self.endTask(_("System already updated!"))

            #self.endFrame()
            # necessary for correct complete the process
            return True
        # Обработка сигнала прерывания работы процесса
        except KeyboardInterrupt:
            # Необходимо передать Fasle для сохранения данных о процессе
            return False
        except:
            return False

    @rpc(Integer, _returns = Array(ReturnedMessage))
    def system_update_tray(self, sid):
        system_update_meth = type \
                        ("CommonInstall",(self.Common, CoreWsdl, object), {})
        pid = self.startprocess(sid, target=system_update_meth, \
                                        method="system_update_meth",\
                                        method_name='System Update', \
                                        args_proc = ())
        returnmess = ReturnedMessage(type = 'pid', message = pid)
        #returnmess.type = "pid"
        #returnmess.message = pid
        return [returnmess]
