#-*- coding: utf-8 -*-

# Copyright 2010-2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import  sys, time, os

from calculate.lib.datavars import VariableError,DataVarsError,DataVars

from calculate.core.server.func import WsdlBase
from calculate.install.install import InstallError
from calculate.update.update import Update,UpdateError
from calculate.update.package_tools import GitError
from utils.cl_update import ClUpdateAction
from calculate.lib.cl_lang import setLocalTranslate,getLazyLocalTranslate
setLocalTranslate('cl_update3',sys.modules[__name__])
__ = getLazyLocalTranslate(_)


class Wsdl(WsdlBase):
    methods = [
        #
        # Обновить текущую конфигурацию системы (world,ревизия)
        #
        {
            # идентификатор метода
            'method_name': "update",
            # категория метода
            'category': __('Update'),
            # заголовок метода
            'title': __("Update System"),
            # иконка для графической консоли
            'image': 'software-properties,preferences-desktop',
            # метод присутствует в графической консоли
            'gui': True,
            # консольная команда
            'command': 'cl-update',
            # права для запуска метода
            'rights': ['update'],
            # объект содержащий модули для действия
            'logic': {'Update': Update},
            # описание действия
            'action': ClUpdateAction,
            # объект переменных
            'datavars': "update",
            'native_error': (VariableError, DataVarsError,
                             InstallError, UpdateError, GitError),
            # значения по умолчанию для переменных этого метода
            'setvars': {'cl_action!': 'sync'},
            # описание груп (список лямбда функций)
            'groups': [
                lambda group: group(_("Update system"),
                                    normal=(),
                                    expert=(
                                    'cl_rebuild_world_set', 'cl_update_rev_set',
                                    'cl_update_sync_rep', 'cl_update_branch',
                                    'cl_update_metadata_force',
                                    'cl_update_other_set',
                                    'cl_update_pretend_set',
                                    'cl_update_eixupdate_force',
                                    'cl_update_sync_only_set',
                                    'cl_templates_locate',
                                    'cl_verbose_set', 'cl_dispatch_conf'),
                                    next_label=_("Update"))]},
    ]
