//  Copyright 2007-2010 Mir Calculate Ltd. http://www.calculate-linux.org
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
// 
//      http://www.apache.org/licenses/LICENSE-2.0
// 
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

#include <security/pam_modules.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <ctype.h>

#include <asm/unistd.h>


#define PAM_SM_AUTH
#define MAX_V 30
#define WAITTIME 30

int file_exists(const char *fname) {
  return access(fname, 0) != -1;
}

// Authentication function
PAM_EXTERN int pam_sm_authenticate(pam_handle_t * pamh, int flags
                                   ,int argc, const char **argv)
{
 int i;
 char *boot_client="/etc/runlevels/boot/client";
 char *default_client="/etc/runlevels/default/client";
 char *started_client="/run/openrc/started/client";
 char *started_local="/run/openrc/started/local";
 char *ldap_conf="/etc/ldap.conf";

 // wait for client daemon
 if (file_exists(boot_client) || file_exists(default_client)) {
	 for(i=0;i<WAITTIME;i++) {
	     if(file_exists(started_client) || 
	     	file_exists(started_local)) {
	     	break;
	     }
	     sleep(1);
	 }
 }
 // break auth if not exists ldap.conf
 if (!file_exists(ldap_conf)) {
    return PAM_AUTHINFO_UNAVAIL;
 }
 return PAM_SUCCESS;
}

// Empty function, necessary for pam-module
PAM_EXTERN int pam_sm_setcred(pam_handle_t * pamh, int flags
                              ,int argc, const char **argv)
{
 return PAM_SUCCESS;
}

#ifdef PAM_STATIC
struct pam_module _pam_unix_auth_modstruct = {
    "pam_client",
    pam_sm_authenticate,
    pam_sm_setcred,
    NULL,
    NULL,
    NULL,
    NULL,
};
#endif
