/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_open_X11(), which opens an X11 window in a
 * _ simple way, specifying only its size.
 *
 * This is to be called from Fortran as an integer function,
 * _ that is, as "id = g2_open_x11_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ iw_wid: width of the window;
 * _ iw_hei: height of the window.
 */
int g2_open_x11_ctof__(int *iw_wid, int *iw_hei)
{
  /*
   * Local variables:
   * _ i_iw_wid, i_iw_hei: int variables to acquire the arguments;
   * _ i_id_xd: int variable to return the window id.
   */
  int i_iw_wid, i_iw_hei, i_id_xd;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_iw_wid = *iw_wid;
  i_iw_hei = *iw_hei;
  /*
   * Call the C function with the required arguments.
   */
  i_id_xd = g2_open_X11(i_iw_wid, i_iw_hei);
  /*
   * Return the id of the window created.
   */
  return(i_id_xd);
}
/*
 * Compatibility function for gfortran.
 */
int g2_open_x11_ctof_(int *iw_wid, int *iw_hei)
{
  return g2_open_x11_ctof__(iw_wid, iw_hei);
}
