/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_save(), which saves the graphics output to a
 * _ physical device such as a file.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_save_ctof(<arg>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the argument is:
 * _ id_ad: the id of the device.
 */
void g2_save_ctof__(int *id_ad)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the argument.
   */
  int i_id_ad;
  /*
   * Pass the datum from the pointer argument to the local variable.
   */
  i_id_ad = *id_ad;
  /*
   * Call the C function with the required arguments.
   */
  g2_save(i_id_ad);
}
/*
 * Compatibility function for gfortran.
 */
void g2_save_ctof_(int *id_ad)
{
  g2_save_ctof__(id_ad);
}
