/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_circle(), which draws a circle with given
 * _ center and radius.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_circle_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ x_pos: the x position of the center;
 * _ y_pos: the y position of the center;
 * _ r_siz: the radius of the circle.
 */
void g2_circle_ctof__(int *id_ad,
		      float *x_pos, float *y_pos,
		      float *r_siz)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_x_pos, f_y_pos: float variables to acquire the arguments;
   * _ d_x_pos, d_y_pos: double versions of the variables above;
   * _ f_r_siz: float variable to acquire the argument;
   * _ d_r_siz: double version of the variable above.
   */
  int    i_id_ad;
  float  f_x_pos, f_y_pos, f_r_siz;
  double d_x_pos, d_y_pos, d_r_siz;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_x_pos = *x_pos;
  f_y_pos = *y_pos;
  f_r_siz = *r_siz;
  /*
   * Pass the float data to the double variables.
   */
  d_x_pos = f_x_pos;
  d_y_pos = f_y_pos;
  d_r_siz = f_r_siz;
  /*
   * Call the C function with the required arguments.
   */
  g2_circle(i_id_ad,
	    d_x_pos, d_y_pos,
	    d_r_siz);
}
/*
 * Compatibility function for gfortran.
 */
void g2_circle_ctof_(int *id_ad,
		     float *x_pos, float *y_pos,
		     float *r_siz)
{
  g2_circle_ctof__(id_ad,
		   x_pos, y_pos,
		   r_siz);
}
