/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_detach(), which disconnects a  physical device
 * _ from a virtual device.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_detach_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_vd: the id of the virtual device;
 * _ id_xd: the id of the physical device.
 */
void g2_detach_ctof__(int *id_vd, int *id_xd)
{
  /*
   * Local variables:
   * _ i_id_vd, i_id_xd: int variables to acquire the arguments.
   */
  int i_id_vd, i_id_xd;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_vd = *id_vd;
  i_id_xd = *id_xd;
  /*
   * Call the C function with the required arguments.
   */
  g2_detach(i_id_vd, i_id_xd);
}
/*
 * Compatibility function for gfortran.
 */
void g2_detach_ctof_(int *id_vd, int *id_xd)
{
  g2_detach_ctof__(id_vd, id_xd);
}
