/* JLdL 30Oct07.
 *
 * Copyright (C) 2007 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This routine is a C extension of the g2 library; it draws a
 * _ floating-point number as text at a given position.
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the declaration of the malloc() function.
 */
#include <stdlib.h>
/*
 * Include the I/O headers.
 */
#include <stdio.h>
/*
 * Define the routine; the arguments are:
 * _ id_ad: the id of the device;
 * _ x_pos: the x position of the string;
 * _ y_pos: the y position of the string;
 * _ f_num: the float number to be drawn as a string;
 * _ f_fmt: the C-style format for the float string.
 */
void g2_float_string(int id_ad,
		     double x_pos, double y_pos,
		     double f_num,
		     char *f_fmt)
{
  /*
   * Local variables:
   * _ f_str: the string to hold the format of the number.
   */
  char *f_str;
  /*
   * Dimensioning the string: we must allocate a few bytes to it;
   * _ note how malloc() returns the pointer to the string.
   */
  f_str = malloc(128);
  /*
   * Define the string.
   */
  sprintf(f_str, f_fmt, f_num);
  /*
   * Call the g2 function with the required arguments.
   */
  g2_string(id_ad,
	    x_pos, y_pos,
	    f_str);
}
