/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_ink(), which defines a color.
 *
 * This is to be called from Fortran as an integer function,
 * _ that is, as "icolor = g2_ink_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_xd: the id of the physical device;
 * _ r_val: the R value of the RGB color;
 * _ g_val: the G value of the RGB color;
 * _ b_val: the B value of the RGB color.
 */
int g2_ink_ctof__(int *id_xd,
		  float *r_val, float *g_val, float *b_val)
{
  /*
   * Local variables:
   * _ i_id_xd: int variable to acquire the first argument;
   * _ f_r_val, f_g_val, f_b_val: float variables to acquire the arguments;
   * _ d_r_val, d_g_val, d_b_val: double versions of the variables above;
   * _ i_color: int variable to return the color id.
   */
  int    i_id_xd, i_color;
  float  f_r_val, f_g_val, f_b_val;
  double d_r_val, d_g_val, d_b_val;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_xd = *id_xd;
  f_r_val = *r_val;
  f_g_val = *g_val;
  f_b_val = *b_val;
  /*
   * Pass the float data to the double variables.
   */
  d_r_val = f_r_val;
  d_g_val = f_g_val;
  d_b_val = f_b_val;
  /*
   * Call the C function with the required arguments.
   */
  i_color = g2_ink(i_id_xd,
		   d_r_val, d_g_val, d_b_val);
  /*
   * Return the id of the color created.
   */
  return(i_color);
}
/*
 * Compatibility function for gfortran.
 */
int g2_ink_ctof_(int *id_xd,
		 float *r_val, float *g_val, float *b_val)
{
  return g2_ink_ctof__(id_xd,
		       r_val, g_val, b_val);
}
