/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_line_r(), which draws a line from the current
 * _ graphics cursor position to a given point relative to it.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_line_r_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ x_del: the variation of the x position;
 * _ y_del: the variation of the y position.
 */
void g2_line_r_ctof__(int *id_ad,
		      float *x_del, float *y_del)
{
  /*
   * Local variables:
   * _ i_id_ad: int variable to acquire the first argument;
   * _ f_x_del, f_y_del: float variables to acquire the arguments;
   * _ d_x_del, d_y_del: double versions of the variables above.
   */
  int    i_id_ad;
  float  f_x_del, f_y_del;
  double d_x_del, d_y_del;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  f_x_del = *x_del;
  f_y_del = *y_del;
  /*
   * Pass the float data to the double variables.
   */
  d_x_del = f_x_del;
  d_y_del = f_y_del;
  /*
   * Call the C function with the required arguments.
   */
  g2_line_r(i_id_ad,
	    d_x_del, d_y_del);
}
/*
 * Compatibility function for gfortran.
 */
void g2_line_r_ctof_(int *id_ad,
		     float *x_del, float *y_del)
{
  g2_line_r_ctof__(id_ad,
		   x_del, y_del);
}
