*     JLdL 03Nov07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine opens the X11 window to be used to plot the data;
*     _ given the data read in from the front-end program, it opens
*     _ the window with the appropriate size and position; it also
*     _ defines standard default colors on it, defines a coordinate
*     _ system on it, chooses the size of the text font for it, and
*     _ associates it to the existing virtual device.
*     
      SUBROUTINE OPEN_PLOTTING_WINDOW
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     A character variable for the window title.
      character*32 window_title
*     
*     Define the window title; we must define the string
*     _ with the trailing NULL, including it by hand.
      window_title = 'COMPLEX PLANE'//char(0)
*     
*     Open an X11 window; note that we use here the modified window
*     _ positions; note also that the icon name and icon data are
*     _ sent as empty strings, and that the icon sizes are set at
*     _ the arbitrary but strictly positive values of 1 and 1.
      id_xd = g2_open_x11x_ctof
     *     (
     *     ix_siz,       iy_siz,
     *     jx_pos,       jy_pos,
     *     window_title,
     *     '',           '',
     *     1,            1
     *     )
*     
*     Define the 27 standard g2 colors.
      call g2_allocate_basic_colors_ctof(id_xd)
*     
*     Set the background to black.
      call g2_set_background_ctof(id_xd, ibc_black)
*     
*     Set the coordinate system.
      call g2_set_coordinate_system_ctof
     *     (
     *     id_xd,
     *     xc_org, yc_org,
     *     xc_mul, yc_mul
     *     )
*     
*     Unset the autoflush mode for the device.
      call g2_set_auto_flush_ctof(id_xd, 0)
*     
*     Set the font size.
      call g2_set_font_size_ctof(id_xd, fnt_siz)
*     
*     Associate the physical device to the virtual device.
      call g2_attach_ctof(id_vd, id_xd)
*     
      return
*     
      END
