*     JLdL 11Nov07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine sets the color scheme for the two devices, the
*     _ X11 window and the EPS file; for the EPS file it also sets
*     _ the line width, in order to compensate for the much larger
*     _ resolution of the printer, which results in faded grey
*     _ lines on a black-and-white printer.
*     
      SUBROUTINE SET_COLOR_SCHEME (ics_flag)
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Declare the g2 interface functions.
      include 'g2-ctof.for'
*     
*     The normal one.
      if      (ics_flag .eq. ics_norm) then
*     
*     Choose a color for the foreground, for normal output,
*     _ and only for the X11 window.
         call g2_pen_ctof(id_xd, ibc_white)
*     
*     Choose a color for the foreground, for normal output,
*     _ and only for the output file.
         call g2_pen_ctof(id_fd, ibc_black)
*     
*     Set the line width for the output file.
         call g2_set_line_width_ctof(id_fd, 0.0)
*     
*     The reversed one.
      else if (ics_flag .eq. ics_reve) then
*     
*     Choose a color for the foreground, for normal output,
*     _ and only for the X11 window.
         call g2_pen_ctof(id_xd, ibc_black)
*     
*     Choose a color for the foreground, for normal output,
*     _ and only for the output file.
         call g2_pen_ctof(id_fd, ibc_white)
*     
*     Set the line width for the output file.
         call g2_set_line_width_ctof(id_fd, 0.0)
*     
*     The one for coordinate axes.
      else if (ics_flag .eq. ics_coor) then
*     
*     Choose a color for the foreground, for the coordinate
*     _ axes, for all devices.
         call g2_pen_ctof(id_vd, ibc_blue)
*     
*     Set the line width for the output file.
         call g2_set_line_width_ctof(id_fd, 0.0)
*     
*     The one for integration contours.
      else if (ics_flag .eq. ics_cont) then
*     
*     Choose a color for the foreground, for the integration
*     _ contours, and only for the X11 window.
         call g2_pen_ctof(id_xd, ibc_cyan)
*     
*     Choose a color for the foreground, for the integration
*     _ contours, and only for the output file.
         call g2_pen_ctof(id_fd, ibc_magenta)
*     
*     Set the line width for the output file.
         call g2_set_line_width_ctof(id_fd, 0.5)
*     
*     The one for integral curves.
      else if (ics_flag .eq. ics_curv) then
*     
*     Choose a color for the foreground, for the integral
*     _ curves, and only for the X11 window.
         call g2_pen_ctof(id_xd, ibc_yellow)
*     
*     Choose a color for the foreground, for the integral
*     _ curves, and only for the output file.
         call g2_pen_ctof(id_fd, ibc_dark_orange1)
*     
*     Set the line width for the output file.
         call g2_set_line_width_ctof(id_fd, 0.5)
*     
*     The one for roots.
      else if (ics_flag .eq. ics_root) then
*     
*     Choose a color for the foreground, for marking the
*     _ roots found, for all devices.
         call g2_pen_ctof(id_vd, ibc_green)
*     
*     Set the line width for the output file.
         call g2_set_line_width_ctof(id_fd, 0.5)
*     
*     The one for singularities.
      else if (ics_flag .eq. ics_sing) then
*     
*     Choose a color for the foreground, for marking the
*     _ singularities found, for all devices.
         call g2_pen_ctof(id_vd, ibc_red)
*     
*     Set the line width for the output file.
         call g2_set_line_width_ctof(id_fd, 0.5)
*     
      end if
*     
      return
*     
      END
