*     JLdL 11Nov07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     This routine calculates and returns the two values of the
*     _ vector function, that is, the real and imaginary parts of
*     _ the complex function; depending on the value of the global
*     _ variable "i_vect", it will return the real or imaginary
*     _ parts of the integrands of the Cauchy integral, instead
*     _ of the function; in each case it may also return scaled
*     _ versors instead of the vectors; if the functions returns
*     _ a floating point error, then the routine raises the flag
*     _ "sz_flag" to its singularity value; also, if the function
*     _ returns a null vector, then the routine raises the flag
*     _ "sz_flag" to its null-vector value.
*     
      SUBROUTINE VECTOR_FUNCTION
     *     (x_real, y_imag, u_exit, v_exit, we_mod, sz_flag)
*     
*     Include files with the relevant global data.
      include 'cb_gdata.for'
*     
*     Define two variables to do the complex manipulations.
      complex z_var, w_var
*     
*     Acquire the independent variable from the arguments.
      z_var = cmplx(x_real, y_imag)
*     
*     Implement the function, according to the value of the global
*     _ variable "i_func"; the default is the power-N function.
*     
*     The power-N function.
      if      (i_func .eq. 1) then
         w_var = cmplx(a_real, a_imag) * z_var**npower
*     
*     The exponential function.
      else if (i_func .eq. 2) then
         w_var = cmplx(a_real, a_imag)
     *        * exp(cmplx(b_real, b_imag) * z_var)
*     
*     The sine function.
      else if (i_func .eq. 3) then
         w_var = cmplx(a_real, a_imag)
     *        * sin(cmplx(b_real, b_imag) * z_var)
*     
*     The cosine function.
      else if (i_func .eq. 4) then
         w_var = cmplx(a_real, a_imag)
     *        * cos(cmplx(b_real, b_imag) * z_var)
*     
*     The square-root function.
      else if (i_func .eq. 5) then
         w_var = cmplx(a_real, a_imag) * sqrt(z_var)
*     
*     The natural logarithm function.
      else if (i_func .eq. 6) then
         w_var = cmplx(a_real, a_imag)
     *        * log(z_var + cmplx(c_real, c_imag))
*     
*     The rational function A / (z^N - B).
      else if (i_func .eq. 7) then
         w_var = cmplx(a_real, a_imag)
     *        / (z_var**npower - cmplx(b_real, b_imag))
*     
*     Another square-root function.
      else if (i_func .eq. 8) then
         w_var = cmplx(a_real, a_imag)
     *        * sqrt(z_var**npower - cmplx(b_real, b_imag))
*     
*     A rational and square-root combination.
      else if (i_func .eq. 9) then
         w_var = cmplx(a_real, a_imag)
     *        / sqrt(z_var**npower - cmplx(b_real, b_imag))
*     
*     The function A exp(B / z^N).
      else if (i_func .eq. 10) then
         w_var = cmplx(a_real, a_imag)
     *        * exp(cmplx(b_real, b_imag) / z_var**npower)
*     
*     The function A / sin(B / z^N).
      else if (i_func .eq. 11) then
         w_var = cmplx(a_real, a_imag)
     *        / sin(cmplx(b_real, b_imag) / z_var**npower)
*     
*     Unsupported cases: return zero.
      else
         w_var = (0.0, 0.0)
      end if
*     
*     Get the real and imaginary parts of the result.
      u_real = real(w_var)
      v_imag = imag(w_var)
*     
*     Calculate the modulus of the corresponding vector.
      wt_mod = sqrt(u_real**2 + v_imag**2)
*     
*     Check for a possible singularity in the function, leading to
*     _ a floating-point exception; check whether either component
*     _ or the modulus is one of NaN, +Inf or -Inf; if there is a
*     _ singularity, then raise the singularity flag and zero the
*     _ components and the modulus of the output vector before
*     _ returning.
      if ( (isinf_ctof(u_real) .ne. 0) .or.
     *     (isinf_ctof(v_imag) .ne. 0) .or.
     *     (isnan_ctof(u_real) .ne. 0) .or.
     *     (isnan_ctof(v_imag) .ne. 0) .or.
     *     (isinf_ctof(wt_mod) .ne. 0) .or.
     *     (isnan_ctof(wt_mod) .ne. 0) ) then
         sz_flag = 1
         u_exit  = 0.0
         v_exit  = 0.0
         we_mod  = 0.0
*     
         return
*     
*     Check for a null vector; is the two components are zero or
*     _ the modulus is zero, then raise the null-vector flag and
*     _ zero the components and the modulus of the output vector
*     _ before returning.
      else if (
     *        (
     *        (u_real .eq. 0.0) .and. (v_imag .eq. 0.0)
     *        ) .or.
     *        (wt_mod .eq. 0.0)  ) then
         sz_flag = -1
         u_exit  = 0.0
         v_exit  = 0.0
         we_mod  = 0.0
*     
         return
*     
*     If nothing is amiss, lower the flag.
      else
         sz_flag = 0
      end if
*     
*     Decide which vector to return, according to the value of
*     _ the global variable "i_vect"; the default is the one
*     _ for the complex function.
      if (i_vect .eq. 0) then
         u_exit = u_real
         v_exit = v_imag
         we_mod = wt_mod
*     
         return
*     
*     The real part of the Cauchy integrand.
      else if (i_vect .eq. 1) then
         u_exit =  u_real
         v_exit = -v_imag
         we_mod =  wt_mod
*     
         return
*     
*     The imaginary part of the Cauchy integrand.
      else if (i_vect .eq. 2) then
         u_exit = v_imag
         v_exit = u_real
         we_mod = wt_mod
*     
         return
*     
      end if
*     
*     Calculate the versors: note that we can only do this for
*     _ non-null vectors, and that we never get to this point
*     _ of the code if the vector is null, since in that case
*     _ we return right after the calculation of "x_mod".
*     
*     Define the versor; normalize and then scale the versors
*     _ by the real part of the constant A.
      u_real = a_real * u_real / wt_mod
      v_imag = a_real * v_imag / wt_mod
*     
*     Decide which versor to return; the default is
*     _ the one for the complex function.
      if (i_vect .eq. 3) then
         u_exit = u_real
         v_exit = v_imag
         we_mod = a_real
*     
*     The versor for the real part of the Cauchy integrand.
      else if (i_vect .eq. 4) then
         u_exit =  u_real
         v_exit = -v_imag
         we_mod =  a_real
*     
*     The versor for the imaginary part of the Cauchy integrand.
      else if (i_vect .eq. 5) then
         u_exit = v_imag
         v_exit = u_real
         we_mod = a_real
*     
      end if
*     
      return
*     
      END
