/* JLdL 17Feb08.
 *
 * Copyright (C) 2007-2008 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use from Fortran programs of the g2
 * _ function g2_set_auto_flush(), which sets (1) or unsets (0)
 * _ the auto-flush mode of a device.
 *
 * This is to be called from Fortran as a subroutine, that is,
 * _ as "call g2_set_auto_flush_ctof(<args>)".
 *
 * Include the g2 headers.
 */
#include <g2.h>
/*
 * Include the local g2-ctof headers.
 */
#include "g2-ctof.h"
/*
 * Define the interface; the arguments are:
 * _ id_ad: the id of the device;
 * _ i_flg: the integer flag to set (1) or unset (0).
 */
void g2_set_auto_flush_ctof__(int *id_ad,
			      int *i_flg)
{
  /*
   * Local variables:
   * _ i_id_ad, i_i_flg: int variables to acquire the arguments.
   */
  int i_id_ad, i_i_flg;
  /*
   * Pass the data from the pointer arguments to the local variables.
   */
  i_id_ad = *id_ad;
  i_i_flg = *i_flg;
  /*
   * Call the C function with the required arguments.
   */
  g2_set_auto_flush(i_id_ad,
		    i_i_flg);
}
/*
 * Compatibility function for gfortran.
 */
void g2_set_auto_flush_ctof_(int *id_ad,
			     int *i_flg)
{
  g2_set_auto_flush_ctof__(id_ad,
			   i_flg);
}
