/* JLdL 29Jan12.
 *
 * Copyright (C) 2007-2012 by Jorge L. deLyra.
 * Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
 * This program may be copied and/or distributed freely. See the
 * _ terms and conditions in the files in the doc/ subdirectory.
 *
 * This is a C interface to be called from Fortran programs.
 *
 * This interface allows the use of the glibc function isnan(x),
 * _ which returns 1 if the float variable x is not a number,
 * _ and 0 otherwise, from Fortran programs.
 *
 * This is to be called from Fortran as an integer function,
 * _ that is, as "i = isnan_ctof(x)".
 *
 * Include the necessary headers.
 */
#include <math.h>
/*
 * Define the interface; the argument is:
 * _ x: the float to be tested.
 */
int isnan_ctof__(float *x)
{
  /*
   * Local variables:
   * _ xx: a float variable to acquire the argument;
   * _ ii: int variable to return the answer.
   */
  float xx;
  int ii;
  /*
   * Pass the data from the pointer argument to the local variable.
   */
  xx = *x;
  /*
   * Call the C function with the required arguments.
   */
  ii = isnan(xx);
  /*
   * Return the result of the function.
   */
  return(ii);
}
/*
 * Compatibility function for gfortran.
 */
int isnan_ctof_(float *x)
{
  isnan_ctof__(x);
}
