*     JLdL 11Nov07.
*     
*     Copyright (C) 2007 by Jorge L. deLyra.
*     Mail: <delyra@latt.if.usp.br>. Web: "http://latt.if.usp.br".
*     This program may be copied and/or distributed freely. See the
*     _ terms and conditions in the files in the doc/ subdirectory.
*     
*     Global storage space for the parameters passed from the
*     _ front-end program to this plotting program, and for a
*     _ set of variables which are local to this program.
*     
*     Parameters passed from the front-end program:
*     _ i_flag: a flag to either continue or stop the program;
*     _ i_func: the choice of the complex function;
*     _ a_real: the real part of the parameter A;
*     _ a_imag: the imaginary part of the parameter A;
*     _ b_real: the real part of the parameter B;
*     _ b_imag: the imaginary part of the parameter B;
*     _ c_real: the real part of the parameter C;
*     _ c_imag: the imaginary part of the parameter C;
*     _ npower: the power N of "z^N" in the functions;
*     _ xr_min: the minimum value of the real part of z;
*     _ xr_max: the maximum value of the real part of z;
*     _ yi_min: the minimum value of the imaginary part of z;
*     _ yi_max: the maximum value of the imaginary part of z;
*     _ xp_org: the x position of the imaginary axis;
*     _ yp_org: the y position of the real axis;
*     _ i_cscp: the choice of grid coordinate system;
*     _ i_vect: the choice of vector to plot;
*     _ gr_siz: the plotting grid size;
*     _ sm_rad: the radius of the singularity marker;
*     _ i_w_rw: the width of the root window;
*     _ ix_pos: the x position of the plotting window;
*     _ iy_pos: the y position of the plotting window;
*     _ iw_scl: the overall scale of the plotting window.
*     
*     Define the common block.
      common/param/
     *     i_flag,
     *     i_func,
     *     a_real, a_imag,
     *     b_real, b_imag,
     *     c_real, c_imag,
     *     npower,
     *     xr_min, xr_max,
     *     yi_min, yi_max,
     *     xp_org, yp_org,
     *     i_cscp,
     *     i_vect,
     *     gr_siz,
     *     sm_rad,
     *     i_w_rw,
     *     ix_pos, iy_pos,
     *     iw_scl
*     
*     Variables which are local to this program:
*     _ id_vd:   the id of the virtual device;
*     _ id_xd:   the id of the physical X11 device;
*     _ id_fd:   the id of the physical EPS file device;
*     _ px_pos:  the x position of the pointer device;
*     _ py_pos:  the y position of the pointer device;
*     _ ip_but:  the button state of the pointer device;
*     _ del_xr:  the range of the x plotting coordinate;
*     _ del_yi:  the range of the y plotting coordinate;
*     _ asp_rt:  the aspect ratio of the plotting window;
*     _ ix_siz:  the x size of the plotting window;
*     _ iy_siz:  the y size of the plotting window;
*     _ jx_pos:  the modified x position of the plotting window;
*     _ jy_pos:  the modified y position of the plotting window;
*     _ xc_org:  the x origin of the coordinate system;
*     _ yc_org:  the y origin of the coordinate system;
*     _ xc_mul:  the x multiplier of the coordinate system;
*     _ yc_mul:  the y multiplier of the coordinate system;
*     _ xc_div:  the inverse x multiplier of the coordinate system;
*     _ yc_div:  the inverse y multiplier of the coordinate system;
*     _ del_int: the integral-curve integration interval;
*     _ avr_siz: the average linear coordinate-size of the window;
*     _ max_cnt: the maximum number of integration steps;
*     _ fnt_siz: the pixel-wise graphics text font size.
*     
*     Define the common block.
      common/local/
     *     id_vd,  id_xd,  id_fd,
     *     px_pos, py_pos,
     *     ip_but,
     *     del_xr, del_yi,
     *     asp_rt,
     *     ix_siz, iy_siz,
     *     jx_pos, jy_pos,
     *     xc_org, yc_org,
     *     xc_mul, yc_mul,
     *     xc_div, yc_div,
     *     del_int,
     *     avr_siz,
     *     max_cnt,
     *     fnt_siz
*     
*     A fixed parameter for the value of (2 * pi).
      parameter(twopi = 2.0 * 3.14159274)
*     
*     Define a series of name fo rthe color schemes.
*     
*     The normal one.
      parameter(ics_norm = 0)
*     
*     The reversed one.
      parameter(ics_reve = 1)
*     
*     The one for coordinate axes.
      parameter(ics_coor = 2)
*     
*     The one for integration contours.
      parameter(ics_cont = 3)
*     
*     The one for integral curves.
      parameter(ics_curv = 4)
*     
*     The one for roots.
      parameter(ics_root = 5)
*     
*     The one for singularities.
      parameter(ics_sing = 6)
*     
*     Make the common blocks persistent between calls.
      save /param/
      save /local/
